/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.oda.driver.impl;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.oda.IVeriniceOdaDriver;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.oda.driver.Activator;
import sernet.verinice.oda.driver.impl.LoadEntityValues;
import sernet.verinice.oda.driver.impl.MapEntityValues;
import sernet.verinice.oda.driver.impl.ParameterMetaData;
import sernet.verinice.oda.driver.impl.ResultSet;
import sernet.verinice.oda.driver.impl.ResultSetMetaData;
import sernet.verinice.security.report.ReportClassLoader;

public class Query
implements IQuery {
    public static final String ODA_DATA_SOURCE_ID = "verinice.oda.driver.dataSource.id";
    public static final String ODA_DATA_SET_ID = "verinice.oda.driver.dataSet.id";
    private static final Logger log = Logger.getLogger(Query.class);
    private int maxRows;
    private String queryText;
    private Integer vnRootElement;
    private Integer[] vnRootElements;
    private Interpreter setupInterpreter;
    private Interpreter interpreter;
    private Map<String, String> properties = new HashMap<String, String>();
    private Map<String, Object> inParameterValues = new HashMap<String, Object>();
    private Object result;
    private String[] columns;
    private String[] inParameters;
    public static final String PROP_SETUP_QUERY_TEXT = "setupQueryText";

    Query(Integer[] rootElementIds) {
        if (rootElementIds != null && rootElementIds.length == 1) {
            this.vnRootElement = rootElementIds[0];
            this.vnRootElements = null;
        } else {
            this.vnRootElement = -1;
            this.vnRootElements = rootElementIds != null ? (Integer[])rootElementIds.clone() : null;
        }
        this.init();
    }

    Query(Integer rootElementId) {
        this.vnRootElement = rootElementId;
        this.vnRootElements = null;
        this.init();
    }

    private void init() {
        IVeriniceOdaDriver odaDriver = Activator.getDefault().getOdaDriver();
        ReportClassLoader securedClassLoader = new ReportClassLoader(Query.class.getClassLoader());
        try {
            this.setupInterpreter = new Interpreter();
            this.setupInterpreter.setClassLoader((ClassLoader)securedClassLoader);
            this.setupInterpreter.set("__columns", null);
            this.setupInterpreter.eval("columns(c) { __columns = c; }");
            this.setupInterpreter.set("__inParameters", null);
            this.setupInterpreter.eval("inParameters(ip) { __inParameters = ip; }");
            this.setupInterpreter.set("helper", (Object)new Helper());
            this.interpreter = new Interpreter();
            this.interpreter.setClassLoader((ClassLoader)securedClassLoader);
            this.interpreter.set("_inpv", this.inParameterValues);
            this.interpreter.eval("inpv(s) { v = _inpv.get(s); return (v == null) ? \"input parameter value \" + s + \" does not exist.\" : v;}");
            this.interpreter.set("_vars", (Object)odaDriver.getScriptVariables());
            this.interpreter.eval("vars(s) { v = _vars.get(s); return (v == null) ? s + \" does not exist.\" : v;}");
            this.interpreter.set("helper", (Object)new Helper());
            this.interpreter.eval("gpt(entityType) { return helper.getAllPropertyTypes(entityType); }");
            this.interpreter.set("properties", this.properties);
        }
        catch (EvalError e) {
            log.error((Object)"Error while evaluating a BeanShell script for an ODA query.", (Throwable)e);
            throw new RuntimeException("Error while evaluating a BeanShell script for an ODA query.", e);
        }
        catch (RuntimeException e) {
            log.error((Object)"RuntimeException while creating an ODA query.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"Exception while creating an ODA query.", (Throwable)e);
            throw new RuntimeException("Error while evaluating a BeanShell script for an ODA query.", e);
        }
    }

    public void prepare(String queryText) throws OdaException {
        this.queryText = queryText;
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.queryText = null;
        this.result = null;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        this.runSetupQuery();
        this.runQuery();
        return new ResultSetMetaData(this.result, this.columns);
    }

    private void runSetupQuery() throws OdaException {
        try {
            this.doRunSetupQuery();
        }
        catch (EvalError evalError) {
            throw this.setTargetErrorAsCause(evalError);
        }
    }

    private void doRunSetupQuery() throws EvalError {
        String setupQueryText = this.properties.get(PROP_SETUP_QUERY_TEXT);
        if (setupQueryText == null) {
            return;
        }
        this.setupInterpreter.eval(setupQueryText);
        Object cols = this.setupInterpreter.get("__columns");
        this.columns = cols instanceof String[] ? (String[])cols : null;
        Object inp = this.setupInterpreter.get("__inParameters");
        this.inParameters = inp instanceof String[] ? (String[])inp : null;
    }

    private Object runQuery() throws OdaException {
        try {
            return this.doRunQuery();
        }
        catch (EvalError evalError) {
            throw this.setTargetErrorAsCause(evalError);
        }
    }

    private Object doRunQuery() throws EvalError {
        this.result = this.interpreter.eval(this.queryText);
        return this.result;
    }

    private OdaException setTargetErrorAsCause(EvalError evalError) {
        if (evalError instanceof TargetError) {
            Throwable target = ((TargetError)evalError).getTarget();
            return new OdaException(target);
        }
        return new OdaException((Throwable)evalError);
    }

    public IResultSet executeQuery() throws OdaException {
        this.runQuery();
        ResultSet resultSet = new ResultSet(this.result, this.columns);
        resultSet.setMaxRows(this.getMaxRows());
        return resultSet;
    }

    public void setProperty(String name, String value) throws OdaException {
        this.properties.put(name, value);
    }

    public void setMaxRows(int max) throws OdaException {
        this.maxRows = max;
    }

    public int getMaxRows() throws OdaException {
        return this.maxRows;
    }

    private void setValue(int parameterId, Object value) throws OdaException {
        try {
            this.doRunSetupQuery();
        }
        catch (EvalError evalError) {
            throw new OdaException((Throwable)evalError);
        }
        if (this.inParameters != null && this.inParameters.length >= parameterId) {
            this.inParameterValues.put(this.inParameters[parameterId - 1], value);
        }
    }

    public void clearInParameters() throws OdaException {
        this.inParameterValues.clear();
    }

    public void setInt(String parameterName, int value) throws OdaException {
        this.inParameterValues.put(parameterName, value);
    }

    public void setInt(int parameterId, int value) throws OdaException {
        this.setValue(parameterId, value);
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        this.inParameterValues.put(parameterName, value);
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        this.setValue(parameterId, value);
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        this.inParameterValues.put(parameterName, value);
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        this.setValue(parameterId, value);
    }

    public void setString(String parameterName, String value) throws OdaException {
        this.inParameterValues.put(parameterName, value);
    }

    public void setString(int parameterId, String value) throws OdaException {
        this.setValue(parameterId, value);
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        this.inParameterValues.put(parameterName, value);
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        this.setValue(parameterId, value);
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        this.inParameterValues.put(parameterName, value);
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        this.setValue(parameterId, value);
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        this.inParameterValues.put(parameterName, value);
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        this.setValue(parameterId, value);
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        this.inParameterValues.put(parameterName, value);
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        this.setValue(parameterId, value);
    }

    public void setObject(String parameterName, Object value) throws OdaException {
        this.inParameterValues.put(parameterName, value);
    }

    public void setObject(int parameterId, Object value) throws OdaException {
        this.setValue(parameterId, value);
    }

    public void setNull(String parameterName) throws OdaException {
        this.inParameterValues.put(parameterName, null);
    }

    public void setNull(int parameterId) throws OdaException {
        this.setValue(parameterId, null);
    }

    public int findInParameter(String parameterName) throws OdaException {
        int i = 0;
        while (i < this.inParameters.length) {
            if (this.inParameters[i].equals(parameterName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        this.runSetupQuery();
        return new ParameterMetaData(this.inParameters);
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        return null;
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public String getEffectiveQueryText() {
        return this.queryText;
    }

    public void cancel() throws OdaException {
        this.result = null;
    }

    public class Helper {
        public ICommand execute(ICommand c) {
            try {
                return Activator.getDefault().getCommandService().executeCommand(c);
            }
            catch (CommandException e) {
                log.error((Object)"Query Helper: running a command failed.", (Throwable)e);
                throw new IllegalStateException("Running the command failed.", e);
            }
        }

        public List<List<Object>> retrieveEntityValues(String typeId, String[] propertyNames) {
            return this.retrieveEntityValues(typeId, propertyNames, new Class[0]);
        }

        public List<List<Object>> retrieveEntityValues(String typeId, String[] propertyNames, Class<?>[] classes) {
            LoadEntityValues command = new LoadEntityValues(typeId, propertyNames, classes);
            try {
                command = (LoadEntityValues)Activator.getDefault().getCommandService().executeCommand((ICommand)command);
            }
            catch (CommandException e) {
                return Collections.emptyList();
            }
            return command.getResult();
        }

        public String[] getAllPropertyTypes(String entityTypeId) {
            return this.getAllPropertyTypes(entityTypeId, false);
        }

        public String[] getAllPropertyTypes(String entityTypeId, boolean withId) {
            HUITypeFactory htf = (HUITypeFactory)VeriniceContext.get((String)"huiTypeFactory");
            String[] props = htf.getEntityType(entityTypeId).getAllPropertyTypeIds();
            if (withId) {
                String[] arr = new String[props.length + 1];
                System.arraycopy(props, 0, arr, 0, props.length);
                arr[props.length] = "dbid";
                props = arr;
            }
            return props;
        }

        public List<List<Object>> map(List<CnATreeElement> input, String[] props) {
            return this.map(input, props, new Class[0]);
        }

        public List<List<Object>> map(List<CnATreeElement> input, String[] props, Class<?>[] classes, boolean addDbId) {
            if (input == null || input.size() == 0) {
                return new ArrayList<List<Object>>();
            }
            MapEntityValues cmd = new MapEntityValues(input.get(0).getEntityType().getId(), this.reduceToIDs(input), props, classes, addDbId);
            cmd = (MapEntityValues)this.execute((ICommand)cmd);
            return cmd.getResult();
        }

        public List<List<Object>> map(List<CnATreeElement> input, String[] props, Class<?>[] classes, boolean addDbId, boolean mapNumericalOptionValues) {
            if (input == null || input.size() == 0) {
                return new ArrayList<List<Object>>();
            }
            MapEntityValues cmd = new MapEntityValues(input.get(0).getEntityType().getId(), this.reduceToIDs(input), props, classes, addDbId, mapNumericalOptionValues);
            cmd = (MapEntityValues)this.execute((ICommand)cmd);
            return cmd.getResult();
        }

        public List<List<Object>> mapfast(List<CnATreeElement> elementList, String[] propertyIdArray) {
            if (elementList == null || elementList.size() == 0) {
                return new ArrayList<List<Object>>();
            }
            ArrayList<List<Object>> result = new ArrayList<List<Object>>(elementList.size());
            for (CnATreeElement element : elementList) {
                List<Object> row = LoadEntityValues.convertValuesToList(element.getEntity(), propertyIdArray);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding dbid: " + element.getDbId() + " to " + element.getTitle()));
                }
                row.add(element.getDbId().toString());
                result.add(row);
            }
            return result;
        }

        private List<Integer> reduceToIDs(List<CnATreeElement> input) {
            ArrayList<Integer> result_0 = new ArrayList<Integer>();
            for (CnATreeElement elmt : input) {
                result_0.add(elmt.getDbId());
            }
            return result_0;
        }

        public List<List<Object>> map(List<CnATreeElement> input, String[] props, boolean withDbId) {
            return this.map(input, props, new Class[0], withDbId);
        }

        public List<List<Object>> map(List<CnATreeElement> input, String[] props, Class<?>[] classes) {
            return this.map(input, props, classes, false);
        }

        public List<List<Object>> map(List<CnATreeElement> input, String[] props, boolean withDbId, boolean mapNumericalValues) {
            return this.map(input, props, new Class[0], withDbId, mapNumericalValues);
        }

        public Integer getRoot() {
            return Query.this.vnRootElement;
        }

        public Integer[] getRootElements() {
            if (Query.this.vnRootElements == null || Query.this.vnRootElements.length <= 0) {
                return new Integer[]{this.getRoot()};
            }
            return Query.this.vnRootElements;
        }

        public byte[] createImageResult(BufferedImage im) throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)im, "png", bos);
            return bos.toByteArray();
        }

        public Object arraycopy(Object sourceArray, int sourcePosition, Object destinationArray, int destinationPosition, int length) {
            System.arraycopy(sourceArray, sourcePosition, destinationArray, destinationPosition, length);
            return destinationArray;
        }
    }
}

