/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.oda.driver.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.IBaseDao;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.oda.driver.impl.LoadEntityValues;

public class MapEntityValues
extends GenericCommand {
    private List<List<Object>> result;
    private String[] propertyTypes;
    private Class<?>[] classes;
    private List<Integer> inputIDs;
    private static final Logger log = Logger.getLogger(MapEntityValues.class);
    private boolean addDbId;
    private String typeID;
    private boolean mapNumericalOptionValues = false;

    public MapEntityValues(String typeID, List<Integer> inputIDs, String[] props, Class<?>[] classes2, boolean addDbId) {
        this.typeID = typeID;
        this.inputIDs = inputIDs;
        this.propertyTypes = props != null ? (String[])props.clone() : null;
        this.classes = classes2 != null ? (Class[])classes2.clone() : null;
        this.addDbId = addDbId;
    }

    public MapEntityValues(String typeID, List<Integer> inputIDs, String[] props, Class<?>[] classes2, boolean addDbId, boolean mapNumericalOptionValues) {
        this(typeID, inputIDs, props, classes2, addDbId);
        this.mapNumericalOptionValues = mapNumericalOptionValues;
    }

    public void execute() {
        this.result = new ArrayList<List<Object>>(this.inputIDs.size());
        IBaseDao dao = this.getDaoFactory().getDAO(this.typeID);
        List elements = dao.findByCriteria(DetachedCriteria.forClass(CnATreeElement.class).add(Restrictions.in((String)"dbId", this.inputIDs)));
        Map elementsById = elements.stream().collect(Collectors.toMap(CnATreeElement::getDbId, Function.identity()));
        for (Integer dbid : this.inputIDs) {
            CnATreeElement e = (CnATreeElement)elementsById.get(dbid);
            List<Object> row = null;
            row = !this.mapNumericalOptionValues ? LoadEntityValues.retrievePropertyValues(e.getEntity(), this.propertyTypes, this.classes) : LoadEntityValues.retrievePropertyValues(e.getEntity(), this.propertyTypes, this.classes, this.mapNumericalOptionValues);
            if (this.addDbId) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding dbid: " + e.getDbId() + " to " + e.getTitle()));
                }
                row.add(e.getDbId().toString());
            }
            this.result.add(row);
        }
    }

    public List<List<Object>> getResult() {
        return this.result;
    }
}

