/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.oda.driver.impl;

import java.util.ArrayList;
import java.util.List;
import sernet.hui.common.connect.Entity;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.PropertyType;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.IBaseDao;
import sernet.verinice.model.common.CnATreeElement;

public class LoadEntityValues
extends GenericCommand {
    private List<List<Object>> result;
    private String typeId;
    private String[] propertyTypes;
    private Class<?>[] classes;

    public LoadEntityValues(String typeId, String[] propertyTypes) {
        this(typeId, propertyTypes, new Class[0]);
    }

    public LoadEntityValues(String typeId, String[] propertyTypes, Class<?>[] classes) {
        this.typeId = typeId;
        this.propertyTypes = propertyTypes != null ? (String[])propertyTypes.clone() : null;
        this.classes = classes != null ? (Class[])classes.clone() : null;
    }

    public void execute() {
        IBaseDao dao = this.getDaoFactory().getDAO(this.typeId);
        List elements = dao.findAll();
        this.result = new ArrayList<List<Object>>(elements.size());
        for (CnATreeElement element : elements) {
            Entity e = element.getEntity();
            this.result.add(LoadEntityValues.retrievePropertyValues(e, this.propertyTypes, this.classes, false));
        }
    }

    public static List<Object> retrievePropertyValues(Entity e, String[] propertyTypes, Class<?>[] classes) {
        return LoadEntityValues.retrievePropertyValues(e, propertyTypes, classes, false);
    }

    public static List<Object> convertValuesToList(Entity entity, String[] propertyTypes) {
        ArrayList<Object> values = new ArrayList<Object>(propertyTypes.length);
        String[] stringArray = propertyTypes;
        int n = propertyTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyTypeId = stringArray[n2];
            PropertyType pType = HUITypeFactory.getInstance().getPropertyType(entity.getEntityType(), propertyTypeId);
            if (pType.getInputName().equals("numericoption")) {
                values.add(entity.getNumericValue(propertyTypeId));
            } else {
                values.add(entity.getSimpleValue(propertyTypeId));
            }
            ++n2;
        }
        return values;
    }

    public static List<Object> retrievePropertyValues(Entity entity, String[] propertyTypes, Class<?>[] classes, boolean mapNumericalOptionValues) {
        ArrayList<Object> values = new ArrayList<Object>(propertyTypes.length);
        int i = 0;
        String[] stringArray = propertyTypes;
        int n = propertyTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            PropertyType pType = HUITypeFactory.getInstance().getPropertyType(entity.getEntityType(), name);
            if (pType != null) {
                Class<?> c;
                Class<?> clazz = c = i >= classes.length ? null : classes[i];
                if (!(c != null && c != String.class || mapNumericalOptionValues && pType.getInputName().equals("numericoption"))) {
                    if (pType.getInputName().equals("numericoption")) {
                        values.add(entity.getNumericValue(name));
                    } else {
                        values.add(entity.getSimpleValue(name));
                    }
                } else if (pType.getInputName().equals("numericoption") && mapNumericalOptionValues) {
                    values.add(pType.getNameForValue(Integer.parseInt(entity.getValue(name))));
                } else if (c == Integer.class) {
                    values.add(String.valueOf(entity.getInt(name)));
                } else {
                    throw new IllegalArgumentException("Invalid class for propertyType '" + name + "'.");
                }
                ++i;
            }
            ++n2;
        }
        return values;
    }

    public List<List<Object>> getResult() {
        return this.result;
    }
}

