/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.oda.driver;

import java.util.Hashtable;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;
import sernet.gs.service.ReportTemplateDirectoryService;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.SpringClientPlugin;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.ILogPathService;
import sernet.verinice.interfaces.IMain;
import sernet.verinice.interfaces.IReportLocalTemplateDirectoryService;
import sernet.verinice.interfaces.oda.IVeriniceOdaDriver;
import sernet.verinice.oda.driver.impl.VeriniceOdaDriver;
import sernet.verinice.oda.driver.impl.VeriniceURLStreamHandlerService;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "sernet.verinice.oda.driver";
    private static Activator plugin;
    private VeriniceURLStreamHandlerService urlStreamHandlerService = new VeriniceURLStreamHandlerService();
    private ServiceTracker<IMain, IMain> mainTracker;
    private ServiceTracker<ICommandService, ICommandService> commandServiceTracker;
    private ServiceTracker<ILogPathService, ILogPathService> logPathTracker;
    private IReportLocalTemplateDirectoryService templateDirService;
    private VeriniceOdaDriver veriniceOdaDriver;
    private static final String WORK_OBJECTS = "workObjects";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("url.handler.protocol", new String[]{"verinice"});
        context.registerService(URLStreamHandlerService.class.getName(), (Object)this.urlStreamHandlerService, properties);
        this.templateDirService = new ReportTemplateDirectoryService();
        context.registerService(IReportLocalTemplateDirectoryService.class.getName(), (Object)this.templateDirService, null);
        this.mainTracker = new ServiceTracker(context, IMain.class.getName(), null);
        this.mainTracker.open();
        this.commandServiceTracker = new ServiceTracker(context, ICommandService.class.getName(), null);
        this.commandServiceTracker.open();
        this.logPathTracker = new ServiceTracker(context, ILogPathService.class.getName(), null);
        this.logPathTracker.open();
        this.veriniceOdaDriver = new VeriniceOdaDriver();
        context.registerService(IVeriniceOdaDriver.class.getName(), (Object)this.veriniceOdaDriver, null);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.mainTracker.close();
        this.commandServiceTracker.close();
        this.logPathTracker.close();
    }

    public static Activator getDefault() {
        return plugin;
    }

    public VeriniceURLStreamHandlerService getURLStreamHandlerService() {
        return this.urlStreamHandlerService;
    }

    public IVeriniceOdaDriver getOdaDriver() {
        return this.veriniceOdaDriver;
    }

    public IMain getMain() {
        return (IMain)this.mainTracker.getService();
    }

    public ICommandService getCommandService() {
        this.inheritVeriniceContext();
        if (this.getPreferenceStore().getBoolean("report_use_cache")) {
            return (ICommandService)VeriniceContext.get((String)"commandCacheClient");
        }
        return (ICommandService)VeriniceContext.get((String)"commandService");
    }

    private void inheritVeriniceContext() {
        VeriniceContext.State state = (VeriniceContext.State)SpringClientPlugin.getDefault().getBeanFactory().getBean(WORK_OBJECTS);
        VeriniceContext.setState((VeriniceContext.State)state);
    }

    public ILogPathService getLogPathService() {
        return (ILogPathService)this.logPathTracker.getService();
    }

    public IReportLocalTemplateDirectoryService getIReportTemplateDirectoryService() {
        return this.templateDirService;
    }

    public String[] getClassificationHints() {
        String hints = this.getPreferenceStore().getString("report_classification_hints");
        return hints.split("///");
    }
}

