/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.kerberos.ticket;

import com.google.common.io.BaseEncoding;
import com.sun.jna.platform.win32.Sspi;
import javax.naming.AuthenticationNotSupportedException;
import org.apache.log4j.Logger;
import sernet.verinice.kerberos.Activator;
import sernet.verinice.kerberos.ticket.KerberosStatusServiceImpl;
import sernet.verinice.service.auth.KerberosTicketService;
import waffle.windows.auth.IWindowsCredentialsHandle;
import waffle.windows.auth.impl.WindowsAccountImpl;
import waffle.windows.auth.impl.WindowsCredentialsHandleImpl;
import waffle.windows.auth.impl.WindowsSecurityContextImpl;

public class KerberosTicketServiceWindowsImpl
implements KerberosTicketService {
    private static Logger LOG = Logger.getLogger(KerberosStatusServiceImpl.class);
    private String clientToken;
    private IWindowsCredentialsHandle clientCredentials;
    private WindowsSecurityContextImpl clientContext;

    public String getClientToken() {
        this.clientCredentials = WindowsCredentialsHandleImpl.getCurrent((String)"NEGOTIATE");
        this.clientCredentials.initialize();
        this.clientContext = new WindowsSecurityContextImpl();
        this.clientContext.setPrincipalName(WindowsAccountImpl.getCurrentUsername());
        this.clientContext.setCredentialsHandle(this.clientCredentials.getHandle());
        this.clientContext.setSecurityPackage("NEGOTIATE");
        this.clientContext.initialize(this.clientContext.getHandle(), null, this.getADServiceName());
        this.clientToken = "NEGOTIATE " + BaseEncoding.base64().encode(this.clientContext.getToken());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("client AD token: " + this.clientToken));
        }
        return this.clientToken;
    }

    public String updateClientToken(String serviceNegatiationAnswer) {
        byte[] continueTokenBytes = BaseEncoding.base64().decode((CharSequence)serviceNegatiationAnswer);
        if (continueTokenBytes.length > 0) {
            Sspi.SecBufferDesc continueTokenBuffer = new Sspi.SecBufferDesc(2, continueTokenBytes);
            this.clientContext.initialize(this.clientContext.getHandle(), continueTokenBuffer, this.getADServiceName());
            return "NEGOTIATE " + BaseEncoding.base64().encode(this.clientContext.getToken());
        }
        throw new RuntimeException(new AuthenticationNotSupportedException("no continue token was sent by the server"));
    }

    private String getADServiceName() {
        return Activator.getDefault().getPreferenceStore().getString("verinicepro");
    }
}

