/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.kerberos.preferences;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.Workbench;
import sernet.verinice.kerberos.Activator;
import sernet.verinice.kerberos.preferences.Messages;

public class KerberosPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static Logger LOG = Logger.getLogger(KerberosPreferencePage.class);
    private StringFieldEditor aDServiceName;
    private String initialADServiceName;
    private boolean initialKerberosStatus;
    private BooleanFieldEditor activate;

    public KerberosPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setTitle(Messages.KerberosPreferencePage_0);
    }

    public void createFieldEditors() {
        this.activate = new BooleanFieldEditor("kerberos_status", Messages.KerberosPreferencePage_2, this.getFieldEditorParent());
        this.aDServiceName = new StringFieldEditor("verinicepro", Messages.KerberosPreferencePage_3, this.getFieldEditorParent());
        this.aDServiceName.setEnabled(this.initialKerberosStatus, this.getFieldEditorParent());
        this.addField((FieldEditor)this.activate);
        this.addField((FieldEditor)this.aDServiceName);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.activate) {
            this.aDServiceName.setEnabled(this.activate.getBooleanValue(), this.getFieldEditorParent());
        }
    }

    public boolean performOk() {
        boolean status = super.performOk();
        if (this.activate.getBooleanValue() != this.initialKerberosStatus || !this.initialADServiceName.equals(this.aDServiceName.getStringValue())) {
            this.restartMessageDialog();
        }
        return status;
    }

    public void init(IWorkbench workbench) {
        this.initialKerberosStatus = this.getPreferenceStore().getBoolean("kerberos_status");
        this.initialADServiceName = this.getPreferenceStore().getString("verinicepro");
        this.noDefaultAndApplyButton();
    }

    public void restartMessageDialog() {
        Thread restart = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    LOG.error((Object)"error while storing ad sso configuration occurred.", (Throwable)e);
                }
                KerberosPreferencePage.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog mDialog = new MessageDialog(Display.getDefault().getActiveShell(), Messages.KerberosPreferencePage_4, null, Messages.KerberosPreferencePage_5, 3, new String[]{Messages.KerberosPreferencePage_6, Messages.KerberosPreferencePage_7}, 1);
                        int result = mDialog.open();
                        if (result == 1) {
                            Workbench.getInstance().restart();
                        }
                    }
                });
            }
        });
        restart.start();
    }

    static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

