/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.fei.service;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import sernet.gs.service.RetrieveInfo;
import sernet.verinice.interfaces.GenericCommand;
import sernet.verinice.interfaces.IBaseDao;
import sernet.verinice.interfaces.IRetrieveInfo;
import sernet.verinice.model.common.CnATreeElement;

public class PathFinderCommand
extends GenericCommand {
    private static final Logger log = Logger.getLogger(PathFinderCommand.class);
    private static final String PARENT = "..";
    private String path;
    private String uuidStart;
    private CnATreeElement target = null;
    private transient IBaseDao<CnATreeElement, Serializable> dao;

    public PathFinderCommand(String uuid, String path) {
        this.path = path;
        this.uuidStart = uuid;
    }

    public void execute() {
        if (this.path == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.path, "/");
        if (!st.hasMoreElements()) {
            return;
        }
        this.traverse(this.uuidStart, st);
    }

    private void traverse(String uuid, StringTokenizer st) {
        if (!st.hasMoreTokens()) {
            this.loadTarget(uuid);
            return;
        }
        String next = st.nextToken();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Next token: " + next));
        }
        RetrieveInfo ri = new RetrieveInfo();
        if (next.equals(PARENT)) {
            ri.setParent(true);
        } else {
            ri.setChildren(true);
            ri.setChildrenProperties(true);
        }
        CnATreeElement startGroup = (CnATreeElement)this.getDao().findByUuid(uuid, (IRetrieveInfo)ri);
        if (next.equals(PARENT)) {
            this.traverse(startGroup.getParent().getUuid(), st);
        } else {
            CnATreeElement child = this.findChild(startGroup, next);
            if (child != null) {
                this.traverse(child.getUuid(), st);
            }
        }
    }

    private void loadTarget(String uuid) {
        this.target = (CnATreeElement)this.getDao().findByUuid(uuid, (IRetrieveInfo)RetrieveInfo.getPropertyInstance());
    }

    private CnATreeElement findChild(CnATreeElement element, String name) {
        for (CnATreeElement child : element.getChildren()) {
            if (!child.getTitle().startsWith(name)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Child found: " + child.getTitle()));
            }
            return child;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Child not found, token " + name));
        }
        return null;
    }

    public CnATreeElement getTarget() {
        return this.target;
    }

    private IBaseDao<CnATreeElement, Serializable> getDao() {
        if (this.dao == null) {
            this.dao = this.getDaoFactory().getDAO(CnATreeElement.class);
        }
        return this.dao;
    }
}

