/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.desktop.integration.preferences;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sernet.verinice.desktop.integration.Activator;
import sernet.verinice.desktop.integration.preferences.Messages;

public class DesktopIntegrationPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private final Path desktopFilePath = Paths.get(System.getProperty("user.home"), ".local/share/applications/verinice.desktop");
    private final Logger logger = LoggerFactory.getLogger(DesktopIntegrationPreferencePage.class);

    public DesktopIntegrationPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.DesktopIntegrationPreferencePage_Description);
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("SHORTCUT_EXISTS", Messages.DesktopIntegrationPreferencePage_ShowInMenu, 0, this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
        this.getPreferenceStore().setValue("SHORTCUT_EXISTS", this.desktopFilePath.toFile().exists());
    }

    public boolean performOk() {
        if (!super.performOk()) {
            return false;
        }
        try {
            if (this.getPreferenceStore().getBoolean("SHORTCUT_EXISTS")) {
                List<String> lines = this.getDesktopFileLines();
                Files.write(this.desktopFilePath, lines, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
            } else {
                Files.delete(this.desktopFilePath);
            }
        }
        catch (IOException e) {
            this.logger.error("Error handling desktop file.", (Throwable)e);
        }
        return true;
    }

    private List<String> getDesktopFileLines() {
        File launcher = new File(System.getProperty("eclipse.launcher"));
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("[Desktop Entry]");
        lines.add("Encoding=UTF-8");
        lines.add("Version=1.0");
        lines.add("Type=Application");
        lines.add("Terminal=false");
        lines.add(String.format("Exec=%s", launcher.getAbsolutePath()));
        lines.add("Name=verinice.");
        lines.add(String.format("Icon=%s/icon.xpm", launcher.getParent()));
        lines.add("Categories=Office");
        return lines;
    }
}

