/*
 * Decompiled with CFR 0.152.
 */
package sernet.snutils;

import java.sql.Date;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import sernet.snutils.AssertException;
import sernet.snutils.DBException;

public final class FormInputParser {
    private static final String DEFAULT_DATE_PATTERN = "EEE, dd.MM.yyyy";
    private static final DateTimeFormatter DEFAULT_DATE_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd.MM.yyyy");
    private static final DateTimeFormatter GERMAN_DATE_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    @Deprecated
    public static final SimpleDateFormat DATE_FORMAT_DEFAULT = FormInputParser.createDateFormat("EEE, dd.MM.yyyy");
    private static final boolean GROUPING = true;

    public static float stringToCurrency(String fieldName, String s) throws DBException {
        try {
            return FormInputParser.createPriceFormat().parse(s).floatValue();
        }
        catch (ParseException e) {
            try {
                return FormInputParser.createNumberFormat().parse(s).floatValue();
            }
            catch (ParseException e1) {
                throw new DBException("Wrong format for " + fieldName + ".");
            }
        }
    }

    public static String currencyToString(float value) {
        return FormInputParser.createPriceFormat().format(value);
    }

    public static float stringToFloat(String fieldName, String s) throws DBException {
        try {
            return FormInputParser.createNumberFormat().parse(s).floatValue();
        }
        catch (ParseException e) {
            throw new DBException("Wrong format for " + fieldName + ".");
        }
    }

    public static short stringToShort(String fieldName, String s) throws DBException {
        try {
            return FormInputParser.createNumberFormat().parse(s).shortValue();
        }
        catch (ParseException e) {
            throw new DBException("Wrong format for " + fieldName + ".");
        }
    }

    public static String dateToString(Date date) throws AssertException {
        block3: {
            try {
                if (date != null) break block3;
                return "";
            }
            catch (DateTimeException e) {
                throw new AssertException("Wrong / missing date: " + date.toString());
            }
        }
        return DEFAULT_DATE_FORMATTER.format(Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()));
    }

    public static Date stringToDate(String string) throws AssertException {
        if (string == null || string.length() < 5) {
            throw new AssertException("Wrong / missing date: " + string);
        }
        DateTimeFormatter formatter = string.charAt(2) == '.' ? GERMAN_DATE_FORMATTER : (string.charAt(4) == '-' ? DateTimeFormatter.ISO_LOCAL_DATE : DEFAULT_DATE_FORMATTER);
        try {
            return new Date(formatter.parse((CharSequence)string, LocalDate::from).atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli());
        }
        catch (DateTimeParseException e) {
            throw new AssertException("Wrong / missing date: " + string);
        }
    }

    public static String floatToString(float f) {
        return FormInputParser.createNumberFormat().format(f);
    }

    private static SimpleDateFormat createDateFormat(String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setLenient(true);
        return dateFormat;
    }

    private static NumberFormat createNumberFormat() {
        NumberFormat numFmt = NumberFormat.getNumberInstance(Locale.GERMANY);
        numFmt.setGroupingUsed(true);
        return numFmt;
    }

    private static NumberFormat createPriceFormat() {
        NumberFormat priceFmt = NumberFormat.getCurrencyInstance(Locale.GERMANY);
        priceFmt.setGroupingUsed(true);
        return priceFmt;
    }

    private FormInputParser() {
    }
}

