/*
 * Decompiled with CFR 0.152.
 */
package sernet.hui.common.rules;

import org.apache.log4j.Logger;
import sernet.hui.common.rules.IFillRule;
import sernet.hui.common.rules.IValidationRule;
import sernet.hui.common.rules.NullRule;

public abstract class RuleFactory {
    private static final Logger LOG = Logger.getLogger(RuleFactory.class);
    private static final String STD_ERR_MSG = "Klasse f\u00fcr angegebene Regel nicht gefunden: ";

    public static IFillRule getDefaultRule(String name) {
        try {
            IFillRule rule = (IFillRule)Class.forName("sernet.hui.common.rules." + name).newInstance();
            return rule;
        }
        catch (InstantiationException e) {
            LOG.error((Object)(STD_ERR_MSG + name));
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)(STD_ERR_MSG + name));
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)(STD_ERR_MSG + name));
        }
        return new NullRule();
    }

    public static IValidationRule getValidationRule(String name) {
        try {
            IValidationRule rule = (IValidationRule)Class.forName("sernet.hui.common.rules." + name).newInstance();
            return rule;
        }
        catch (InstantiationException e) {
            LOG.error((Object)(STD_ERR_MSG + name));
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)(STD_ERR_MSG + name));
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)(STD_ERR_MSG + name));
        }
        return null;
    }
}

