/*
 * Decompiled with CFR 0.152.
 */
package sernet.hui.common.rules;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;
import sernet.hui.common.rules.IValidationRule;
import sernet.hui.common.rules.Messages;

public class DateBeforeRule
implements IValidationRule {
    private String hint = Messages.DateBeforeDefaultHint;
    private static final Logger log = Logger.getLogger(DateBeforeRule.class);
    private static final String PATTERN = "dd.MM.yyyy";
    private Date compareDate;
    private SimpleDateFormat formatter;

    @Override
    public boolean validate(String userInput, String[] params) {
        String input = userInput;
        Long millis = null;
        try {
            millis = Long.parseLong(input);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(millis);
            input = String.valueOf(calendar.get(5)) + "." + (calendar.get(2) + 1) + "." + calendar.get(1);
        }
        catch (NumberFormatException calendar) {
            // empty catch block
        }
        if (this.formatter != null && input != null) {
            try {
                Date userDate = this.formatter.parse(input);
                return userDate.before(this.compareDate);
            }
            catch (Exception e) {
                log.error((Object)"user given date unparseable", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public String getHint() {
        return this.hint;
    }

    @Override
    public void init(String[] params, String hint) {
        this.formatter = new SimpleDateFormat(PATTERN, Locale.getDefault());
        this.formatter.setLenient(true);
        try {
            if (params != null && params.length == 1) {
                this.compareDate = this.formatter.parse(params[0]);
            }
            this.hint = hint != null && !hint.equals("") ? hint : Messages.DateBeforeDefaultHint;
        }
        catch (ParseException e) {
            log.error((Object)"Date specified by parameter not parseable", (Throwable)e);
            this.compareDate = null;
        }
    }
}

