/*
 * Decompiled with CFR 0.152.
 */
package sernet.hui.common.multiselectionlist;

import java.util.ArrayList;
import java.util.List;
import sernet.hui.common.connect.Entity;
import sernet.hui.common.connect.Property;
import sernet.hui.common.connect.PropertyOption;
import sernet.hui.common.connect.PropertyType;
import sernet.hui.common.multiselectionlist.IMLPropertyOption;

public class OptionSelectionHelper {
    public static String loadOptionLabels(Entity entity, PropertyType type) {
        List<Property> properties = entity.getProperties(type.getId()).getProperties();
        if (properties == null) {
            return "";
        }
        List<String> optionIds = OptionSelectionHelper.getPropertiesIds(properties);
        return OptionSelectionHelper.loadOptionLabels(type, optionIds);
    }

    public static String loadOptionLabels(PropertyType type, List<String> optionIds) {
        StringBuilder referenceLabels = new StringBuilder();
        for (String optionId : optionIds) {
            PropertyOption option = type.getOption(optionId);
            if (option == null) continue;
            String optionName = option.getName();
            if (referenceLabels.length() == 0) {
                referenceLabels.append(optionName);
                continue;
            }
            referenceLabels.append(" / ");
            referenceLabels.append(optionName);
        }
        return referenceLabels.toString();
    }

    public static String loadReferenceLabels(Entity entity, PropertyType type) {
        List<Property> properties = entity.getProperties(type.getId()).getProperties();
        if (properties == null) {
            return "";
        }
        List<String> referencedIds = OptionSelectionHelper.getPropertiesIds(properties);
        return OptionSelectionHelper.loadReferenceLabels(type, referencedIds);
    }

    public static String loadReferenceLabels(PropertyType type, List<String> referencedIds) {
        StringBuilder referenceLabels = new StringBuilder();
        for (String referencedId : referencedIds) {
            String referenceName = OptionSelectionHelper.loadReferenceLabel(type, referencedId);
            if (referenceName == null) continue;
            if (referenceLabels.length() == 0) {
                referenceLabels.append(referenceName);
                continue;
            }
            referenceLabels.append(" / ");
            referenceLabels.append(referenceName);
        }
        return referenceLabels.toString();
    }

    private static List<String> getPropertiesIds(List<Property> properties) {
        ArrayList<String> referencedIds = new ArrayList<String>(properties.size());
        for (Property property : properties) {
            referencedIds.add(property.getPropertyValue());
        }
        return referencedIds;
    }

    private static String loadReferenceLabel(PropertyType type, String referencedId) {
        IMLPropertyOption ref = OptionSelectionHelper.getEntity(type, referencedId);
        if (ref == null) {
            return null;
        }
        return ref.getName();
    }

    private static IMLPropertyOption getEntity(PropertyType type, String referencedId) {
        for (IMLPropertyOption entity : type.getReferencedEntities()) {
            if (!entity.getId().equals(referencedId)) continue;
            return entity;
        }
        return null;
    }
}

