/*
 * Decompiled with CFR 0.152.
 */
package sernet.hui.common.connect;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class URLUtil {
    private static Pattern pattern = Pattern.compile("<a href=\"(.*)\">(.*)</a>");

    private URLUtil() {
    }

    public static String getHref(String aHtml) {
        Matcher matcher = pattern.matcher(aHtml);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String getName(String aHtml) {
        Matcher matcher = pattern.matcher(aHtml);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return "";
    }

    public static String createLinkForSpreadsheet(String aHtml) {
        return URLUtil.createLinkForSpreadsheet(URLUtil.getHref(aHtml), URLUtil.getName(aHtml));
    }

    public static String createLinkForSpreadsheet(String url, String title) {
        StringBuilder sb = new StringBuilder();
        sb.append("=HYPERLINK(\"");
        sb.append(url);
        sb.append("\";\"");
        sb.append(title);
        sb.append("\")");
        String getLinkForSpreadsheet = sb.toString();
        return getLinkForSpreadsheet;
    }
}

