/*
 * Decompiled with CFR 0.152.
 */
package sernet.hui.common.connect;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import sernet.hui.common.connect.StreamResourceBundle;

public class SNCAResourceBundleLoader
extends ResourceBundle.Control {
    private final Logger log = Logger.getLogger(SNCAResourceBundleLoader.class);
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String JNDI = "jndi";
    private static final String BUNDLERESOURCE = "bundleresource";
    private static final String BUNDLEENTRY = "bundleentry";
    private static final String FILE = "file";
    public static final List<String> PROTOCOL_LIST = Arrays.asList("http", "https", "jndi", "bundleresource", "bundleentry", "file");
    private String baseUrl;

    public SNCAResourceBundleLoader(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public List<String> getFormats(String baseName) {
        return Collections.singletonList("properties");
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        StreamResourceBundle bundle = null;
        if (baseName == null || locale == null || format == null || loader == null) {
            return null;
        }
        if (!format.equals("properties")) {
            return null;
        }
        String bundleName = this.toBundleName(baseName, locale);
        String resourceName = this.toResourceName(bundleName, format);
        InputStream stream = null;
        String protocol = SNCAResourceBundleLoader.getProtocol(this.baseUrl);
        if (HTTP.equals(protocol) || HTTPS.equals(protocol)) {
            stream = this.createHttpStream(resourceName, reload);
        } else if (PROTOCOL_LIST.contains(protocol)) {
            stream = this.createUrlStream(resourceName);
        } else {
            this.log.error((Object)("Url is not supported: " + this.baseUrl + ". Only http(s) or jndi Urls are supported"));
        }
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(stream);
            bundle = new StreamResourceBundle(bis);
            bis.close();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
        }
        return bundle;
    }

    private InputStream createUrlStream(String resourceName) throws IOException {
        String fullResourceName = String.valueOf(this.baseUrl) + resourceName;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading resource bundle via url: " + fullResourceName));
        }
        URL url = new URL(fullResourceName);
        InputStream stream = url.openStream();
        return stream;
    }

    private InputStream createHttpStream(String resourceName, boolean reload) throws IOException {
        URL proxy;
        HttpURLConnection httpProxy;
        String separator = "?";
        if (this.baseUrl.contains("?")) {
            separator = "&";
        }
        String fullResourceName = String.valueOf(this.baseUrl) + separator + "resource=" + resourceName;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading resource bundle via url: " + fullResourceName));
        }
        if ((httpProxy = (HttpURLConnection)(proxy = new URL(fullResourceName)).openConnection()) == null) {
            return null;
        }
        if (reload) {
            httpProxy.setUseCaches(false);
        }
        InputStream stream = httpProxy.getInputStream();
        return stream;
    }

    public static String getProtocol(String url) {
        String protocol = null;
        if (url != null && url.contains(":")) {
            protocol = url.substring(0, url.indexOf(58));
        }
        return protocol;
    }
}

