/*
 * Decompiled with CFR 0.152.
 */
package sernet.hui.common.connect;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import sernet.hui.common.connect.SNCAResourceBundleLoader;

public class SNCAMessages {
    private static final Logger LOG = Logger.getLogger(SNCAMessages.class);
    public static final String BUNDLE_NAME = "snca-messages";
    public static final String BUNDLE_EXTENSION = "properties";
    private ResourceBundle resourceBundle;
    private String baseUrl;

    public SNCAMessages(String baseUrl) {
        this.setBaseUrl(baseUrl);
    }

    String getString(String key) {
        String resource = null;
        try {
            ResourceBundle bundle = this.getResourceBundle();
            if (bundle != null) {
                resource = bundle.getString(key);
            }
        }
        catch (MissingResourceException e) {
            if (LOG.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("missing resource: ").append(key);
                sb.append(", baseUrl: ").append(this.baseUrl);
                sb.append(", bundle-name: ").append(BUNDLE_NAME);
                LOG.debug((Object)sb.toString());
            }
            return null;
        }
        return resource;
    }

    private ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            if (this.getBaseUrl() == null) {
                LOG.error((Object)"Can not load resource bundle. Base url is null");
                return null;
            }
            String protocol = SNCAResourceBundleLoader.getProtocol(this.getBaseUrl());
            if (protocol == null || !SNCAResourceBundleLoader.PROTOCOL_LIST.contains(protocol)) {
                LOG.error((Object)("Can not load resource bundle. Protocol is not supported: " + protocol));
                return null;
            }
            this.resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, new SNCAResourceBundleLoader(this.getBaseUrl()));
        }
        return this.resourceBundle;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl != null && baseUrl.endsWith("SNCA.xml") ? baseUrl.substring(0, baseUrl.indexOf("SNCA.xml")) : baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

