/*
 * Decompiled with CFR 0.152.
 */
package sernet.hui.common.connect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import sernet.hui.common.connect.DependsType;
import sernet.hui.common.connect.HuiUrl;
import sernet.hui.common.connect.IEntityElement;
import sernet.hui.common.connect.IReferenceResolver;
import sernet.hui.common.connect.IUrlResolver;
import sernet.hui.common.connect.Property;
import sernet.hui.common.connect.PropertyOption;
import sernet.hui.common.multiselectionlist.IMLPropertyOption;
import sernet.hui.common.multiselectionlist.IMLPropertyType;
import sernet.hui.common.rules.IFillRule;
import sernet.hui.common.rules.IValidationRule;
import sernet.hui.common.rules.NullRule;

public class PropertyType
implements IMLPropertyType,
IEntityElement,
Comparable<PropertyType>,
Serializable {
    private final Logger log = Logger.getLogger(PropertyType.class);
    private String id;
    private String name;
    private Set<DependsType> dependencies = new HashSet<DependsType>();
    private String inputName;
    private byte inputtype = 0;
    public static final byte INPUT_LINE = 0;
    public static final byte INPUT_TEXT = 1;
    public static final byte INPUT_SINGLEOPTION = 2;
    public static final byte INPUT_MULTIOPTION = 3;
    public static final byte INPUT_REFERENCE = 5;
    public static final byte INPUT_DATE = 6;
    private static final byte INPUT_NUMERICOPTION = 7;
    private static final byte INPUT_BOOLEANOPTION = 8;
    private static final byte INPUT_CNALINK_REFERENCE = 9;
    private List<IValidationRule> validators = new ArrayList<IValidationRule>();
    private IFillRule defaultRule = new NullRule();
    private boolean required = false;
    private List options = new ArrayList();
    private String tooltiptext = "";
    private boolean initialfocus;
    private boolean editable;
    private boolean visible;
    private boolean isURL;
    private String referencedEntityTypeId;
    private String referencedCnaLinkType;
    private IReferenceResolver referenceResolver;
    private IUrlResolver urlResolver;
    private boolean crudButtons;
    private int minValue = 0;
    private int maxValue = 0;
    private boolean reportable;
    private int numericDefault;
    private String tags;
    private int textrows;
    private boolean showInObjectBrowser;

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public boolean isCrudButtons() {
        return this.crudButtons;
    }

    public void setNumericDefault(String numericDefault) {
        try {
            this.numericDefault = Integer.parseInt(numericDefault);
        }
        catch (NumberFormatException e) {
            this.log.warn((Object)("Not a valid number: " + numericDefault));
        }
    }

    public boolean isReportable() {
        return this.reportable;
    }

    public void addValidator(IValidationRule rule) {
        if (!this.validators.contains(rule)) {
            this.validators.add(rule);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public IFillRule getDefaultRule() {
        return this.defaultRule;
    }

    public void setDefaultRule(IFillRule defaultRule) {
        this.defaultRule = defaultRule;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<IMLPropertyOption> getOptions() {
        return this.options;
    }

    public PropertyOption getOption(String id) {
        for (PropertyOption option : this.options) {
            if (!option.getId().equals(id)) continue;
            return option;
        }
        return null;
    }

    public PropertyOption getOption(Integer id) {
        for (PropertyOption option : this.options) {
            if (!option.getValue().equals(id)) continue;
            return option;
        }
        return null;
    }

    public void setPredefinedValues(List predefinedValues) {
        this.options = predefinedValues;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getTooltiptext() {
        return this.tooltiptext;
    }

    public void setTooltiptext(String tooltiptext) {
        this.tooltiptext = tooltiptext;
    }

    public void setDependencies(Set<DependsType> set) {
        this.dependencies = set;
    }

    public Set<DependsType> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean isMultiselect() {
        return this.inputtype == 3;
    }

    public boolean isSingleSelect() {
        return this.inputtype == 2;
    }

    public boolean isNumericSelect() {
        return this.inputtype == 7;
    }

    public boolean isBooleanSelect() {
        return this.inputtype == 8;
    }

    public boolean isEnum() {
        return this.inputtype == 2 || this.inputtype == 3;
    }

    public boolean isLine() {
        return this.inputtype == 0;
    }

    public boolean isReference() {
        return this.inputtype == 5;
    }

    public boolean isCnaLinkReference() {
        return this.inputtype == 9;
    }

    public boolean isText() {
        return this.inputtype == 1;
    }

    public boolean isDate() {
        return this.inputtype == 6;
    }

    public void setInputType(String attribute) {
        this.inputName = attribute;
        if (attribute.equals("line")) {
            this.inputtype = 0;
        } else if (attribute.equals("singleoption")) {
            this.inputtype = (byte)2;
        } else if (attribute.equals("multioption")) {
            this.inputtype = (byte)3;
        } else if (attribute.equals("text")) {
            this.inputtype = 1;
        } else if (attribute.equals("reference")) {
            this.inputtype = (byte)5;
        } else if (attribute.equals("date")) {
            this.inputtype = (byte)6;
        } else if (attribute.equals("numericoption")) {
            this.inputtype = (byte)7;
        } else if (attribute.equals("booleanoption")) {
            this.inputtype = (byte)8;
        } else if (attribute.equals("cnalink-reference")) {
            this.inputtype = (byte)9;
        }
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInitialFocus(boolean b) {
        this.initialfocus = b;
    }

    public boolean isFocus() {
        return this.initialfocus;
    }

    public List<IValidationRule> getValidators() {
        return this.validators;
    }

    public void setValidators(List<IValidationRule> validators) {
        this.validators = validators;
    }

    public Map<String, Boolean> validate(String text, String[] params) {
        HashMap<String, Boolean> validationResults = new HashMap<String, Boolean>();
        for (IValidationRule validator : this.validators) {
            boolean result = validator.validate(text, params);
            validationResults.put(validator.getHint(), result);
            if (!this.log.isDebugEnabled() || result) continue;
            this.log.debug((Object)("validation for " + this.name + " (" + this.id + ")\t" + "returned\t" + result + "\thint:\t" + validator.getHint()));
        }
        return validationResults;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setURL(boolean url) {
        this.isURL = url;
    }

    public boolean isURL() {
        return this.isURL;
    }

    public void setReferencedEntityType(String attribute) {
        this.referencedEntityTypeId = attribute;
    }

    public void setReferencedCnaLinkType(String attribute) {
        this.referencedCnaLinkType = attribute;
    }

    public String getReferencedEntityTypeId() {
        return this.referencedEntityTypeId;
    }

    public String getReferencedCnaLinkType() {
        return this.referencedCnaLinkType;
    }

    public List<IMLPropertyOption> getReferencedEntities() {
        if (this.referenceResolver != null) {
            return this.referenceResolver.getAllEntitesForType(this.referencedEntityTypeId);
        }
        return new ArrayList<IMLPropertyOption>();
    }

    public IReferenceResolver getReferenceResolver() {
        return this.referenceResolver;
    }

    public void setReferenceResolver(IReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public List<HuiUrl> getResolvedUrls() {
        if (this.urlResolver != null) {
            return this.urlResolver.resolve();
        }
        return new ArrayList<HuiUrl>();
    }

    public IUrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    public void setUrlResolver(IUrlResolver urlResolver) {
        this.urlResolver = urlResolver;
    }

    public void setCrudButtons(boolean b) {
        this.crudButtons = b;
    }

    public List<IMLPropertyOption> getReferencedEntities(List<Property> references) {
        if (this.referenceResolver != null) {
            return this.referenceResolver.getReferencedEntitesForType(this.referencedEntityTypeId, references);
        }
        return new ArrayList<IMLPropertyOption>();
    }

    public void setNumericMin(String minString) {
        try {
            this.minValue = Integer.parseInt(minString);
        }
        catch (NumberFormatException e) {
            this.log.warn((Object)("Not a valid number: " + minString));
        }
    }

    public void setNumericMax(String maxString) {
        try {
            this.maxValue = Integer.parseInt(maxString);
        }
        catch (NumberFormatException e) {
            this.log.warn((Object)("Not a valid number: " + maxString));
        }
    }

    public String getNameForValue(int i) {
        for (PropertyOption option : this.options) {
            if (option.getValue() == null || option.getValue() != i) continue;
            return option.getName();
        }
        return Integer.toString(i);
    }

    public void setReportable(boolean value) {
        this.reportable = value;
    }

    public int getNumericDefault() {
        return this.numericDefault;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTextRows(String rows) {
        this.textrows = Integer.parseInt(rows);
    }

    public int getTextrows() {
        return this.textrows;
    }

    public boolean isShowInObjectBrowser() {
        return this.showInObjectBrowser;
    }

    public void setShowInObjectBrowser(boolean showInObjectBrowser) {
        this.showInObjectBrowser = showInObjectBrowser;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyType other = (PropertyType)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public int compareTo(PropertyType o) {
        int less = -1;
        boolean equal = false;
        boolean greater = true;
        int result = -1;
        if (o != null) {
            if (this.getId() == null) {
                result = o.getId() == null ? 0 : 1;
            } else if (o.getId() != null) {
                result = this.getId().compareTo(o.getId());
            }
        }
        return result;
    }

    public String toString() {
        return "PropertyType [id=" + this.id + ", name=" + this.name + ", dependencies=" + this.dependencies + ", inputName=" + this.inputName + ", inputtype=" + this.inputtype + ", defaultRule=" + this.defaultRule + ", required=" + this.required + ", options=" + this.options + ", tooltiptext=" + this.tooltiptext + ", initialfocus=" + this.initialfocus + ", editable=" + this.editable + ", visible=" + this.visible + ", isURL=" + this.isURL + ", referencedEntityTypeId=" + this.referencedEntityTypeId + ", referencedCnaLinkType=" + this.referencedCnaLinkType + ", referenceResolver=" + this.referenceResolver + ", urlResolver=" + this.urlResolver + ", crudButtons=" + this.crudButtons + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", reportable=" + this.reportable + ", numericDefault=" + this.numericDefault + ", tags=" + this.tags + ", textrows=" + this.textrows + ", showInObjectBrowser=" + this.showInObjectBrowser + "]";
    }
}

