/*
 * Decompiled with CFR 0.152.
 */
package sernet.hui.common.connect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import sernet.hui.common.connect.ITypedElement;
import sernet.hui.common.connect.Property;

public class PropertyList
implements Serializable,
ITypedElement {
    private List<Property> properties;
    private Integer dbId;
    private Integer entityId;
    private String uuid = UUID.randomUUID().toString();
    public static final String TYPE_ID = "huipropertylist";

    @Override
    public String getTypeId() {
        return TYPE_ID;
    }

    public Integer getDbId() {
        return this.dbId;
    }

    public void setDbId(Integer dbId) {
        this.dbId = dbId;
    }

    public PropertyList(int size) {
        this.properties = new ArrayList<Property>(size);
    }

    public PropertyList() {
        this(1);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof PropertyList && this.uuid.equals(((PropertyList)obj).getUuid());
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void add(Property prop) {
        this.properties.add(prop);
    }

    public Property getProperty(int idx) {
        if (this.properties != null && this.properties.size() > 0) {
            return this.properties.get(idx);
        }
        return null;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public Integer getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Integer entityId) {
        this.entityId = entityId;
    }

    public boolean isEmpty() {
        if (this.properties == null) {
            return true;
        }
        return this.properties.isEmpty();
    }

    public String toString() {
        return "PropertyList [properties=" + this.properties + ", dbId=" + this.dbId + ", entityId=" + this.entityId + ", uuid=" + this.uuid + "]";
    }
}

