/*
 * Decompiled with CFR 0.152.
 */
package sernet.hui.common.connect;

import java.io.Serializable;
import java.text.Normalizer;
import java.util.Calendar;
import sernet.hui.common.connect.Entity;
import sernet.hui.common.connect.ITypedElement;

public class Property
implements Serializable,
ITypedElement {
    private Integer dbId;
    private String propertyType;
    private String propertyValue;
    private Entity parent;
    private String licenseContentId;
    private Boolean limitedLicense = false;
    public static final String TYPE_ID = "huiproperty";
    public static final int UNDEF = 0;

    public Property(Entity ent) {
        this.parent = ent;
    }

    Property() {
    }

    public String getPropertyValue() {
        return Property.nfcNormalize(this.propertyValue);
    }

    public boolean isEmpty() {
        return this.getPropertyValue() == null || this.getPropertyValue().isEmpty();
    }

    public int getNumericPropertyValue() {
        try {
            return Integer.parseInt(this.propertyValue);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public String getTypeId() {
        return TYPE_ID;
    }

    public void setPropertyValue(String propertyValue, boolean fireChange, Object source) {
        this.propertyValue = Property.nfcNormalize(propertyValue);
        if (fireChange && this.parent != null) {
            this.parent.firePropertyChanged(this, source);
        }
    }

    public void setPropertyValue(String propertyValue, boolean fireChange) {
        this.setPropertyValue(propertyValue, fireChange, null);
    }

    public void setPropertyValue(Calendar calendar, boolean fireChange, Object source) {
        this.setPropertyValue(Property.convertCalendarToString(calendar), fireChange, source);
    }

    public void setPropertyValue(String propertyValue) {
        this.setPropertyValue(propertyValue, true, null);
    }

    public String getPropertyTypeID() {
        return this.propertyType;
    }

    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType.intern();
    }

    public Entity getParent() {
        return this.parent;
    }

    public void setParent(Entity parent) {
        this.parent = parent;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public String getLicenseContentId() {
        return this.licenseContentId;
    }

    public void setLicenseContentId(String licenseContentId) {
        this.licenseContentId = licenseContentId;
    }

    public Boolean isLimitedLicense() {
        return this.limitedLicense;
    }

    public void setLimitedLicense(Boolean limitedLicense) {
        this.limitedLicense = limitedLicense;
    }

    public Integer getDbId() {
        return this.dbId;
    }

    public void setDbId(Integer dbId) {
        this.dbId = dbId;
    }

    public Property copy(Entity parent) {
        Property property = new Property(parent);
        property.setPropertyType(this.getPropertyType());
        property.setPropertyValue(this.getPropertyValue(), false);
        property.setLimitedLicense(this.isLimitedLicense());
        property.setLicenseContentId(this.getLicenseContentId());
        return property;
    }

    public static final String convertCalendarToString(Calendar calendar) {
        return Long.toString(calendar.getTimeInMillis());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dbId == null ? 0 : this.dbId.hashCode());
        result = 31 * result + (this.propertyType == null ? 0 : this.propertyType.hashCode());
        result = 31 * result + (this.propertyValue == null ? 0 : this.propertyValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        if (this.dbId == null ? other.dbId != null : !this.dbId.equals(other.dbId)) {
            return false;
        }
        if (this.propertyType == null ? other.propertyType != null : !this.propertyType.equals(other.propertyType)) {
            return false;
        }
        return !(this.propertyValue == null ? other.propertyValue != null : !this.propertyValue.equals(other.propertyValue));
    }

    public String toString() {
        return "Property [dbId=" + this.dbId + ", propertyType=" + this.propertyType + ", propertyValue=" + this.propertyValue + "]";
    }

    private static String nfcNormalize(String value) {
        if (value != null && !value.isEmpty()) {
            return Normalizer.normalize(value, Normalizer.Form.NFC);
        }
        return value;
    }
}

