/*
 * Decompiled with CFR 0.152.
 */
package sernet.hui.common.connect;

import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import sernet.hui.common.connect.DirectedHuiRelation;
import sernet.hui.common.connect.EntityType;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.HitroUtil;
import sernet.hui.common.connect.HuiRelation;

public final class HuiRelationUtil {
    private static final HUITypeFactory huiTypeFactory = HitroUtil.getInstance().getTypeFactory();

    public static Set<DirectedHuiRelation> getAllRelationsBothDirections(String sourceEntityTypeId, String targetEntityTypeId) {
        Set<HuiRelation> forwardRelations = huiTypeFactory.getPossibleRelations(sourceEntityTypeId, targetEntityTypeId);
        Set<HuiRelation> backwardRelations = !sourceEntityTypeId.equals(targetEntityTypeId) ? huiTypeFactory.getPossibleRelations(targetEntityTypeId, sourceEntityTypeId) : Collections.emptySet();
        return HuiRelationUtil.collateRelations(forwardRelations, backwardRelations);
    }

    public static Set<DirectedHuiRelation> getAllRelationsBothDirections(String sourceEntityTypeId) {
        TreeSet<DirectedHuiRelation> result = new TreeSet<DirectedHuiRelation>(HuiRelationUtil.getDirectedHuiRelationComparator());
        for (EntityType entityType : huiTypeFactory.getAllEntityTypes()) {
            result.addAll(HuiRelationUtil.getAllRelationsBothDirections(sourceEntityTypeId, entityType.getId()));
        }
        return result;
    }

    private static Set<DirectedHuiRelation> collateRelations(Set<HuiRelation> forwardRelations, Set<HuiRelation> backwardRelations) {
        TreeSet<DirectedHuiRelation> collatedRelations = new TreeSet<DirectedHuiRelation>(HuiRelationUtil.getDirectedHuiRelationComparator());
        for (HuiRelation forwardRelation : forwardRelations) {
            collatedRelations.add(DirectedHuiRelation.getDirectedHuiRelation(forwardRelation, true));
        }
        for (HuiRelation backwardRelation : backwardRelations) {
            collatedRelations.add(DirectedHuiRelation.getDirectedHuiRelation(backwardRelation, false));
        }
        return collatedRelations;
    }

    private static Comparator<DirectedHuiRelation> getDirectedHuiRelationComparator() {
        return new SortByLabel();
    }

    private HuiRelationUtil() {
    }

    private static final class SortByLabel
    implements Comparator<DirectedHuiRelation> {
        Collator collator = Collator.getInstance(Locale.getDefault());

        private SortByLabel() {
        }

        @Override
        public int compare(DirectedHuiRelation relation1, DirectedHuiRelation relation2) {
            int resultFromLabelComparison = this.collator.compare(relation1.getLabel(), relation2.getLabel());
            if (resultFromLabelComparison != 0) {
                return resultFromLabelComparison;
            }
            int resultFromForwardComparison = Boolean.compare(relation1.isForward(), relation2.isForward());
            if (resultFromForwardComparison != 0) {
                return resultFromForwardComparison;
            }
            return relation1.getHuiRelation().getId().compareTo(relation2.getHuiRelation().getId());
        }
    }
}

