/*
 * Decompiled with CFR 0.152.
 */
package sernet.hui.common.connect;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.EntityType;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.HuiRelation;
import sernet.hui.common.connect.HuiTypeFactoryException;
import sernet.hui.common.connect.IEntityResolverFactory;
import sernet.hui.common.connect.PropertyGroup;
import sernet.hui.common.connect.PropertyType;
import sernet.hui.common.connect.ResolverFactoryRegistry;
import sernet.snutils.DBException;

public class HitroUtil {
    private static final Logger LOG = Logger.getLogger(HitroUtil.class);
    private HUITypeFactory typeFactory;
    private URL url;
    private IEntityResolverFactory resolverFactory;

    public static HitroUtil getInstance() {
        return (HitroUtil)VeriniceContext.get("hitroUtil");
    }

    public void initForServer() {
        if (this.typeFactory == null) {
            throw new IllegalStateException("type factory instance does not exist yet. This is not expected for the server!");
        }
        LOG.debug((Object)"Initializing server's HitroUI framework");
        this.resolverFactory.createResolvers(this.typeFactory);
    }

    public void initForClient() {
        if (this.typeFactory != null) {
            throw new IllegalStateException("Type factory instance already exists. This is not expected for the client!");
        }
        if (this.url == null) {
            throw new IllegalStateException("Property 'url' is not set. This is not expected for the client!");
        }
        LOG.debug((Object)"Initializing client's HitroUI framework");
        this.initForClientImpl(this.url, this.resolverFactory);
    }

    public void init(String server, IEntityResolverFactory resolverFactory) {
        URL huiConfig;
        try {
            huiConfig = new URL(String.valueOf(server) + "/GetHitroConfig");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.initForClientImpl(huiConfig, resolverFactory);
    }

    private void initForClientImpl(URL url, IEntityResolverFactory resolverFactory) {
        this.typeFactory = new DelegatingHUITypeFactory(url, resolverFactory);
    }

    public void setTypeFactory(HUITypeFactory typeFactory) {
        if (this.typeFactory != null) {
            throw new IllegalStateException("Type factory instance already exists. This method must not be called twice.");
        }
        this.typeFactory = typeFactory;
    }

    public HUITypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setEntityResolverFactory(IEntityResolverFactory resolverFactory) {
        this.resolverFactory = resolverFactory;
    }

    static class DelegatingHUITypeFactory
    extends HUITypeFactory {
        private static final Logger LOG_0 = Logger.getLogger(DelegatingHUITypeFactory.class);
        private HUITypeFactory typeFactory;
        private URL url;
        private IEntityResolverFactory resolverFactory;

        DelegatingHUITypeFactory(URL url, IEntityResolverFactory resolverFactory) {
            this.url = url;
            this.resolverFactory = resolverFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initDelegate() {
            URL uRL = this.url;
            synchronized (uRL) {
                if (this.typeFactory != null) {
                    return;
                }
                try {
                    this.typeFactory = HUITypeFactory.createInstance(this.url);
                    this.getResolverFactory().createResolvers(this.typeFactory);
                }
                catch (DBException e) {
                    this.typeFactory = new HUITypeFactoryBroken();
                    LOG_0.error((Object)("Unable to reach document: " + this.url), (Throwable)e);
                }
            }
        }

        private HUITypeFactory getTypeFactory() {
            if (this.typeFactory == null) {
                this.initDelegate();
            }
            return this.typeFactory;
        }

        @Override
        public Set<String> getAllTypeIds() {
            return this.getTypeFactory().getAllTypeIds();
        }

        @Override
        public EntityType getEntityType(String id) {
            return this.getTypeFactory().getEntityType(id);
        }

        @Override
        public Collection<EntityType> getAllEntityTypes() {
            return this.getTypeFactory().getAllEntityTypes();
        }

        @Override
        public List<PropertyType> getURLPropertyTypes() {
            return this.getTypeFactory().getURLPropertyTypes();
        }

        @Override
        public PropertyType getPropertyType(String entityTypeID, String id) {
            return this.getTypeFactory().getPropertyType(entityTypeID, id);
        }

        @Override
        public HuiRelation getRelation(String typeId) {
            return this.getTypeFactory().getRelation(typeId);
        }

        @Override
        public Set<HuiRelation> getPossibleRelations(String fromEntityTypeID, String toEntityTypeID) {
            return this.getTypeFactory().getPossibleRelations(fromEntityTypeID, toEntityTypeID);
        }

        @Override
        public Set<HuiRelation> getPossibleRelationsTo(String toEntityTypeID) {
            return this.getTypeFactory().getPossibleRelationsTo(toEntityTypeID);
        }

        @Override
        public Set<String> getAllTags() {
            return this.getTypeFactory().getAllTags();
        }

        @Override
        public Set<HuiRelation> getPossibleRelationsFrom(String fromEntityTypeID) {
            return this.getTypeFactory().getPossibleRelationsFrom(fromEntityTypeID);
        }

        @Override
        public String getMessage(String key) {
            return this.getTypeFactory().getMessage(key);
        }

        @Override
        public PropertyGroup getPropertyGroup(String entityId, String propertyId) {
            return this.getTypeFactory().getPropertyGroup(entityId, propertyId);
        }

        public IEntityResolverFactory getResolverFactory() {
            if (this.resolverFactory == null) {
                this.resolverFactory = ResolverFactoryRegistry.getResolverFactory();
            }
            return this.resolverFactory;
        }

        private final class HUITypeFactoryBroken
        extends HUITypeFactory {
            private HUITypeFactoryBroken() {
            }

            @Override
            public Set<String> getAllTypeIds() {
                throw new HuiTypeFactoryException();
            }

            @Override
            public EntityType getEntityType(String id) {
                throw new HuiTypeFactoryException();
            }

            @Override
            public Collection<EntityType> getAllEntityTypes() {
                throw new HuiTypeFactoryException();
            }

            @Override
            public List<PropertyType> getURLPropertyTypes() {
                throw new HuiTypeFactoryException();
            }

            @Override
            public Set<String> getAllTags() {
                throw new HuiTypeFactoryException();
            }

            @Override
            public PropertyType getPropertyType(String entityTypeID, String id) {
                throw new HuiTypeFactoryException();
            }

            @Override
            public Set<HuiRelation> getPossibleRelations(String fromEntityTypeID, String toEntityTypeID) {
                throw new HuiTypeFactoryException();
            }

            @Override
            public Set<HuiRelation> getPossibleRelationsFrom(String fromEntityTypeID) {
                throw new HuiTypeFactoryException();
            }

            @Override
            public Set<HuiRelation> getPossibleRelationsTo(String toEntityTypeID) {
                throw new HuiTypeFactoryException();
            }

            @Override
            public HuiRelation getRelation(String huiRelationId) {
                throw new HuiTypeFactoryException();
            }

            @Override
            public String getMessage(String key) {
                throw new HuiTypeFactoryException();
            }

            @Override
            public String getMessage(String key, String defaultMessage) {
                throw new HuiTypeFactoryException();
            }

            @Override
            public String getMessage(String key, String defaultMessage, boolean emptyIfNotFound) {
                throw new HuiTypeFactoryException();
            }

            @Override
            public PropertyGroup getPropertyGroup(String entityId, String propertyId) {
                throw new HuiTypeFactoryException();
            }
        }
    }
}

