/*
 * Decompiled with CFR 0.152.
 */
package sernet.hui.common.connect;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.DependsType;
import sernet.hui.common.connect.EntityType;
import sernet.hui.common.connect.HuiRelation;
import sernet.hui.common.connect.IUrlLoader;
import sernet.hui.common.connect.PropertyGroup;
import sernet.hui.common.connect.PropertyOption;
import sernet.hui.common.connect.PropertyType;
import sernet.hui.common.connect.SNCAMessages;
import sernet.hui.common.rules.IFillRule;
import sernet.hui.common.rules.IValidationRule;
import sernet.hui.common.rules.NotEmpty;
import sernet.hui.common.rules.RuleFactory;
import sernet.snutils.DBException;

public class HUITypeFactory {
    private static final Logger LOG = Logger.getLogger(HUITypeFactory.class);
    public static final String HUI_CONFIGURATION_FILE = "SNCA.xml";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_REVERSENAME = "reversename";
    private static final String ATTRIBUTE_TOOLTIP = "tooltip";
    private static final String ATTRIBUTE_TAGS = "tags";
    private static final String ATTRIBUTE_DEFAULTVALUE = "defaultValue";
    private static final String ATTRIBUTE_REQUIRED = "required";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String BOOLEAN_TRUE = "true";
    private static final String HUI_PROPERTY = "huiproperty";
    private static final String HUI_PROPERTY_GROUP = "huipropertygroup";
    private static final String HUI_RELATION = "huirelation";
    private Document doc;
    private Set<String> allTags = new HashSet<String>();
    private Map<String, EntityType> allEntities = null;
    private Map<String, String> defaultMessages = new HashMap<String, String>();
    private SNCAMessages messages;

    protected HUITypeFactory() {
    }

    public HUITypeFactory(Resource resource) throws DBException, IOException {
        this(resource.getURL());
    }

    public HUITypeFactory(IUrlLoader urlLoader) throws DBException {
        this.init(urlLoader.load());
    }

    private HUITypeFactory(URL xmlFile) throws DBException {
        this.init(xmlFile);
    }

    private void init(URL xmlFile) throws DBException {
        if (xmlFile == null) {
            throw new DBException("Pfad f\u00fcr XML Systemdefinition nicht initialisiert. Config File korrekt?");
        }
        if (xmlFile.getProtocol().equals("http") || xmlFile.getProtocol().equals("ftp")) {
            try {
                xmlFile = new URL(String.valueOf(xmlFile.toString()) + "?nocache=" + Math.random());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        this.messages = new SNCAMessages(xmlFile.toExternalForm());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Conf url: " + this.messages.getBaseUrl() + ", localized name of huientity role: " + this.messages.getString("role")));
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        DocumentBuilder parser = null;
        try {
            factory.setFeature("http://xml.org/sax/features/validation", true);
            factory.setFeature("http://apache.org/xml/features/validation/schema", true);
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", this.getClass().getResource("/hitro.xsd").toString());
            parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"Unrecognized parser feature.", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            LOG.debug((Object)("Getting XML property definition from " + xmlFile));
            parser.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    throw new RuntimeException(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw new RuntimeException(exception);
                }

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    Logger.getLogger(this.getClass()).debug((Object)("Parser warning: " + exception.getLocalizedMessage()));
                }
            });
            Throwable e = null;
            Object var5_10 = null;
            try (BufferedInputStream is = new BufferedInputStream(xmlFile.openStream());){
                this.doc = parser.parse(is);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
            this.readAllEntities();
        }
        catch (IOException ie) {
            LOG.error((Object)ie);
            throw new DBException("Die XML-Datei mit der Definition der Formularfelder konnte nicht geladen werden! Bitte Pfad und Erreichbarkeit laut Konfigurationsfile \u00fcberpr\u00fcfen.", ie);
        }
        catch (SAXException e) {
            throw new DBException("Die XML-Datei mit der Definition der Formularfelder ist defekt!", e);
        }
    }

    public static HUITypeFactory createInstance(URL xmlUrl) throws DBException {
        return new HUITypeFactory(xmlUrl);
    }

    public static HUITypeFactory getInstance() {
        return (HUITypeFactory)VeriniceContext.get("huiTypeFactory");
    }

    private void readAllEntities() {
        NodeList entities = this.doc.getElementsByTagName("huientity");
        int numberOfEntities = entities.getLength();
        this.allEntities = new HashMap<String, EntityType>(numberOfEntities);
        int i = 0;
        while (i < numberOfEntities) {
            Element entityEl = (Element)entities.item(i);
            EntityType entityObj = new EntityType();
            String id = entityEl.getAttribute(ATTRIBUTE_ID);
            entityObj.setId(id);
            String name = entityEl.getAttribute(ATTRIBUTE_NAME);
            this.defaultMessages.put(id, name);
            entityObj.setName(this.getMessage(id));
            this.allEntities.put(entityEl.getAttribute(ATTRIBUTE_ID), entityObj);
            this.readChildElements(entityObj, null);
            ++i;
        }
    }

    public Set<String> getAllTypeIds() {
        return this.allEntities.keySet();
    }

    public EntityType getEntityType(String id) {
        return this.allEntities.get(id);
    }

    public Collection<EntityType> getAllEntityTypes() {
        return this.allEntities.values();
    }

    public List<PropertyType> getURLPropertyTypes() {
        ArrayList<PropertyType> result = new ArrayList<PropertyType>();
        Set<Map.Entry<String, EntityType>> entrySet = this.allEntities.entrySet();
        for (Map.Entry<String, EntityType> entry : entrySet) {
            List<PropertyType> types = entry.getValue().getPropertyTypes();
            for (PropertyType propertyType : types) {
                if (!propertyType.isURL()) continue;
                result.add(propertyType);
            }
        }
        return result;
    }

    private void readChildElements(EntityType entityType, PropertyGroup propGroup) {
        NodeList nodes;
        if (propGroup != null) {
            Element groupEl = this.doc.getElementById(propGroup.getId());
            nodes = groupEl.getChildNodes();
        } else {
            Element entityEl = this.doc.getElementById(entityType.getId());
            if (entityEl == null) {
                throw new IllegalArgumentException("EntityType not found in XML definition: " + entityType.getId());
            }
            nodes = entityEl.getChildNodes();
        }
        int i = 0;
        while (i < nodes.getLength()) {
            if (nodes.item(i) instanceof Element) {
                this.readElementNode(entityType, propGroup, nodes, i);
            }
            ++i;
        }
    }

    private void readElementNode(EntityType entityType, PropertyGroup propGroup, NodeList nodes, int i) {
        Element child = (Element)nodes.item(i);
        if (child.getTagName().equals(HUI_PROPERTY)) {
            PropertyType type = this.readPropertyType(child.getAttribute(ATTRIBUTE_ID));
            if (propGroup != null) {
                propGroup.addPropertyType(type);
            } else {
                entityType.addPropertyType(type);
            }
        } else if (child.getTagName().equals(HUI_PROPERTY_GROUP)) {
            PropertyGroup group = this.readPropertyGroup(child.getAttribute(ATTRIBUTE_ID));
            this.readChildElements(entityType, group);
            entityType.addPropertyGroup(group);
        } else if (child.getTagName().equals(HUI_RELATION)) {
            HuiRelation relation = new HuiRelation(child.getAttribute(ATTRIBUTE_ID));
            this.readRelation(child, entityType.getId(), relation);
            entityType.addRelation(relation);
        }
    }

    private void readRelation(Element child, String sourceTypeId, HuiRelation relation) {
        String id = child.getAttribute(ATTRIBUTE_ID);
        String keyName = this.getKey(id, ATTRIBUTE_NAME);
        String name = child.getAttribute(ATTRIBUTE_NAME);
        String keyReversename = this.getKey(id, ATTRIBUTE_REVERSENAME);
        String reverseName = child.getAttribute(ATTRIBUTE_REVERSENAME);
        this.defaultMessages.put(keyName, name);
        this.defaultMessages.put(keyReversename, reverseName);
        relation.setName(this.getMessage(keyName));
        relation.setReversename(this.getMessage(keyReversename));
        relation.setTooltip(this.getMessage(this.getKey(id, ATTRIBUTE_TOOLTIP), child.getAttribute(ATTRIBUTE_TOOLTIP), true));
        relation.setTo(child.getAttribute("to"));
        relation.setFrom(sourceTypeId);
    }

    private String getKey(String id, String attribute) {
        return id + "_" + attribute;
    }

    private PropertyType readPropertyType(String id) {
        Element prop = this.doc.getElementById(id);
        if (prop == null) {
            return null;
        }
        PropertyType propObj = new PropertyType();
        propObj.setId(id);
        String name = prop.getAttribute(ATTRIBUTE_NAME);
        this.defaultMessages.put(id, name);
        propObj.setName(this.getMessage(id));
        propObj.setTooltiptext(this.getMessage(this.getKey(id, ATTRIBUTE_TOOLTIP), prop.getAttribute(ATTRIBUTE_TOOLTIP), true));
        propObj.setTags(prop.getAttribute(ATTRIBUTE_TAGS));
        this.addToTagList(prop.getAttribute(ATTRIBUTE_TAGS));
        propObj.setInputType(prop.getAttribute("inputtype"));
        propObj.setCrudButtons(prop.getAttribute("crudButtons").equals(BOOLEAN_TRUE));
        propObj.setRequired(prop.getAttribute(ATTRIBUTE_REQUIRED).equals(BOOLEAN_TRUE));
        propObj.setInitialFocus(prop.getAttribute("focus").equals(BOOLEAN_TRUE));
        propObj.setEditable(prop.getAttribute("editable").equals(BOOLEAN_TRUE));
        propObj.setVisible(prop.getAttribute("visible").equals(BOOLEAN_TRUE));
        propObj.setShowInObjectBrowser(prop.getAttribute("showInObjectBrowser").equals(BOOLEAN_TRUE));
        propObj.setURL(prop.getAttribute("isURL").equals(BOOLEAN_TRUE));
        propObj.setReportable(prop.getAttribute("report").equals(BOOLEAN_TRUE));
        propObj.setTextRows(prop.getAttribute("textrows"));
        propObj.setReferencedEntityType(this.readReferencedEntityId(prop));
        propObj.setReferencedCnaLinkType(this.readReferencedCnaLinkType(prop));
        propObj.setPredefinedValues(this.getOptionsForPropertyType(id));
        propObj.setDependencies(this.readDependencies(prop));
        if (propObj.isNumericSelect()) {
            propObj.setNumericMin(prop.getAttribute("min"));
            propObj.setNumericMax(prop.getAttribute("max"));
            propObj.setNumericDefault(prop.getAttribute(ATTRIBUTE_DEFAULTVALUE));
        }
        if (propObj.isBooleanSelect()) {
            propObj.setNumericMin("0");
            propObj.setNumericMax("1");
            propObj.setNumericDefault(prop.getAttribute(ATTRIBUTE_DEFAULTVALUE));
        }
        if (prop.getAttribute(ATTRIBUTE_REQUIRED).equals(BOOLEAN_TRUE)) {
            propObj.addValidator(new NotEmpty());
        }
        for (IValidationRule rule : this.readValidationRules(prop)) {
            propObj.addValidator(rule);
        }
        propObj.setDefaultRule(this.readDefaultRule(prop));
        return propObj;
    }

    private String readReferencedCnaLinkType(Element prop) {
        NodeList list = prop.getElementsByTagName("references");
        if (list != null && list.getLength() > 0) {
            Element referencesElmt = (Element)list.item(0);
            return referencesElmt.getAttribute("linkType");
        }
        return "";
    }

    private String readReferencedEntityId(Element prop) {
        NodeList list = prop.getElementsByTagName("references");
        if (list != null && list.getLength() > 0) {
            Element referencesElmt = (Element)list.item(0);
            return referencesElmt.getAttribute("entitytype");
        }
        return "";
    }

    private void addToTagList(String tags) {
        if (tags == null || tags.length() < 1) {
            return;
        }
        String newTags = tags.replaceAll("\\s+", "");
        String[] individualTags = newTags.split(",");
        this.allTags.addAll(Arrays.asList(individualTags));
    }

    public Set<String> getAllTags() {
        return this.allTags;
    }

    private PropertyGroup readPropertyGroup(String id) {
        Element group = this.doc.getElementById(id);
        if (group == null) {
            return null;
        }
        PropertyGroup groupObj = new PropertyGroup();
        groupObj.setId(id);
        String name = group.getAttribute(ATTRIBUTE_NAME);
        this.defaultMessages.put(id, name);
        groupObj.setName(this.getMessage(id));
        groupObj.setTags(group.getAttribute(ATTRIBUTE_TAGS));
        this.addToTagList(group.getAttribute(ATTRIBUTE_TAGS));
        groupObj.setDependencies(this.readDependencies(group));
        return groupObj;
    }

    private Set<DependsType> readDependencies(Element prop) {
        HashSet<DependsType> depends = new HashSet<DependsType>();
        NodeList nodes = prop.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Element child;
            if (nodes.item(i) instanceof Element && "depends".equals((child = (Element)nodes.item(i)).getTagName())) {
                String option = child.getAttribute("option");
                String value = child.getAttribute(ATTRIBUTE_VALUE);
                boolean inverse = Boolean.TRUE.toString().equals(child.getAttribute("inverse"));
                depends.add(new DependsType(option, value, inverse));
            }
            ++i;
        }
        return depends;
    }

    private List<IValidationRule> readValidationRules(Element prop) {
        ArrayList<IValidationRule> ruleList = new ArrayList<IValidationRule>(0);
        NodeList list = prop.getElementsByTagName("validationRule");
        int i = 0;
        while (i < list.getLength()) {
            Element ruleElement = (Element)list.item(i);
            String className = ruleElement.getAttribute("class");
            IValidationRule rule = RuleFactory.getValidationRule(className);
            String hint = ruleElement.getAttribute("hint");
            rule.init(this.readValidationRuleParams(ruleElement), hint);
            ruleList.add(rule);
            ++i;
        }
        return ruleList;
    }

    private String[] readValidationRuleParams(Element ruleElement) {
        NodeList paramNodeList = ruleElement.getElementsByTagName("param");
        String[] params = new String[paramNodeList.getLength()];
        int i = 0;
        while (i < paramNodeList.getLength()) {
            Element paramNode = (Element)paramNodeList.item(i);
            params[i] = paramNode.getTextContent();
            ++i;
        }
        return params;
    }

    private IFillRule readDefaultRule(Element prop) {
        IFillRule rule = null;
        NodeList list = prop.getElementsByTagName("defaultRule");
        int i = 0;
        while (i < list.getLength()) {
            Element ruleElmt = (Element)list.item(i);
            String className = ruleElmt.getAttribute("class");
            rule = RuleFactory.getDefaultRule(className);
            if (rule != null) {
                String[] params = this.readRuleParams(ruleElmt, rule);
                rule.init(params);
            }
            ++i;
        }
        return rule;
    }

    private String[] readRuleParams(Element ruleElmt, IFillRule rule) {
        NodeList paramNodeList = ruleElmt.getElementsByTagName("param");
        String[] params = new String[paramNodeList.getLength()];
        int i = 0;
        while (i < paramNodeList.getLength()) {
            Element paramNode = (Element)paramNodeList.item(i);
            params[i] = paramNode.getTextContent();
            if (rule.isMultiLanguage()) {
                params[i] = this.getMessage(paramNode.getAttribute(ATTRIBUTE_ID), params[i]);
            }
            ++i;
        }
        return params;
    }

    private List<PropertyOption> getOptionsForPropertyType(String id) {
        Element prop = this.doc.getElementById(id);
        NodeList values = prop.getElementsByTagName("option");
        ArrayList<PropertyOption> possibleValues = new ArrayList<PropertyOption>(values.getLength());
        int i = 0;
        while (i < values.getLength()) {
            PropertyOption dv;
            block4: {
                Element value = (Element)values.item(i);
                dv = new PropertyOption();
                String idOption = value.getAttribute(ATTRIBUTE_ID);
                dv.setId(idOption);
                dv.setName(this.getMessage(idOption, value.getAttribute(ATTRIBUTE_NAME)));
                String optValue = value.getAttribute(ATTRIBUTE_VALUE);
                if (optValue != null && !optValue.isEmpty()) {
                    try {
                        dv.setValue(Integer.parseInt(optValue));
                    }
                    catch (NumberFormatException e) {
                        if (!LOG.isDebugEnabled()) break block4;
                        LOG.debug((Object)("Not a valid number for option " + optValue), (Throwable)e);
                    }
                }
            }
            possibleValues.add(dv);
            ++i;
        }
        return possibleValues;
    }

    public PropertyType getPropertyType(String entityTypeID, String id) {
        return this.allEntities.get(entityTypeID).getPropertyType(id);
    }

    public Set<HuiRelation> getPossibleRelations(String fromEntityTypeID, String toEntityTypeID) {
        return this.getEntityType(fromEntityTypeID).getPossibleRelations(toEntityTypeID);
    }

    public Set<HuiRelation> getPossibleRelationsFrom(String fromEntityTypeID) {
        if (this.getEntityType(fromEntityTypeID) == null) {
            LOG.error((Object)("cannot find entitytype for:\t" + fromEntityTypeID));
        }
        return this.getEntityType(fromEntityTypeID).getPossibleRelations();
    }

    public Set<HuiRelation> getPossibleRelationsTo(String toEntityTypeID) {
        HashSet<HuiRelation> allRelations = new HashSet<HuiRelation>();
        Set<Map.Entry<String, EntityType>> entrySet = this.allEntities.entrySet();
        for (Map.Entry<String, EntityType> entry : entrySet) {
            EntityType entityType = entry.getValue();
            Set<HuiRelation> theseRelations = entityType.getPossibleRelations(toEntityTypeID);
            if (theseRelations == null || theseRelations.isEmpty()) continue;
            allRelations.addAll(theseRelations);
        }
        return allRelations;
    }

    public HuiRelation getRelation(String huiRelationId) {
        if (this.allEntities == null) {
            LOG.debug((Object)("No entities in HUITypeFactory!! Instance: " + this));
            return null;
        }
        Set<Map.Entry<String, EntityType>> entrySet = this.allEntities.entrySet();
        for (Map.Entry<String, EntityType> entry : entrySet) {
            EntityType entityType = entry.getValue();
            HuiRelation possibleRelation = entityType.getPossibleRelation(huiRelationId);
            if (possibleRelation == null) continue;
            return possibleRelation;
        }
        return null;
    }

    public String getMessage(String key) {
        return this.getMessage(key, this.defaultMessages.get(key), false);
    }

    public String getMessage(String key, String defaultMessage) {
        return this.getMessage(key, defaultMessage, false);
    }

    public String getMessage(String key, String defaultMessage, boolean emptyIfNotFound) {
        String message = this.messages.getString(key);
        if (message != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("returning translated message: " + message + ", key: " + key));
            }
            return message;
        }
        return this.getDefaultMessage(key, defaultMessage, emptyIfNotFound);
    }

    private String getDefaultMessage(String key, String defaultMessage, boolean emptyIfNotFound) {
        if (defaultMessage == null || defaultMessage.isEmpty()) {
            if (emptyIfNotFound) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SNCA message not found, key is: " + key));
                }
                return "";
            }
            if (!"".equals(key)) {
                LOG.warn((Object)("SNCA message not found, key is: " + key));
            } else {
                LOG.info((Object)"key is empty String");
            }
            return String.valueOf(key) + " (!)";
        }
        this.defaultMessages.put(key, defaultMessage);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("returning message from SNCA.XML: " + defaultMessage + ", key: " + key));
            return String.valueOf(defaultMessage) + " (SNCA.xml)";
        }
        return defaultMessage;
    }

    public PropertyGroup getPropertyGroup(String entityId, String propertyId) {
        EntityType entityType = this.getEntityType(entityId);
        if (entityType == null) {
            return null;
        }
        List<PropertyGroup> propertyGroups = entityType.getPropertyGroups();
        if (propertyGroups == null) {
            return null;
        }
        for (PropertyGroup group : propertyGroups) {
            if (group.getPropertyType(propertyId) == null) continue;
            return group;
        }
        return null;
    }
}

