/*
 * Decompiled with CFR 0.152.
 */
package sernet.hui.common.connect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sernet.hui.common.connect.HuiRelation;
import sernet.hui.common.connect.IEntityElement;
import sernet.hui.common.connect.PropertyGroup;
import sernet.hui.common.connect.PropertyType;

public class EntityType {
    private String id;
    private String name;
    private String inheritingEntity;
    private List<IEntityElement> elements = new ArrayList<IEntityElement>();
    private List<PropertyGroup> propertyGroups = new ArrayList<PropertyGroup>();
    private Map<String, PropertyType> propertyTypes = new HashMap<String, PropertyType>();
    private Map<String, PropertyType> allPropertyTypes = new LinkedHashMap<String, PropertyType>();
    private Map<String, Set<HuiRelation>> relations = new HashMap<String, Set<HuiRelation>>();

    public List<PropertyType> getPropertyTypes() {
        ArrayList<PropertyType> types = new ArrayList<PropertyType>(this.propertyTypes.values().size());
        types.addAll(this.propertyTypes.values());
        return types;
    }

    public List<PropertyType> getPropertyTypesSorted() {
        ArrayList<PropertyType> propertyTypesSorted = new ArrayList<PropertyType>(this.propertyTypes.size());
        for (IEntityElement entity : this.getElements()) {
            if (!(entity instanceof PropertyType)) continue;
            propertyTypesSorted.add((PropertyType)entity);
        }
        return propertyTypesSorted;
    }

    public Collection<PropertyType> getAllPropertyTypes() {
        return this.allPropertyTypes.values();
    }

    public boolean hasPropertyType(String id) {
        return this.getAllPropertyTypes().stream().anyMatch(p -> p.getId().equals(id));
    }

    public List<PropertyType> getAllPropertyTypesSorted() {
        ArrayList<PropertyType> propertyTypeList = new ArrayList<PropertyType>(this.allPropertyTypes.size());
        for (IEntityElement entity : this.getElements()) {
            if (entity instanceof PropertyType) {
                propertyTypeList.add((PropertyType)entity);
                continue;
            }
            if (!(entity instanceof PropertyGroup)) continue;
            propertyTypeList.addAll(((PropertyGroup)entity).getPropertyTypes());
        }
        return propertyTypeList;
    }

    public PropertyType getPropertyType(String id) {
        return this.allPropertyTypes.get(id);
    }

    public String[] getAllPropertyTypeIds() {
        return (String[])this.allPropertyTypes.keySet().toArray(String[]::new);
    }

    @Deprecated
    public String[] getAllPropertyTypeIDsIncludingGroups() {
        return this.getAllPropertyTypeIds();
    }

    public String[] getAllPropertyTypeTitles() {
        return (String[])this.allPropertyTypes.values().stream().map(PropertyType::getName).toArray(String[]::new);
    }

    @Deprecated
    public String[] getAllPropertyTypeTitlesIncludingGroups() {
        return this.getAllPropertyTypeTitles();
    }

    public Set<HuiRelation> getPossibleRelations(String entityTypeId) {
        return this.relations.get(entityTypeId) != null ? this.relations.get(entityTypeId) : new HashSet(0);
    }

    public void addRelation(HuiRelation relation) {
        if (this.relations.get(relation.getTo()) == null) {
            this.relations.put(relation.getTo(), new HashSet());
        }
        this.relations.get(relation.getTo()).add(relation);
    }

    public Set<HuiRelation> getPossibleRelations() {
        HashSet<HuiRelation> allRelations = new HashSet<HuiRelation>();
        Set<Map.Entry<String, Set<HuiRelation>>> entrySet = this.relations.entrySet();
        for (Map.Entry<String, Set<HuiRelation>> entry : entrySet) {
            Set<HuiRelation> relationsToOneOtherType = entry.getValue();
            allRelations.addAll(relationsToOneOtherType);
        }
        return allRelations;
    }

    public HuiRelation getPossibleRelation(String relationTypeId) {
        Set<Map.Entry<String, Set<HuiRelation>>> entrySet = this.relations.entrySet();
        for (Map.Entry<String, Set<HuiRelation>> entry : entrySet) {
            Set<HuiRelation> value = entry.getValue();
            for (HuiRelation huiRelation : value) {
                if (!huiRelation.getId().equals(relationTypeId)) continue;
                return huiRelation;
            }
        }
        return null;
    }

    public List<PropertyType> getObjectBrowserPropertyTypes() {
        List<PropertyType> allPropertyTypesSorted = this.getAllPropertyTypesSorted();
        ArrayList<PropertyType> result = new ArrayList<PropertyType>(allPropertyTypesSorted.size());
        for (PropertyType propertyType : allPropertyTypesSorted) {
            if (!propertyType.isShowInObjectBrowser()) continue;
            result.add(propertyType);
        }
        return result;
    }

    public void addPropertyType(PropertyType prop) {
        this.propertyTypes.put(prop.getId(), prop);
        this.allPropertyTypes.put(prop.getId(), prop);
        this.elements.add(prop);
    }

    public void addPropertyGroup(PropertyGroup group) {
        this.propertyGroups.add(group);
        group.getPropertyTypes().forEach(type -> {
            PropertyType propertyType = this.allPropertyTypes.put(type.getId(), (PropertyType)type);
        });
        this.elements.add(group);
    }

    public List<IEntityElement> getElements() {
        return this.elements;
    }

    public List<PropertyGroup> getPropertyGroups() {
        return this.propertyGroups;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInheritingEntity() {
        return this.inheritingEntity;
    }

    public void setInheritingEntity(String inheritingEntity) {
        this.inheritingEntity = inheritingEntity;
    }

    public boolean isInheritingEntity() {
        return this.inheritingEntity != null;
    }
}

