/*
 * Decompiled with CFR 0.152.
 */
package sernet.hui.common.connect;

import java.io.Serializable;
import java.sql.Date;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import sernet.hui.common.connect.EntityType;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.IEntityChangedListener;
import sernet.hui.common.connect.ITypedElement;
import sernet.hui.common.connect.Property;
import sernet.hui.common.connect.PropertyChangedEvent;
import sernet.hui.common.connect.PropertyFactory;
import sernet.hui.common.connect.PropertyList;
import sernet.hui.common.connect.PropertyOption;
import sernet.hui.common.connect.PropertyType;
import sernet.hui.common.multiselectionlist.IMLPropertyOption;
import sernet.hui.common.multiselectionlist.IMLPropertyType;
import sernet.hui.common.multiselectionlist.ISelectOptionHandler;
import sernet.snutils.AssertException;
import sernet.snutils.FormInputParser;
import sernet.snutils.HuiRuntimeException;
import sernet.snutils.Tester;

public class Entity
implements ISelectOptionHandler,
ITypedElement,
Serializable {
    public static final String TITLE = "ENTITY_";
    public static final String TYPE_ID = "huientity";
    private static final Logger logger = Logger.getLogger(Entity.class);
    private static final Pattern EPOCH_STRING = Pattern.compile("-?\\d+");
    private static final String FLAG_ENABLED = "1";
    private static final String FLAG_DISABLED = "0";
    private String uuid;
    private Integer dbId;
    private String entityType;
    private Map<String, PropertyList> typedPropertyLists = new HashMap<String, PropertyList>();
    private transient List<IEntityChangedListener> changeListeners;
    private Map<String, String> referenceValueCache;
    private String createdBy;
    private java.util.Date createdAt;
    private String changedBy;
    private java.util.Date changedAt;

    protected Entity() {
        this.uuid = UUID.randomUUID().toString();
    }

    public Entity(String entType) {
        this();
        this.entityType = entType;
    }

    public void initDefaultValues(HUITypeFactory huiTypeFactory) {
        String[] types;
        EntityType entityTypeFromFactory = huiTypeFactory.getEntityType(this.entityType);
        if (entityTypeFromFactory == null) {
            throw new IllegalArgumentException("Cannot initialize default values for " + this + " from the given HUITypeFactory since it does not support the entity type.");
        }
        String[] stringArray = types = entityTypeFromFactory.getAllPropertyTypeIds();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            PropertyType propertyType = huiTypeFactory.getPropertyType(this.entityType, type);
            if (propertyType.isNumericSelect() || propertyType.isBooleanSelect()) {
                this.setNumericValue(propertyType, propertyType.getNumericDefault());
            } else if ((propertyType.isText() || propertyType.isDate() || propertyType.isLine()) && propertyType.getDefaultRule() != null) {
                this.setSimpleValue(propertyType, propertyType.getDefaultRule().getValue());
            }
            ++n2;
        }
    }

    @Deprecated
    public String getSimpleValue(String propertyTypeId) {
        return this.getPropertyValue(propertyTypeId);
    }

    public String getPropertyValue(String propertyTypeId) {
        PropertyType propertyType = HUITypeFactory.getInstance().getPropertyType(this.entityType, propertyTypeId);
        if (propertyType == null) {
            return String.valueOf("");
        }
        if (propertyType.isReference()) {
            return this.getValueOfReferenceProperty(propertyType);
        }
        PropertyList propertyList = this.typedPropertyLists.get(propertyTypeId);
        StringBuilder sb = new StringBuilder();
        if (propertyList != null) {
            boolean firstProperty = true;
            for (Property property : propertyList.getProperties()) {
                String value;
                if (!firstProperty) {
                    sb.append(", ");
                }
                if ((value = propertyType.isSingleSelect() || propertyType.isMultiselect() ? this.getValueOfOptionProperty(propertyType, property) : (propertyType.isDate() ? this.getValueOfDateProperty(property) : property.getPropertyValue())) != null) {
                    sb.append(value);
                }
                firstProperty = false;
            }
        }
        return sb.toString();
    }

    public void setPropertyValue(String propertyTypeId, String value) {
        PropertyType propertyType = HUITypeFactory.getInstance().getPropertyType(this.entityType, propertyTypeId);
        PropertyList propertyList = this.typedPropertyLists.get(propertyTypeId);
        if (propertyType.isReference() || propertyType.isMultiselect()) {
            this.typedPropertyLists.put(propertyTypeId, null);
            this.setMultiselectProperty(propertyTypeId, value);
        } else if (propertyList != null) {
            for (Property property : propertyList.getProperties()) {
                if (propertyType.isDate()) {
                    this.setDateProperty(value, property);
                    continue;
                }
                property.setPropertyValue(value);
            }
        }
    }

    private String getValueOfReferenceProperty(PropertyType type) {
        String propertyTypeId = type.getId();
        if (!type.isReference()) {
            throw new HuiRuntimeException("Type of property with type id " + propertyTypeId + " is not 'reference'");
        }
        String value = this.getReferenceValueCache().get(propertyTypeId);
        if (value == null) {
            value = this.loadValueOfReferenceProperty(type);
            this.getReferenceValueCache().put(propertyTypeId, value);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reference value found in cache: " + value + ", property type id: " + propertyTypeId + ", entity db id: " + this.getDbId()));
        }
        return value;
    }

    private String loadValueOfReferenceProperty(PropertyType type) {
        String propertyTypeId = type.getId();
        StringBuilder sb = new StringBuilder();
        PropertyList propertyList = this.typedPropertyLists.get(propertyTypeId);
        if (propertyList != null) {
            try {
                List<IMLPropertyOption> referencedEntities = type.getReferencedEntities(propertyList.getProperties());
                boolean first = true;
                for (IMLPropertyOption referenceEntity : referencedEntities) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(referenceEntity.getName());
                    first = false;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reference value loaded from db: " + sb.toString() + ", property type id: " + propertyTypeId + ", entity db id: " + this.getDbId()));
                }
            }
            catch (Exception e) {
                String propertyValue = propertyList.getProperties().stream().map(Property::getPropertyValue).collect(Collectors.joining(", "));
                String message = "Error reading Entity:" + this.entityType + " uuid:" + this.uuid + " propertytype:" + propertyTypeId + " propertyValue: [" + propertyValue + "]";
                logger.error((Object)message, (Throwable)e);
                throw new RuntimeException("Error loading reference property.\n" + message, e);
            }
        }
        return sb.toString();
    }

    private String getValueOfOptionProperty(PropertyType type, Property property) {
        PropertyOption option = type.getOption(property.getPropertyValue());
        return option != null ? option.getName() : "";
    }

    private void setMultiselectProperty(String propertyTypeId, String value) {
        String[] propertyOptions;
        String[] stringArray = propertyOptions = value.split(",");
        int n = propertyOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyOptionValue = stringArray[n2];
            if (StringUtils.isNotEmpty((String)propertyOptionValue)) {
                this.createNewProperty(propertyTypeId, propertyOptionValue);
            }
            ++n2;
        }
    }

    private void setDateProperty(String value, Property property) {
        if (EPOCH_STRING.matcher(value).matches()) {
            property.setPropertyValue(value, false, null);
        } else {
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(FormInputParser.stringToDate(value.trim()).getTime());
                property.setPropertyValue(calendar, false, null);
            }
            catch (AssertException e) {
                logger.error((Object)"Exception while setting the value of a date property", (Throwable)e);
            }
        }
    }

    private String getValueOfDateProperty(Property property) {
        String date;
        block4: {
            date = null;
            String propertyValue = property.getPropertyValue();
            if (propertyValue == null) {
                return date;
            }
            if ((propertyValue = propertyValue.trim()).isEmpty()) {
                return date;
            }
            try {
                date = FormInputParser.dateToString(new Date(Long.parseLong(propertyValue)));
            }
            catch (NumberFormatException | AssertException e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)"Exception while getting the value of a date property", (Throwable)e);
            }
        }
        return date;
    }

    public java.util.Date getDate(String propertyTypeId) {
        java.util.Date date = null;
        try {
            date = new java.util.Date(Long.valueOf(this.getRawPropertyValue(propertyTypeId)));
        }
        catch (NumberFormatException t) {
            logger.error((Object)("Error while returning date for property: " + propertyTypeId), (Throwable)t);
        }
        return date;
    }

    public String getDateInISO8601(String propertyTypeId) {
        String dateInISO8601 = null;
        java.util.Date date = this.getDate(propertyTypeId);
        if (date != null) {
            dateInISO8601 = DateTimeFormatter.ISO_LOCAL_DATE.format(date.toInstant().atZone(ZoneId.systemDefault()));
        }
        return dateInISO8601;
    }

    @Deprecated
    public String getValue(String propertyTypeId) {
        return this.getRawPropertyValue(propertyTypeId);
    }

    public String getRawPropertyValue(String propertyTypeId) {
        String result = null;
        PropertyList propertyList = this.typedPropertyLists.get(propertyTypeId);
        if (propertyList != null && !propertyList.getProperties().isEmpty()) {
            result = this.joinPropertyValues(propertyList);
        }
        return result;
    }

    private String joinPropertyValues(PropertyList propertyList) {
        StringBuilder sb = new StringBuilder();
        Iterator<Property> iter = propertyList.getProperties().iterator();
        while (iter.hasNext()) {
            String propertyValue = iter.next().getPropertyValue();
            if (propertyValue != null) {
                sb.append(propertyValue);
            }
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public void setSimpleValue(PropertyType type, String value) {
        PropertyList list = this.typedPropertyLists.get(type.getId());
        if (list == null || list.getProperties().isEmpty()) {
            this.createNewProperty(type, value);
        } else {
            list.getProperty(0).setPropertyValue(value);
        }
    }

    public Integer getNumericValue(String propertyType) {
        try {
            return Integer.valueOf(this.getPropertyValue(propertyType));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public void setNumericValue(PropertyType type, int value) {
        this.setSimpleValue(type, Integer.toString(value));
    }

    public void copyEntity(Entity source) {
        List<String> emptyList = Collections.emptyList();
        this.copyEntity(source, emptyList);
    }

    public boolean importProperties(HUITypeFactory huiTypeFactory, String propertyTypeId, List<String> foreignProperties, List<Boolean> foreignLimitedLicense, List<String> foreignContentId, boolean licenseManagement, Collection<String> propertiesRequiringExactMatches) {
        List<Property> properties;
        int oldSize;
        boolean propertyValueChanged = false;
        PropertyList pl = this.typedPropertyLists.get(propertyTypeId);
        int newSize = foreignProperties.size();
        if (pl == null) {
            pl = new PropertyList(newSize);
            this.typedPropertyLists.put(propertyTypeId, pl);
            propertyValueChanged = true;
        }
        if ((oldSize = (properties = pl.getProperties()).size()) > newSize) {
            propertyValueChanged = true;
            int i = oldSize;
            while (i > newSize) {
                properties.remove(i - 1);
                --i;
            }
        } else if (newSize > oldSize) {
            propertyValueChanged = true;
            List fillUpProperties = Stream.generate(() -> {
                Property p = new Property();
                p.setParent(this);
                p.setPropertyType(propertyTypeId);
                return p;
            }).limit((long)newSize - (long)oldSize).collect(Collectors.toList());
            properties.addAll(fillUpProperties);
        }
        PropertyType propertyType = huiTypeFactory.getPropertyType(this.entityType, propertyTypeId);
        if (propertyType == null && logger.isInfoEnabled()) {
            logger.info((Object)("Property-type was not found in SNCA.xml: " + propertyTypeId + ", entity type: " + this.entityType));
        }
        int i = 0;
        while (i < foreignProperties.size()) {
            String value = foreignProperties.get(i);
            Property p = properties.get(i);
            if (!Objects.equals(value = this.checkPropertyValue(propertyTypeId, propertyType, value, propertiesRequiringExactMatches.contains(propertyTypeId)), p.getPropertyValue())) {
                propertyValueChanged = true;
                p.setPropertyValue(value);
            }
            Boolean limitedLicense = Boolean.FALSE;
            String licenseContentId = null;
            if (licenseManagement && !foreignContentId.isEmpty() && !foreignLimitedLicense.isEmpty()) {
                limitedLicense = foreignLimitedLicense.get(i);
                licenseContentId = foreignContentId.get(i);
            }
            p.setLimitedLicense(limitedLicense);
            p.setLicenseContentId(licenseContentId);
            ++i;
        }
        return propertyValueChanged;
    }

    private String checkPropertyValue(String propertyTypeId, PropertyType propertyType, String value, boolean propertyValueMustBeValidOption) {
        String rawValue = value;
        if (propertyType != null && propertyType.isSingleSelect() && value != null && !value.isEmpty()) {
            List<IMLPropertyOption> optionList = propertyType.getOptions();
            boolean found = false;
            for (IMLPropertyOption option : optionList) {
                if (value.equals(option.getName())) {
                    rawValue = option.getId();
                    found = true;
                    continue;
                }
                if (!value.equals(option.getId())) continue;
                found = true;
            }
            if (!found) {
                if (propertyValueMustBeValidOption) {
                    throw new IllegalArgumentException("Invalid value found for option property " + propertyTypeId + " of entity " + this.entityType + ": " + value);
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("No value found for option property: " + propertyTypeId + " of entity: " + this.entityType + ". Importing unmapped value: " + value));
                }
            }
        }
        return rawValue;
    }

    public int exportProperties(String propertyType, List<String> foreignProperties, List<Boolean> foreignIsLicenseLimited, List<String> foreignContentId) {
        int amount = 0;
        for (Property prop : this.getProperties(propertyType).getProperties()) {
            foreignProperties.add(prop.getPropertyValue());
            foreignIsLicenseLimited.add(prop.isLimitedLicense() != null ? prop.isLimitedLicense() : false);
            foreignContentId.add(prop.getLicenseContentId() != null ? prop.getLicenseContentId() : "");
            ++amount;
        }
        return amount;
    }

    public void copyEntity(Entity source, List<String> propertyTypeBlacklist) {
        this.typedPropertyLists.putAll(source.getTypedPropertyLists().entrySet().stream().filter(e -> !propertyTypeBlacklist.contains(e.getKey())).filter(e -> !((PropertyList)e.getValue()).isEmpty()).map(this::copyPropertyList).filter(e -> !((PropertyList)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private Map.Entry<String, PropertyList> copyPropertyList(Map.Entry<String, PropertyList> propertyListMapEntry) {
        PropertyList sourcePropertyList = propertyListMapEntry.getValue();
        PropertyList newPropertyList = new PropertyList(sourcePropertyList.getProperties().size());
        for (Property sourceProp : sourcePropertyList.getProperties()) {
            if (sourceProp.isEmpty()) continue;
            newPropertyList.add(sourceProp.copy(this));
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Prop " + propertyListMapEntry.getKey() + " set to value: " + sourceProp.getPropertyValue()));
        }
        return Map.entry(propertyListMapEntry.getKey(), newPropertyList);
    }

    public boolean isSelected(String optionId) {
        for (String propertyTypeId : this.typedPropertyLists.keySet()) {
            if (!this.isSelected(propertyTypeId, optionId)) continue;
            return true;
        }
        return false;
    }

    public boolean isFlagged(String propertyTypeId) {
        return FLAG_ENABLED.equals(this.getPropertyValue(propertyTypeId));
    }

    public void setFlag(String propertyTypeId, boolean flag) {
        this.setPropertyValue(propertyTypeId, flag ? FLAG_ENABLED : FLAG_DISABLED);
    }

    public boolean isSelected(String propertyTypeId, String optionId) {
        List<Property> entries;
        boolean result = false;
        PropertyList propertyList = this.typedPropertyLists.get(propertyTypeId);
        if (propertyList != null && (entries = this.typedPropertyLists.get(propertyTypeId).getProperties()) != null) {
            for (Property prop : entries) {
                if (prop.getPropertyValue() == null || !prop.getPropertyValue().equals(optionId)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public Property createNewProperty(PropertyType propertyType, String newValue) {
        if (propertyType == null) {
            throw new HuiRuntimeException("Property type is null.");
        }
        Property entry = PropertyFactory.create(propertyType, newValue, this);
        this.addProperty(entry);
        return entry;
    }

    public Property createNewProperty(String propertyTypeId, String propertyValue) {
        if (propertyTypeId == null) {
            throw new HuiRuntimeException("Property type id is null");
        }
        Property entry = PropertyFactory.create(propertyTypeId, propertyValue, this);
        this.addProperty(entry);
        return entry;
    }

    private void addProperty(Property property) {
        try {
            Tester.assertTrue("Eigenschaft nicht mehr definiert f\u00fcr Wert: '" + property.getPropertyValue() + "'.", property.getPropertyTypeID() != null);
            PropertyList typeList = this.typedPropertyLists.get(property.getPropertyTypeID());
            if (typeList != null) {
                typeList.add(property);
            } else {
                typeList = new PropertyList(1);
                typeList.add(property);
                this.typedPropertyLists.put(property.getPropertyTypeID(), typeList);
            }
        }
        catch (AssertException e) {
            logger.error((Object)e);
        }
    }

    public void remove(PropertyType propertyType, String propertyValue) {
        PropertyList list = this.typedPropertyLists.get(propertyType.getId());
        if (list == null) {
            return;
        }
        List<Property> setProperties = list.getProperties();
        Iterator<Property> iter = setProperties.iterator();
        while (iter.hasNext()) {
            Property property = iter.next();
            if (!property.getPropertyValue().equals(propertyValue)) continue;
            iter.remove();
        }
    }

    public int getInt(String propertyTypeId) {
        PropertyList propertyList = this.typedPropertyLists.get(propertyTypeId);
        if (propertyList == null || propertyList.getProperties().isEmpty()) {
            return 0;
        }
        PropertyType type = HUITypeFactory.getInstance().getPropertyType(this.entityType, propertyTypeId);
        if (type.isNumericSelect()) {
            return propertyList.getProperties().get(0).getNumericPropertyValue();
        }
        return 0;
    }

    public String getOptionValue(String propertyTypeId) {
        String value = null;
        PropertyList propertyList = this.typedPropertyLists.get(propertyTypeId);
        if (propertyList != null && propertyList.getProperties().size() == 1) {
            PropertyType type = HUITypeFactory.getInstance().getPropertyType(this.entityType, propertyTypeId);
            if (type.isSingleSelect()) {
                Property prop = propertyList.getProperties().get(0);
                value = prop.getPropertyValue();
            } else {
                logger.warn((Object)("Property " + propertyTypeId + " is not of type " + 2 + ". Can not determine option value. Entity id is: " + this.getDbId()));
            }
        } else if (propertyList != null && propertyList.getProperties().size() > 1) {
            logger.warn((Object)("Property list " + propertyTypeId + " contains more than entry. Can not determine option value. Entity id is: " + this.getDbId()));
        }
        return value;
    }

    protected List<Property> initializePropertyListForImport(String propertyTypeId) {
        List<Property> properties;
        PropertyList propertyList = this.typedPropertyLists.get(propertyTypeId);
        if (propertyList == null) {
            propertyList = new PropertyList();
            this.typedPropertyLists.put(propertyTypeId, propertyList);
        }
        if ((properties = propertyList.getProperties()) == null) {
            properties = new LinkedList<Property>();
            propertyList.setProperties(properties);
        } else {
            properties.clear();
        }
        return properties;
    }

    public int exportProperties(String propertyType, List<String> foreignProperties) {
        int amount = 0;
        for (Property prop : this.getProperties(propertyType).getProperties()) {
            foreignProperties.add(prop.getPropertyValue());
            ++amount;
        }
        return amount;
    }

    @Override
    public void select(IMLPropertyType type, IMLPropertyOption opt) {
        this.createNewProperty((PropertyType)type, opt.getId());
        this.fireSelectionChanged(type, opt);
    }

    @Override
    public void unselect(IMLPropertyType type, IMLPropertyOption opt) {
        this.remove((PropertyType)type, opt.getId());
        this.fireSelectionChanged(type, opt);
    }

    @Override
    public String getTypeId() {
        return TYPE_ID;
    }

    private synchronized List<IEntityChangedListener> getChangelisteners() {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<IEntityChangedListener>();
        }
        return this.changeListeners;
    }

    public void addChangeListener(IEntityChangedListener changeListener) {
        this.getChangelisteners().add(changeListener);
    }

    public void removeListener(IEntityChangedListener listener) {
        this.getChangelisteners().remove(listener);
    }

    private void fireSelectionChanged(IMLPropertyType type, IMLPropertyOption opt) {
        for (IEntityChangedListener listener : this.getChangelisteners()) {
            listener.selectionChanged(type, opt);
        }
    }

    void firePropertyChanged(Property prop, Object source) {
        for (IEntityChangedListener listener : this.getChangelisteners()) {
            listener.propertyChanged(new PropertyChangedEvent(this, prop, source));
        }
    }

    public Integer getDbId() {
        return this.dbId;
    }

    public void setDbId(Integer dbId) {
        this.dbId = dbId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getId() {
        return TITLE + this.getDbId();
    }

    public Map<String, PropertyList> getTypedPropertyLists() {
        return this.typedPropertyLists;
    }

    public void setTypedPropertyLists(Map<String, PropertyList> typedPropertyLists) {
        this.typedPropertyLists = typedPropertyLists;
    }

    public PropertyList getProperties(String propertyTypeId) {
        PropertyList propertyList = this.typedPropertyLists.get(propertyTypeId);
        if (propertyList == null) {
            propertyList = new PropertyList();
        }
        return propertyList;
    }

    public void addToReferenceValueCache(String propertyTypeId, String value) {
        this.getReferenceValueCache().put(propertyTypeId, value);
    }

    private Map<String, String> getReferenceValueCache() {
        if (this.referenceValueCache == null) {
            this.referenceValueCache = new HashMap<String, String>();
        }
        return this.referenceValueCache;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public java.util.Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(java.util.Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public void setChangedBy(String changedBy) {
        this.changedBy = changedBy;
    }

    public java.util.Date getChangedAt() {
        return this.changedAt;
    }

    public void setChangedAt(java.util.Date changedAt) {
        this.changedAt = changedAt;
    }

    public void trackCreation(String userName) {
        this.createdAt = new java.util.Date();
        this.createdBy = userName;
    }

    public void trackChange(String userName) {
        this.changedAt = new java.util.Date();
        this.changedBy = userName;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Entity && this.uuid.equals(((Entity)obj).getUuid());
    }

    public String toString() {
        return "Entity [entityType=" + this.entityType + ", dbId=" + this.dbId + ", uuid=" + this.uuid + "]";
    }
}

