/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import sernet.gs.service.NumericStringComparator;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.iso27k.rcp.ILinkedWithEditorView;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.iso27k.rcp.LinkWithEditorPartListener;
import sernet.verinice.model.bp.IBpModelListener;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.IBSIModelListener;
import sernet.verinice.model.catalog.CatalogModel;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.IISO27KModelListener;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.model.validation.CnAValidation;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.service.commands.crud.LoadPolymorphicCnAElementById;
import sernet.verinice.validation.CnAValidationContentProvider;
import sernet.verinice.validation.LoadValidationJob;
import sernet.verinice.validation.Messages;
import sernet.verinice.validation.RefreshValidationView;

public class CnAValidationView
extends RightsEnabledView
implements ILinkedWithEditorView {
    static final Logger LOG = Logger.getLogger(CnAValidationView.class);
    public static final String ID = "sernet.verinice.validation.CnAValidationView";
    private static final String STD_LOAD_ERRMSG = "Error while loading data";
    private TableViewer viewer;
    private TableComparator tableSorter = new TableComparator();
    private ICommandService commandService;
    private Action doubleClickAction;
    private Action refreshAction;
    private CnAValidationContentProvider contentProvider = new CnAValidationContentProvider(this);
    private IPartListener2 linkWithEditorPartListener = new LinkWithEditorPartListener(this);
    private boolean isLinkingActive = true;
    private CnATreeElement currentCnaElement;
    private IModelLoadListener modelLoadListener;
    private ISelectionListener selectionListener;
    private RightsServiceClient rightsService;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        parent.setLayout((Layout)new FillLayout());
        this.createTable(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookPageSelection();
        this.addBSIModelListeners();
        this.addISO27KModelListeners();
        this.hookModelLoadListener();
        this.makeActions();
        this.hookActions();
        this.fillLocalToolBar();
        this.getSite().getPage().addPartListener(this.linkWithEditorPartListener);
    }

    private void makeActions() {
        this.refreshAction = new Action(Messages.ValidationView_8, 0){

            public void run() {
                CnAValidationView.this.loadValidations();
            }
        };
        this.refreshAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("arrow_refresh.png"));
        this.doubleClickAction = new Action(){

            public void run() {
                if (CnAValidationView.this.viewer.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)CnAValidationView.this.viewer.getSelection()).getFirstElement() instanceof CnAValidation) {
                    try {
                        CnAValidation validation = (CnAValidation)((IStructuredSelection)CnAValidationView.this.viewer.getSelection()).getFirstElement();
                        LoadPolymorphicCnAElementById command = new LoadPolymorphicCnAElementById(new Integer[]{validation.getElmtDbId()});
                        command = (LoadPolymorphicCnAElementById)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                        if (command.getElements() != null && !command.getElements().isEmpty() && command.getElements().get(0) != null) {
                            EditorFactory.getInstance().updateAndOpenObject(command.getElements().get(0));
                        } else {
                            MessageDialog.openError((Shell)CnAValidationView.this.getSite().getShell(), (String)"Error", (String)"Object not found.");
                        }
                    }
                    catch (Exception t) {
                        LOG.error((Object)"Error while opening element.", (Throwable)t);
                    }
                }
            }
        };
    }

    private void hookActions() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CnAValidationView.this.doubleClickAction.run();
            }
        });
    }

    private void hookPageSelection() {
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                CnAValidationView.this.pageSelectionChanged(part, selection);
            }
        };
        this.getSite().getPage().addPostSelectionListener(this.selectionListener);
    }

    protected void pageSelectionChanged(IWorkbenchPart part, ISelection selection) {
        Object element = ((IStructuredSelection)selection).getFirstElement();
        this.elementSelected(element);
        if (element instanceof CnATreeElement) {
            this.currentCnaElement = (CnATreeElement)element;
        }
    }

    private void createTable(Composite parent) {
        int typeColumnWidth = 80;
        int nameColumnWidth = 150;
        int propertyColumnWidth = 100;
        int hintColumnWidth = 200;
        this.viewer = new TableViewer(parent, 66306);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ValidationLabelProvider());
        Table table = this.viewer.getTable();
        TableColumn elementTypeColumn = new TableColumn(table, 16384);
        elementTypeColumn.setWidth(80);
        elementTypeColumn.setText(Messages.ValidationView_5);
        elementTypeColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, elementTypeColumn, 0));
        TableColumn elementNameColumn = new TableColumn(table, 16384);
        elementNameColumn.setWidth(150);
        elementNameColumn.setText(Messages.ValidationView_4);
        elementNameColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, elementNameColumn, 1));
        TableColumn propertyColumn = new TableColumn(table, 16384);
        propertyColumn.setWidth(100);
        propertyColumn.setText(Messages.ValidationView_6);
        propertyColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, propertyColumn, 2));
        TableColumn hintColumn = new TableColumn(table, 16384);
        hintColumn.setText(Messages.ValidationView_7);
        hintColumn.setWidth(200);
        hintColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, hintColumn, 3));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setComparator((ViewerComparator)this.tableSorter);
    }

    @Override
    public void setFocus() {
    }

    protected void startInitDataJob() {
        WorkspaceJob initDataJob = new WorkspaceJob(Messages.ISMView_InitData){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        monitor.beginTask(Messages.ISMView_InitData, -1);
                        Activator.inheritVeriniceContextState();
                        CnAValidationView.this.loadValidations();
                    }
                    catch (Exception e) {
                        LOG.error((Object)CnAValidationView.STD_LOAD_ERRMSG, (Throwable)e);
                        status = new Status(4, "sernet.gs.ui.rcp.main", CnAValidationView.STD_LOAD_ERRMSG, (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        JobScheduler.scheduleInitJob(initDataJob);
    }

    private void loadValidations() {
        List<CnAValidation> validations = Collections.emptyList();
        if (this.currentCnaElement != null) {
            final LoadValidationJob job = new LoadValidationJob(this.currentCnaElement.getScopeId());
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    job.loadValidations();
                }
            });
            validations = job.getValidations();
            RefreshValidationView refresh = new RefreshValidationView(validations, this.viewer);
            refresh.refresh();
        }
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePostSelectionListener(this.selectionListener);
        this.getSite().getPage().removePartListener(this.linkWithEditorPartListener);
        CnAElementFactory.getInstance().removeLoadListener(this.modelLoadListener);
        this.removeModelListeners();
    }

    protected void removeModelListeners() {
        CnAElementFactory.getLoadedModel().removeBSIModelListener((IBSIModelListener)this.contentProvider);
        CnAElementFactory.getInstance().getISO27kModel().removeISO27KModelListener((IISO27KModelListener)this.contentProvider);
        CnAElementFactory.getInstance().getBpModel().removeBpModelListener((IBpModelListener)this.contentProvider);
    }

    protected void addISO27KModelListeners() {
        WorkspaceJob initDataJob = new WorkspaceJob(Messages.ISMView_InitData){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        monitor.beginTask(Messages.ISMView_InitData, -1);
                        if (CnAElementFactory.isIsoModelLoaded()) {
                            CnAElementFactory.getInstance().getISO27kModel().addISO27KModelListener((IISO27KModelListener)CnAValidationView.this.contentProvider);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)CnAValidationView.STD_LOAD_ERRMSG, (Throwable)e);
                        status = new Status(4, "sernet.gs.ui.rcp.main", Messages.ValidationView_3, (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        JobScheduler.scheduleInitJob(initDataJob);
    }

    protected void addBSIModelListeners() {
        WorkspaceJob initDataJob = new WorkspaceJob(Messages.ISMView_InitData){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        monitor.beginTask(Messages.ISMView_InitData, -1);
                        if (CnAElementFactory.isModelLoaded()) {
                            CnAElementFactory.getInstance();
                            CnAElementFactory.getLoadedModel().addBSIModelListener((IBSIModelListener)CnAValidationView.this.contentProvider);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)CnAValidationView.STD_LOAD_ERRMSG, (Throwable)e);
                        status = new Status(4, "sernet.gs.ui.rcp.main", Messages.ValidationView_3, (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        JobScheduler.scheduleInitJob(initDataJob);
    }

    protected void addBpModelListener() {
        WorkspaceJob initDataJob = new WorkspaceJob(Messages.ISMView_InitData){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        monitor.beginTask(Messages.ISMView_InitData, -1);
                        if (CnAElementFactory.isModelLoaded()) {
                            CnAElementFactory.getInstance().getBpModel().addModITBOModelListener((IBpModelListener)CnAValidationView.this.contentProvider);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)CnAValidationView.STD_LOAD_ERRMSG, (Throwable)e);
                        status = new Status(4, "sernet.gs.ui.rcp.main", Messages.ValidationView_3, (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        JobScheduler.scheduleInitJob(initDataJob);
    }

    private void hookModelLoadListener() {
        this.modelLoadListener = new IModelLoadListener(){

            @Override
            public void closed(BSIModel model) {
                CnAValidationView.this.removeModelListeners();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).CnAValidationView.this.viewer.setInput((Object)new PlaceHolder(""));
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void loaded(BSIModel model) {
                IModelLoadListener iModelLoadListener = CnAValidationView.this.modelLoadListener;
                synchronized (iModelLoadListener) {
                    CnAValidationView.this.startInitDataJob();
                    CnAValidationView.this.addBSIModelListeners();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void loaded(ISO27KModel model) {
                IModelLoadListener iModelLoadListener = CnAValidationView.this.modelLoadListener;
                synchronized (iModelLoadListener) {
                    CnAValidationView.this.startInitDataJob();
                    CnAValidationView.this.addISO27KModelListeners();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void loaded(BpModel model) {
                IModelLoadListener iModelLoadListener = CnAValidationView.this.modelLoadListener;
                synchronized (iModelLoadListener) {
                    CnAValidationView.this.startInitDataJob();
                }
            }

            @Override
            public void loaded(CatalogModel model) {
            }
        };
        CnAElementFactory.getInstance().addLoadListener(this.modelLoadListener);
    }

    private void fillLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.refreshAction);
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }

    @Override
    public void editorActivated(IEditorPart editor) {
        if (!this.isLinkingActive() || !this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this) || editor == null) {
            return;
        }
        CnATreeElement element = BSIElementEditorInput.extractElement(editor);
        if (element == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Element in editor :" + element.getUuid()));
            LOG.debug((Object)"Loading validationElements of element now...");
        }
        this.elementSelected(element);
    }

    protected void elementSelected(Object element) {
        try {
            if (element instanceof CnATreeElement) {
                this.setCurrentCnaElement((CnATreeElement)element);
                this.loadValidations();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading validations", (Throwable)e);
        }
    }

    private boolean isLinkingActive() {
        return this.isLinkingActive;
    }

    public void setCurrentCnaElement(CnATreeElement currentCnaElement) {
        if (currentCnaElement != null) {
            this.currentCnaElement = currentCnaElement;
            if (this.isLinkingActive()) {
                StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
                CnAValidation selectedValidation = null;
                if (selection != null) {
                    selectedValidation = (CnAValidation)selection.getFirstElement();
                }
                Object input = this.viewer.getInput();
                CnAValidation validationToSelect = this.determineValidationToSelect(input);
                boolean changeSelectedElement = false;
                if (selectedValidation != null && !selectedValidation.getElmtDbId().equals(this.currentCnaElement.getDbId()) || selectedValidation == null) {
                    changeSelectedElement = true;
                }
                if (validationToSelect != null && changeSelectedElement) {
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)validationToSelect), true);
                }
            }
        }
    }

    private CnAValidation determineValidationToSelect(Object input) {
        if (input instanceof ArrayList) {
            ArrayList inputList = (ArrayList)input;
            for (Object o : inputList) {
                CnAValidation validation;
                if (!(o instanceof CnAValidation) || !(validation = (CnAValidation)o).getElmtDbId().equals(this.currentCnaElement.getDbId())) continue;
                return validation;
            }
        }
        return null;
    }

    public void reloadAll() {
        this.loadValidations();
    }

    public RightsServiceClient getRightsService() {
        if (this.rightsService == null) {
            this.rightsService = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        }
        return this.rightsService;
    }

    @Override
    public String getRightID() {
        return "cnavalidation";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    private static class SortSelectionAdapter
    extends SelectionAdapter {
        private CnAValidationView validationView;
        private TableColumn column;
        private int index;

        public SortSelectionAdapter(CnAValidationView validationView, TableColumn column, int index) {
            this.validationView = validationView;
            this.column = column;
            this.index = index;
        }

        public void widgetSelected(SelectionEvent e) {
            this.validationView.tableSorter.setColumn(this.index);
            int dir = this.validationView.viewer.getTable().getSortDirection();
            dir = this.validationView.viewer.getTable().getSortColumn() == this.column ? (dir == 128 ? 1024 : 128) : 1024;
            this.validationView.viewer.getTable().setSortDirection(dir);
            this.validationView.viewer.getTable().setSortColumn(this.column);
            this.validationView.viewer.refresh();
        }
    }

    private static class TableComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DEFAULT_SORT_COLUMN = 0;
        private static final int DESCENDING = 1;
        private static final int ASCENDING = 0;
        private int direction = 0;
        private NumericStringComparator comparator = new NumericStringComparator();

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = this.direction == 0 ? 1 : 0;
            } else {
                this.propertyIndex = column;
                this.direction = 0;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            CnAValidation a1 = (CnAValidation)e1;
            CnAValidation a2 = (CnAValidation)e2;
            int rc = 0;
            if (e1 == null) {
                if (e2 != null) {
                    rc = 1;
                }
            } else if (e2 == null) {
                rc = -1;
            } else {
                switch (this.propertyIndex) {
                    case 0: {
                        if (a1.getElementType() != null && a2.getElementType() != null) {
                            rc = this.compareByType(a1, a2);
                            break;
                        }
                    }
                    case 1: {
                        if (a1.getElmtTitle() == null || a2.getElmtTitle() == null) break;
                        rc = this.compareByName(a1, a2);
                        break;
                    }
                    case 2: {
                        rc = this.compareByAttribute(a1, a2);
                        break;
                    }
                    case 3: {
                        rc = this.compareByHint(a1, a2);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("propertyIndex not possible in this table");
                    }
                }
                if (!this.compareReturnsEquals(rc)) {
                    if (this.direction == 1) {
                        rc = -rc;
                    }
                    return rc;
                }
                rc = this.compareByType(a1, a2);
                if (!this.compareReturnsEquals(rc)) {
                    return rc;
                }
                rc = this.compareByName(a1, a2);
                if (!this.compareReturnsEquals(rc)) {
                    return rc;
                }
                rc = this.compareByAttribute(a1, a2);
                if (!this.compareReturnsEquals(rc)) {
                    return rc;
                }
                rc = this.compareByHint(a1, a2);
            }
            return rc;
        }

        private boolean compareReturnsEquals(int rc) {
            return rc == 0;
        }

        private int compareByHint(CnAValidation a1, CnAValidation a2) {
            String hintA1 = a1.getHintId();
            String hintA2 = a2.getHintId();
            return this.comparator.compare((Object)hintA1, (Object)hintA2);
        }

        private int compareByAttribute(CnAValidation a1, CnAValidation a2) {
            String propertyA1 = HUITypeFactory.getInstance().getMessage(a1.getPropertyId());
            String propertyA2 = HUITypeFactory.getInstance().getMessage(a2.getPropertyId());
            return this.comparator.compare((Object)propertyA1, (Object)propertyA2);
        }

        private int compareByName(CnAValidation a1, CnAValidation a2) {
            String titleA1 = a1.getElmtTitle();
            String titleA2 = a2.getElmtTitle();
            return this.comparator.compare((Object)titleA1, (Object)titleA2);
        }

        private int compareByType(CnAValidation a1, CnAValidation a2) {
            String typeA1 = HUITypeFactory.getInstance().getMessage(a1.getElementType());
            String typeA2 = HUITypeFactory.getInstance().getMessage(a2.getElementType());
            return this.comparator.compare((Object)typeA1, (Object)typeA2);
        }
    }

    private static class ValidationLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ValidationLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof PlaceHolder) {
                return null;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            block10: {
                try {
                    if (!(element instanceof PlaceHolder)) break block10;
                    if (columnIndex == 1) {
                        PlaceHolder ph = (PlaceHolder)element;
                        return ph.getTitle();
                    }
                    return "";
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while getting column text", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            CnAValidation validation = (CnAValidation)element;
            switch (columnIndex) {
                case 0: {
                    return HUITypeFactory.getInstance().getMessage(validation.getElementType());
                }
                case 1: {
                    return validation.getElmtTitle();
                }
                case 2: {
                    return HUITypeFactory.getInstance().getMessage(validation.getPropertyId());
                }
                case 3: {
                    return validation.getHintId();
                }
            }
            return null;
        }
    }
}

