/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.validation;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.interfaces.validation.IValidationService;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.RightsEnabledActionDelegate;
import sernet.verinice.validation.CreateValidationsJob;

public class CnAValidationAction
extends RightsEnabledActionDelegate
implements RightEnabledUserInteraction {
    private static final Logger LOG = Logger.getLogger(CnAValidationAction.class);
    private List<?> rootObjects;
    private IValidationService validationService;

    @Override
    public void doRun(IAction action) {
        try {
            for (Object rootObject : this.rootObjects) {
                if (!(rootObject instanceof CnATreeElement) || !((CnATreeElement)rootObject).isScope()) continue;
                CnATreeElement cnATreeElement = (CnATreeElement)rootObject;
                int scopeID = cnATreeElement.getScopeId();
                CreateValidationsJob validationJob = new CreateValidationsJob(scopeID);
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                progressService.run(true, true, (IRunnableWithProgress)validationJob);
                CnAElementFactory.getModel(cnATreeElement).validationAdded(Integer.valueOf(scopeID));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while executing validation action", (Throwable)e);
        }
    }

    public String getRightID() {
        return "cnavalidation";
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.isServerRunning()) {
            action.setEnabled(this.checkRights());
        }
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            this.rootObjects = treeSelection.toList();
        }
    }

    protected HUITypeFactory getTypeFactory() {
        return (HUITypeFactory)VeriniceContext.get((String)"huiTypeFactory");
    }

    public IValidationService getValidationService() {
        if (this.validationService == null) {
            this.validationService = (IValidationService)VeriniceContext.get((String)"validationService");
        }
        return this.validationService;
    }

    public void setRootObjects(List<Object> rootObjects) {
        this.rootObjects = rootObjects;
    }
}

