/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.ui;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;

public class DesktopUtil {
    private static final Logger LOG = Logger.getLogger(DesktopUtil.class);

    public static boolean open(File file) {
        if (DesktopUtil.openSystemSpecific(file.getPath())) {
            return true;
        }
        if (DesktopUtil.openDESKTOP(file)) {
            return true;
        }
        LOG.warn((Object)String.format("failed to open %s", file.getAbsolutePath()));
        return false;
    }

    private static boolean openSystemSpecific(String what) {
        if (SystemUtils.IS_OS_LINUX) {
            if (DesktopUtil.isXDG() && DesktopUtil.runCommand("xdg-open", "%s", what)) {
                return true;
            }
            if (DesktopUtil.isKDE() && DesktopUtil.runCommand("kde-open", "%s", what)) {
                return true;
            }
            if (DesktopUtil.isGNOME() && DesktopUtil.runCommand("gnome-open", "%s", what)) {
                return true;
            }
            if (DesktopUtil.runCommand("kde-open", "%s", what)) {
                return true;
            }
            if (DesktopUtil.runCommand("gnome-open", "%s", what)) {
                return true;
            }
        }
        if (SystemUtils.IS_OS_MAC && DesktopUtil.runCommand("/usr/bin/open", "%s", what)) {
            return true;
        }
        return SystemUtils.IS_OS_WINDOWS && DesktopUtil.runCommand("explorer", "%s", what);
    }

    private static boolean openDESKTOP(File file) {
        block5: {
            block4: {
                try {
                    if (Desktop.isDesktopSupported()) break block4;
                    LOG.debug((Object)"Platform is not supported.");
                    return false;
                }
                catch (Throwable t) {
                    LOG.error((Object)"Error using desktop open.", t);
                    return false;
                }
            }
            if (Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) break block5;
            LOG.debug((Object)"OPEN is not supported.");
            return false;
        }
        LOG.info((Object)("Trying to use Desktop.getDesktop().open() with " + file.toString()));
        Desktop.getDesktop().open(file);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean runCommand(String command, String args, String file) {
        LOG.info((Object)("Trying to exec:\n   cmd = " + command + "\n   args = " + args + "\n   %s = " + file));
        String[] parts = DesktopUtil.prepareCommand(command, args, file);
        try {
            Process p;
            if (SystemUtils.IS_OS_MAC) {
                System.setProperty("jdk.lang.Process.launchMechanism", "FORK");
            }
            if ((p = Runtime.getRuntime().exec(parts)) == null) {
                return false;
            }
            try {
                int retval = p.exitValue();
                if (retval == 0) {
                    LOG.error((Object)"Process ended immediately.");
                    return false;
                }
                LOG.error((Object)"Process crashed.");
                return false;
            }
            catch (IllegalThreadStateException itse) {
                LOG.error((Object)"Process is running.");
                return true;
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error running command.", (Throwable)e);
            return false;
        }
    }

    private static String[] prepareCommand(String command, String args, String file) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(command);
        if (args != null) {
            String[] stringArray = args.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                s = String.format(s, file);
                parts.add(s.trim());
                ++n2;
            }
        }
        return parts.toArray(new String[parts.size()]);
    }

    private static boolean isXDG() {
        String xdgSessionId = System.getenv("XDG_SESSION_ID");
        return xdgSessionId != null && !xdgSessionId.isEmpty();
    }

    private static boolean isGNOME() {
        String gdmSession = System.getenv("GDMSESSION");
        return gdmSession != null && gdmSession.toLowerCase().contains("gnome");
    }

    private static boolean isKDE() {
        String gdmSession = System.getenv("GDMSESSION");
        return gdmSession != null && gdmSession.toLowerCase().contains("kde");
    }

    private DesktopUtil() {
    }
}

