/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.rcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.IReportDepositService;
import sernet.verinice.interfaces.IReportTemplateService;
import sernet.verinice.interfaces.ReportDepositException;
import sernet.verinice.interfaces.ReportTemplateServiceException;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.model.report.ReportTemplateMetaData;
import sernet.verinice.rcp.ReportTemplateSyncer;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.report.rcp.AddReportToDepositDialog;
import sernet.verinice.report.rcp.Messages;
import sernet.verinice.report.rcp.ReportDepositContentProvider;

public class ReportDepositView
extends RightsEnabledView {
    static final Logger LOG = Logger.getLogger(ReportDepositView.class);
    public static final String ID = "sernet.verinice.report.rcp.ReportDepositView";
    private RightsServiceClient rightsService;
    private ICommandService commandService;
    private TableSorter tableSorter = new TableSorter();
    private TableViewer viewer;
    private ReportDepositContentProvider contentprovider = new ReportDepositContentProvider(this);
    private RightsEnabledAction addTemplateAction;
    private RightsEnabledAction deleteTemplateAction;
    private RightsEnabledAction editTemplateAction;
    private Action doubleclickAction;
    private Action refreshAction;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (Activator.getDefault().isStandalone()) {
            return;
        }
        parent.setLayout((Layout)new FillLayout());
        this.createTable(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addPostSelectionListener(this::pageSelectionChanged);
        this.makeActions();
        this.hookActions();
        this.fillLocalToolBar();
        this.viewer.setInput(this.getContent());
    }

    private void createTable(Composite parent) {
        int reportNameWidth = 200;
        int contextWidth = 100;
        int outputFormatWidth = 200;
        int templateWidth = 100;
        this.viewer = new TableViewer(parent, 66306);
        this.viewer.setContentProvider((IContentProvider)this.contentprovider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ReportDepositLabelProvider());
        Table table = this.viewer.getTable();
        TableColumn reportNameColumn = new TableColumn(table, 16384);
        reportNameColumn.setWidth(200);
        reportNameColumn.setText(Messages.ReportDepositView_1);
        reportNameColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, reportNameColumn, 0));
        TableColumn contextColumn = new TableColumn(table, 16384);
        contextColumn.setWidth(100);
        contextColumn.setText(Messages.ReportMetaDataContext);
        contextColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, contextColumn, 1));
        TableColumn outputFormatColumn = new TableColumn(table, 16384);
        outputFormatColumn.setWidth(200);
        outputFormatColumn.setText(Messages.ReportDepositView_2);
        outputFormatColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, outputFormatColumn, 2));
        TableColumn templateColumn = new TableColumn(table, 16384);
        templateColumn.setWidth(100);
        templateColumn.setText(Messages.ReportDepositView_3);
        templateColumn.addSelectionListener((SelectionListener)new SortSelectionAdapter(this, templateColumn, 3));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setComparator((ViewerComparator)this.tableSorter);
        ((TableSorter)this.viewer.getComparator()).setColumn(0);
    }

    protected void pageSelectionChanged(IWorkbenchPart part, ISelection selection) {
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element instanceof ReportTemplateMetaData) {
            this.editTemplateAction.setEnabled(true);
            this.deleteTemplateAction.setEnabled(true);
        } else {
            this.editTemplateAction.setEnabled(false);
            this.deleteTemplateAction.setEnabled(false);
        }
    }

    private void hookActions() {
        this.viewer.addDoubleClickListener(event -> this.doubleclickAction.run());
    }

    private void makeActions() {
        this.addTemplateAction = new RightsEnabledAction("reportdepositadd"){

            @Override
            public void doRun() {
                AddReportToDepositDialog dlg = new AddReportToDepositDialog(Display.getDefault().getActiveShell());
                dlg.open();
                ReportDepositView.this.updateView();
            }
        };
        this.addTemplateAction.setText(Messages.ReportDepositView_5);
        this.addTemplateAction.setToolTipText(Messages.ReportDepositView_7);
        this.addTemplateAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("note-new.png"));
        this.addTemplateAction.setEnabled(true);
        this.deleteTemplateAction = new RightsEnabledAction("reportdepositdelete"){

            @Override
            public void doRun() {
                int count = ((IStructuredSelection)ReportDepositView.this.viewer.getSelection()).size();
                boolean confirm = MessageDialog.openConfirm((Shell)ReportDepositView.this.viewer.getControl().getShell(), (String)Messages.ReportDepositView_15, (String)NLS.bind((String)Messages.ReportDepositView_16, (Object)count));
                if (!confirm) {
                    return;
                }
                ReportDepositView.this.deleteAttachments();
                ReportDepositView.this.updateView();
            }
        };
        this.deleteTemplateAction.setText(Messages.ReportDepositView_13);
        this.deleteTemplateAction.setToolTipText(Messages.ReportDepositView_14);
        this.deleteTemplateAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("delete.png"));
        this.deleteTemplateAction.setEnabled(false);
        this.editTemplateAction = new RightsEnabledAction("reportdepositedit"){

            @Override
            public void doRun() {
                int count = ((IStructuredSelection)ReportDepositView.this.viewer.getSelection()).size();
                if (count == 1) {
                    AddReportToDepositDialog dlg = new AddReportToDepositDialog(Display.getDefault().getActiveShell(), (ReportTemplateMetaData)((IStructuredSelection)ReportDepositView.this.viewer.getSelection()).getFirstElement());
                    dlg.open();
                    ReportDepositView.this.updateView();
                } else {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.ReportDepositView_20, (String)Messages.ReportDepositView_21);
                }
            }
        };
        this.editTemplateAction.setText(Messages.ReportDepositView_17);
        this.editTemplateAction.setToolTipText(Messages.ReportDepositView_18);
        this.editTemplateAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("edit.png"));
        this.editTemplateAction.setEnabled(false);
        this.refreshAction = new Action(){

            public void run() {
                JobScheduler.scheduleInitJob(new WorkspaceJob("load-deposit-content"){

                    public IStatus runInWorkspace(IProgressMonitor arg0) throws CoreException {
                        Activator.inheritVeriniceContextState();
                        IStatus status = Status.OK_STATUS;
                        Object content = ReportDepositView.this.getContent();
                        ReportDepositView.this.setInput(content);
                        return status;
                    }
                });
            }
        };
        this.refreshAction.setText(Messages.ReportDepositView_19);
        this.refreshAction.setToolTipText(Messages.ReportDepositView_19);
        this.refreshAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("arrow_refresh.png"));
        this.refreshAction.setEnabled(true);
        this.doubleclickAction = new Action(){

            public void run() {
                ReportDepositView.this.editTemplateAction.run();
            }
        };
    }

    private void fillLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.addTemplateAction);
        manager.add((IAction)this.editTemplateAction);
        manager.add((IAction)this.deleteTemplateAction);
    }

    @Override
    public String getRightID() {
        return "reportdeposit";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    public RightsServiceClient getRightsService() {
        if (this.rightsService == null) {
            this.rightsService = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        }
        return this.rightsService;
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }

    private Object getContent() {
        try {
            Set templateSet = this.getReportService().getReportTemplates(Locale.getDefault());
            return templateSet.toArray(new ReportTemplateMetaData[templateSet.size()]);
        }
        catch (ReportTemplateServiceException e) {
            String msg = "Something went wrong with reading the propertyfiles";
            ExceptionUtil.log(e, msg);
        }
        catch (Exception e) {
            String msg = "Error reading reports from deposit";
            ExceptionUtil.log(e, msg);
        }
        return new PlaceHolder(Messages.ReportDepositView_4);
    }

    private IReportDepositService getReportService() {
        return ServiceFactory.lookupReportDepositService();
    }

    private void deleteAttachments() {
        for (ReportTemplateMetaData sel : (IStructuredSelection)this.viewer.getSelection()) {
            try {
                ServiceFactory.lookupReportDepositService().remove(sel, Locale.getDefault());
            }
            catch (ReportDepositException e) {
                ExceptionUtil.log(e, "Error deleting Reporttemplate:\t" + sel.getOutputname());
            }
        }
    }

    private void updateView() {
        ReportTemplateSyncer.sync();
        this.setInput(this.getContent());
    }

    private void setInput(Object content) {
        ReportDepositView.getDisplay().syncExec(() -> this.viewer.setInput(content));
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private static class ReportDepositLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ReportDepositLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            block12: {
                if (!(element instanceof PlaceHolder)) break block12;
                if (columnIndex == 1) {
                    PlaceHolder ph = (PlaceHolder)element;
                    return ph.getTitle();
                }
                return "";
            }
            try {
                ReportTemplateMetaData data = (ReportTemplateMetaData)element;
                switch (columnIndex) {
                    case 0: {
                        return data.getOutputname();
                    }
                    case 1: {
                        return data.getContext().prettyString();
                    }
                    case 2: {
                        StringBuilder sb = new StringBuilder();
                        IReportTemplateService.OutputFormat[] formats = data.getOutputFormats();
                        int i = 0;
                        while (i < formats.length) {
                            sb.append(formats[i]);
                            if (i != formats.length - 1) {
                                sb.append(", ");
                            }
                            ++i;
                        }
                        return sb.toString();
                    }
                    case 3: {
                        return data.getFilename();
                    }
                }
                return null;
            }
            catch (Exception e) {
                LOG.error((Object)"Error while getting column text", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private static class SortSelectionAdapter
    extends SelectionAdapter {
        private ReportDepositView depositView;
        private TableColumn column;
        private int index;

        public SortSelectionAdapter(ReportDepositView depositView, TableColumn column, int index) {
            this.depositView = depositView;
            this.column = column;
            this.index = index;
        }

        public void widgetSelected(SelectionEvent e) {
            this.depositView.tableSorter.setColumn(this.index);
            int dir = this.depositView.viewer.getTable().getSortDirection();
            dir = this.depositView.viewer.getTable().getSortColumn() == this.column ? (dir == 128 ? 1024 : 128) : 1024;
            this.depositView.viewer.getTable().setSortDirection(dir);
            this.depositView.viewer.getTable().setSortColumn(this.column);
            this.depositView.viewer.refresh();
        }
    }

    private static class TableSorter
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DEFAULT_SORT_COLUMN = 0;
        private static final int DESCENDING = 1;
        private static final int ASCENDING = 0;
        private int direction = 1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = this.direction == 0 ? 1 : 0;
            } else {
                this.propertyIndex = column;
                this.direction = 0;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ReportTemplateMetaData data1 = (ReportTemplateMetaData)e1;
            ReportTemplateMetaData data2 = (ReportTemplateMetaData)e2;
            int rc = 0;
            if (e1 == null) {
                if (e2 != null) {
                    rc = 1;
                }
            } else if (e2 == null) {
                rc = -1;
            } else {
                switch (this.propertyIndex) {
                    case 0: {
                        rc = this.comporeToLowerCase(data1.getDecoratedOutputname(), data2.getDecoratedOutputname());
                        break;
                    }
                    case 1: {
                        rc = data1.getContext().compareTo((Enum)data2.getContext());
                        break;
                    }
                    case 2: {
                        String s1 = this.getSortedOutputFormatsString(data1.getOutputFormats());
                        String s2 = this.getSortedOutputFormatsString(data2.getOutputFormats());
                        if (s1 == null || s2 == null) break;
                        rc = s1.compareTo(s2);
                        break;
                    }
                    case 3: {
                        rc = this.comporeToLowerCase(data1.getFilename(), data2.getFilename());
                        break;
                    }
                    default: {
                        rc = 0;
                    }
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }

        private int comporeToLowerCase(String filename1, String filename2) {
            int rc = 0;
            if (filename1 != null && filename2 != null) {
                rc = filename1.toLowerCase().compareTo(filename2.toLowerCase());
            }
            return rc;
        }

        private String getSortedOutputFormatsString(IReportTemplateService.OutputFormat[] input) {
            ArrayList<String> list = new ArrayList<String>();
            IReportTemplateService.OutputFormat[] outputFormatArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                IReportTemplateService.OutputFormat format = outputFormatArray[n2];
                list.add(format.toString());
                ++n2;
            }
            Collections.sort(list);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < list.size()) {
                sb.append((String)list.get(i));
                if (i != list.size() - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            return sb.toString();
        }
    }
}

