/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.rcp;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sernet.verinice.model.report.ReportTemplateMetaData;
import sernet.verinice.report.rcp.Messages;

public class MultipleSelectionCombo<T>
extends Composite {
    Text displayText = null;
    Object[] selectedElements = new Object[0];
    Shell floatShell = null;
    CheckboxTableViewer list = null;
    Button dropButton = null;
    private ReportTemplateMetaData[] input;
    private ILabelProvider lableProvider;
    private ViewerFilter viewerFilter;
    private SelectionConsumer<T> listener;
    private int stringLength;

    public MultipleSelectionCombo(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    private void init() {
        GridLayout layout = new GridLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.displayText = new Text((Composite)this, 2048);
        this.displayText.setLayoutData((Object)new GridData(768));
        this.displayText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (MultipleSelectionCombo.this.floatShell == null) {
                    MultipleSelectionCombo.this.initFloatShell();
                }
            }
        });
    }

    private void initFloatShell() {
        Point p = this.displayText.getParent().toDisplay(this.displayText.getLocation());
        Point size = this.displayText.getSize();
        this.stringLength = (int)((float)size.x / this.displayText.getFont().getFontData()[0].height);
        Rectangle shellRect = new Rectangle(p.x, p.y + size.y, size.x, 0);
        this.floatShell = new Shell(this.getShell(), 8);
        GridLayout gl = new GridLayout();
        gl.marginBottom = 2;
        gl.marginTop = 2;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.floatShell.setLayout((Layout)gl);
        this.list = CheckboxTableViewer.newCheckList((Composite)this.floatShell, (int)2848);
        this.list.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.list.setInput((Object)this.input);
        this.list.setLabelProvider((IBaseLabelProvider)this.lableProvider);
        if (this.viewerFilter != null) {
            this.list.setFilters(new ViewerFilter[]{this.viewerFilter});
        }
        this.list.setCheckedElements(this.selectedElements);
        if (this.selectedElements.length != 0) {
            this.list.reveal(this.selectedElements[0]);
        }
        GridData gd = new GridData(1808);
        this.list.getTable().setLayoutData((Object)gd);
        this.floatShell.setSize(shellRect.width, 160);
        this.floatShell.setLocation(shellRect.x, shellRect.y);
        this.floatShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent arg0) {
                if (MultipleSelectionCombo.this.floatShell != null && !MultipleSelectionCombo.this.floatShell.isDisposed()) {
                    MultipleSelectionCombo.this.internalSelectItems(MultipleSelectionCombo.this.list.getCheckedElements());
                    MultipleSelectionCombo.this.floatShell.close();
                    MultipleSelectionCombo.this.floatShell = null;
                }
            }
        });
        this.floatShell.open();
    }

    public void setText(String text) {
        this.displayText.setText(text);
    }

    public String getText() {
        return this.displayText.getText();
    }

    public void setInput(ReportTemplateMetaData[] reportTemplates) {
        this.input = reportTemplates;
    }

    public void setLabelProvider(LabelProvider labelProvider) {
        this.lableProvider = labelProvider;
    }

    public void setFilters(ViewerFilter viewerFilter) {
        this.viewerFilter = viewerFilter;
        if (this.list != null && !this.list.getTable().isDisposed()) {
            this.list.setFilters(new ViewerFilter[]{viewerFilter});
        }
    }

    public void resetFilters() {
        this.viewerFilter = null;
        if (this.list != null && !this.list.getTable().isDisposed()) {
            this.list.resetFilters();
        }
    }

    public void setSelectionChangedConsumer(SelectionConsumer<T> listener) {
        this.listener = listener;
    }

    public void setSelectedElements(Object[] selectedElements) {
        this.internalSelectItems(selectedElements);
    }

    public void setSelectedIndexByName(String selectedElements) {
        List<String> selectedElement = Arrays.asList(selectedElements.split(","));
        Object[] objects = Arrays.asList(this.input).stream().filter(rmd -> selectedElement.contains(rmd.getDecoratedOutputname())).collect(Collectors.toList()).toArray();
        this.internalSelectItems(objects);
    }

    private void displayText() {
        String dt = Arrays.asList(this.selectedElements).stream().map(s -> this.lableProvider.getText(s)).map(String.class::cast).collect(Collectors.joining(Messages.MultipleSelectionCombo_separator));
        this.displayText.setToolTipText(dt);
        if (this.selectedElements.length > 2 && dt.length() > this.stringLength) {
            this.displayText.setText(Messages.bind((String)Messages.MultipleSelectionCombo_cutted_expression, (Object)this.selectedElements.length, (Object)dt.substring(0, this.stringLength)));
        } else {
            this.displayText.setText(dt);
        }
    }

    private void internalSelectItems(Object[] objects) {
        this.selectedElements = objects;
        this.displayText();
        this.callSelectionConsumer();
    }

    private void callSelectionConsumer() {
        if (this.listener != null) {
            List<Object> asList = Arrays.asList(this.selectedElements);
            this.listener.consume(asList);
        }
    }

    @FunctionalInterface
    public static interface SelectionConsumer<T> {
        public void consume(List<T> var1);
    }
}

