/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.rcp;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import sernet.gs.service.NumericStringComparator;
import sernet.gs.service.StringUtil;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ServiceComponent;
import sernet.gs.ui.rcp.main.reports.IReportSupplier;
import sernet.gs.ui.rcp.main.reports.ReportSupplierImpl;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandCacheClient;
import sernet.verinice.interfaces.IReportDepositService;
import sernet.verinice.interfaces.report.IOutputFormat;
import sernet.verinice.interfaces.report.IReportType;
import sernet.verinice.interfaces.validation.IValidationService;
import sernet.verinice.model.bp.elements.ItNetwork;
import sernet.verinice.model.bsi.ITVerbund;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Organization;
import sernet.verinice.model.report.ReportTemplateMetaData;
import sernet.verinice.report.rcp.Messages;
import sernet.verinice.report.rcp.MultipleSelectionCombo;
import sernet.verinice.service.commands.crud.LoadCnAElementByType;
import sernet.verinice.service.commands.crud.LoadCnATreeElementTitles;

public class GenerateReportDialog
extends TitleAreaDialog {
    private DataBindingContext bindingContext = new DataBindingContext();
    private static final Logger LOG = Logger.getLogger(GenerateReportDialog.class);
    private static final NumericStringComparator comparator = new NumericStringComparator();
    private static final int DEFAULT_COL_NR = 3;
    static final int DATA_SCOPE_MINIMUM_WIDTH = 200;
    static final int DATA_SCOPE_COMBO_MINIMUM_WIDTH = 500;
    private static final int MARGIN_WIDTH = 10;
    private CnATreeElement selectedScope;
    private MultipleSelectionCombo<ReportTemplateMetaData> reportSelector;
    private ComboViewer comboOutputFormat;
    private File outputFile;
    private ReportTemplateMetaData[] reportTemplates;
    private IOutputFormat chosenOutputFormat;
    private List<ReportTemplateMetaData> chosenReportsMetaData = new ArrayList<ReportTemplateMetaData>();
    private Integer rootElement;
    private Integer[] rootElements;
    private Combo scopeCombo;
    private List<CnATreeElement> scopes = new ArrayList<CnATreeElement>();
    private Integer auditId = null;
    private String auditName = null;
    private List<CnATreeElement> preSelectedElments;
    private String useCase;
    private boolean isContextMenuCall;
    private boolean useDate = true;
    private String defaultFolder;
    private IReportType chosenReportType;
    private static final int SIZE_X = 750;
    private static final int SIZE_Y = 550;
    private IReportSupplier supplier;
    private WritableValue<String> classificationHint = new WritableValue();
    private WritableValue<String> scopeName = new WritableValue();

    public GenerateReportDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x400);
        this.auditId = null;
        this.auditName = null;
    }

    public GenerateReportDialog(Shell shell, Object reportScope) {
        this(shell);
        CnATreeElement cnaElmt;
        this.useCase = reportScope instanceof Organization || reportScope instanceof ITVerbund ? "use_case_report_general" : "use_case_report_always";
        this.selectedScope = cnaElmt = (CnATreeElement)reportScope;
        this.auditId = cnaElmt.getDbId();
        this.auditName = cnaElmt.getTitle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting audit in report dialog: " + this.auditId));
        }
    }

    public GenerateReportDialog(Shell shell, List<?> objects, String useCase) {
        this(shell);
        ArrayList<CnATreeElement> elmts = new ArrayList<CnATreeElement>();
        for (Object object : objects) {
            CnATreeElement cnaElmt = (CnATreeElement)object;
            elmts.add(cnaElmt);
        }
        this.preSelectedElments = elmts;
        this.useCase = useCase;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.GenerateReportDialog_4);
        Point cursorLocation = Display.getCurrent().getCursorLocation();
        newShell.setLocation(new Point(cursorLocation.x - 375, cursorLocation.y - 275));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.initDefaultFolder();
        IReportType[] reportTypes = ServiceComponent.getDefault().getReportService().getReportTypes();
        try {
            List<ReportTemplateMetaData> list = this.getSupplier().getReportTemplates(Locale.getDefault());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Locale used on system (client):\t" + Locale.getDefault().getLanguage()));
                LOG.debug((Object)(String.valueOf(list.size()) + " Reporttemplates loaded from deposit folders"));
            }
            this.reportTemplates = (ReportTemplateMetaData[])list.stream().sorted((template1, template2) -> comparator.compare((Object)template1.getDecoratedOutputname(), (Object)template2.getDecoratedOutputname())).toArray(ReportTemplateMetaData[]::new);
        }
        catch (Exception e2) {
            String msg = "Error reading reports from deposit";
            ExceptionUtil.log(e2, msg);
        }
        if (this.useCase != null) {
            this.filterReportTypes();
        }
        this.setTitle(Messages.GenerateReportDialog_0);
        StringBuilder dialogMessage = new StringBuilder();
        dialogMessage.append(Messages.GenerateReportDialog_7);
        dialogMessage.append(" ");
        dialogMessage.append(Messages.GenerateReportDialog_36);
        this.setMessage(dialogMessage.toString());
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Group reportGroup = this.createGroup(composite);
        Label labelReportType = new Label((Composite)reportGroup, 0);
        labelReportType.setText(Messages.GenerateReportDialog_1);
        GridData gdLabelReportType = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLabelReportType.widthHint = 190;
        labelReportType.setLayoutData((Object)gdLabelReportType);
        this.reportSelector = new MultipleSelectionCombo((Composite)reportGroup, 8);
        this.reportSelector.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.reportSelector.setLabelProvider(new LabelProvider(){

            public String getText(Object element) {
                return ((ReportTemplateMetaData)element).getDecoratedOutputname();
            }
        });
        this.reportSelector.setInput(this.reportTemplates);
        this.reportSelector.setSelectionChangedConsumer(chosenTemplates -> {
            this.chosenReportsMetaData = chosenTemplates;
            if (!chosenTemplates.isEmpty()) {
                this.chosenReportType = reportTypes[0];
                if (!this.isContextMenuCall()) {
                    this.setupComboScopes(((ReportTemplateMetaData)chosenTemplates.get(0)).getContext());
                }
            }
            this.setupComboOutputFormatContent();
        });
        Label labelScope = new Label((Composite)reportGroup, 0);
        GridData gdLabelScope = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLabelScope.widthHint = 190;
        labelScope.setLayoutData((Object)gdLabelScope);
        labelScope.setText(Messages.GenerateReportDialog_8);
        this.scopeCombo = new Combo((Composite)reportGroup, 8);
        this.scopeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.scopeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateReportDialog.this.selectScope();
            }
        });
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.scopeCombo), this.scopeName, null, null);
        Label labelOutputFormat = new Label((Composite)reportGroup, 0);
        GridData gdLabelOutputFormat = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLabelOutputFormat.widthHint = 190;
        labelOutputFormat.setLayoutData((Object)gdLabelOutputFormat);
        labelOutputFormat.setText(Messages.GenerateReportDialog_9);
        this.comboOutputFormat = new ComboViewer((Composite)reportGroup, 8);
        this.comboOutputFormat.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboOutputFormat.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IOutputFormat)element).getLabel();
            }
        });
        this.comboOutputFormat.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.comboOutputFormat.addSelectionChangedListener(e -> {
            if (!this.chosenReportsMetaData.isEmpty()) {
                this.chosenOutputFormat = (IOutputFormat)e.getStructuredSelection().getFirstElement();
            }
        });
        Label labelClassification = new Label((Composite)reportGroup, 0);
        labelClassification.setText(Messages.GenerateReportDialog_lblclassification);
        ComboViewer comboClassification = new ComboViewer((Composite)reportGroup, 0);
        comboClassification.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        comboClassification.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboClassification.setInput((Object)ServiceComponent.getDefault().getReportService().getClassificationHints());
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)comboClassification.getCombo()), this.classificationHint, null, null);
        if (!this.isContextMenuCall()) {
            Button reset = new Button((Composite)reportGroup, 131072);
            reset.setText(Messages.GenerateReportDialog_40);
            reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    GenerateReportDialog.this.rootElement = null;
                    GenerateReportDialog.this.rootElements = null;
                    GenerateReportDialog.this.setupComboScopes(ReportTemplateMetaData.ReportContext.UNSPECIFIED);
                    GenerateReportDialog.this.reportSelector.resetFilters();
                    GenerateReportDialog.this.reportSelector.setSelectedElements(new Object[0]);
                    GenerateReportDialog.this.comboOutputFormat.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            });
        }
        Label reportGroupLabel = new Label((Composite)reportGroup, 258);
        reportGroupLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        Label useDateLabel = new Label((Composite)reportGroup, 0);
        useDateLabel.setText(Messages.GenerateReportDialog_33);
        Button useDateCheckbox = new Button((Composite)reportGroup, 32);
        useDateCheckbox.setSelection(true);
        GridData useDateCheckboxGridData = new GridData();
        useDateCheckboxGridData.horizontalSpan = 2;
        useDateCheckboxGridData.grabExcessHorizontalSpace = true;
        useDateCheckboxGridData.horizontalAlignment = 16384;
        useDateCheckbox.setLayoutData((Object)useDateCheckboxGridData);
        useDateCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateReportDialog.this.useDate = ((Button)e.getSource()).getSelection();
            }
        });
        Group groupCache = new Group(composite, 0);
        groupCache.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        layout = new GridLayout();
        groupCache.setLayout((Layout)layout);
        this.createCacheResetButton((Control)groupCache);
        if (this.reportTemplates.length == 0) {
            this.showNoReportsExistant();
        }
        this.setupComboOutputFormatContent();
        this.setupComboScopes();
        composite.pack();
        return composite;
    }

    private Group createGroup(Composite composite) {
        Group reportGroup = new Group(composite, 0);
        reportGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        reportGroup.setLayout((Layout)layout);
        return reportGroup;
    }

    private String selectOutputFile() {
        FileDialog dlg = new FileDialog(this.getParentShell(), 8192);
        ArrayList<String> extensionList = new ArrayList<String>();
        if (this.chosenOutputFormat != null && this.chosenOutputFormat.getFileSuffix() != null) {
            extensionList.add("*." + this.chosenOutputFormat.getFileSuffix());
        }
        extensionList.add("*.*");
        dlg.setFilterExtensions(extensionList.toArray(new String[extensionList.size()]));
        dlg.setFileName(this.getDefaultOutputFilename(this.chosenReportsMetaData.get(0)));
        dlg.setOverwrite(true);
        String path = this.defaultFolder;
        dlg.setFilterPath(path);
        return dlg.open();
    }

    private void setupComboScopes() {
        this.setupComboScopes(ReportTemplateMetaData.ReportContext.UNSPECIFIED);
    }

    private void setupComboScopes(ReportTemplateMetaData.ReportContext context) {
        boolean reportsSupportMultipleRootObjects;
        if (this.auditId != null && this.isContextMenuCall()) {
            this.scopeCombo.removeAll();
            this.scopeCombo.add(this.auditName);
            this.rootElement = this.auditId;
            this.scopeCombo.setEnabled(false);
            this.scopeCombo.select(0);
            this.onlyShowSuitableReports(this.selectedScope);
            this.scopeCombo.redraw();
            return;
        }
        if (this.preSelectedElments != null && !this.preSelectedElments.isEmpty() && this.isContextMenuCall()) {
            this.scopeCombo.removeAll();
            ArrayList<Integer> auditIDList = new ArrayList<Integer>();
            StringBuilder sb = new StringBuilder();
            for (CnATreeElement elmt : this.preSelectedElments) {
                sb.append(elmt.getTitle());
                if (this.preSelectedElments.indexOf(elmt) != this.preSelectedElments.size() - 1) {
                    sb.append(" & ");
                }
                auditIDList.add(elmt.getDbId());
            }
            this.scopeCombo.add(sb.toString());
            this.rootElements = auditIDList.toArray(new Integer[auditIDList.size()]);
            this.scopeCombo.setEnabled(false);
            this.scopeCombo.select(0);
            this.scopeCombo.redraw();
            this.onlyShowSuitableReports(this.preSelectedElments.get(0));
            return;
        }
        this.loadScopes(context);
        ArrayList<String> scopeTitles = new ArrayList<String>();
        Collections.sort(this.scopes, (o1, o2) -> o1.getTitle().compareToIgnoreCase(o2.getTitle()));
        for (CnATreeElement elmt : this.scopes) {
            scopeTitles.add(elmt.getTitle());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)(String.valueOf(Messages.GenerateReportDialog_16) + elmt.getDbId() + ": " + elmt.getTitle()));
        }
        boolean bl = reportsSupportMultipleRootObjects = !this.chosenReportsMetaData.isEmpty() && this.chosenReportsMetaData.stream().allMatch(ReportTemplateMetaData::isMultipleRootObjects);
        if (reportsSupportMultipleRootObjects) {
            scopeTitles.add(0, Messages.GenerateReportDialog_37);
        }
        String[] titles = scopeTitles.toArray(new String[scopeTitles.size()]);
        this.scopeCombo.setItems(titles);
        if (this.rootElement != null) {
            boolean elementFound = false;
            int i = 0;
            while (i < this.scopes.size()) {
                if (this.scopes.get(i).getDbId().equals(this.rootElement)) {
                    this.scopeCombo.select(reportsSupportMultipleRootObjects ? i + 1 : i);
                    elementFound = true;
                    break;
                }
                ++i;
            }
            if (!elementFound) {
                this.scopeCombo.clearSelection();
            }
        } else if (this.rootElements != null) {
            if (reportsSupportMultipleRootObjects) {
                this.scopeCombo.select(0);
            } else {
                this.scopeCombo.clearSelection();
            }
        }
    }

    private void setupComboOutputFormatContent() {
        this.setErrorMessage(null);
        if (this.reportTemplates.length > 0) {
            if (!this.chosenReportsMetaData.isEmpty()) {
                List<Set> formatNames = this.chosenReportsMetaData.stream().map(r -> Stream.of(r.getOutputFormats()).map(arg_0 -> ((IReportDepositService)this.getDepositService()).getOutputFormat(arg_0)).map(IOutputFormat::getId).collect(Collectors.toSet())).collect(Collectors.toList());
                Set allNames = formatNames.stream().flatMap(Collection::stream).collect(Collectors.toSet());
                formatNames.forEach(allNames::retainAll);
                List availableFormats = Stream.of(this.chosenReportsMetaData.get(0).getOutputFormats()).filter(t -> allNames.contains(t.name().toLowerCase())).map(arg_0 -> ((IReportDepositService)this.getDepositService()).getOutputFormat(arg_0)).collect(Collectors.toList());
                this.comboOutputFormat.setInput(availableFormats);
                if (!availableFormats.isEmpty()) {
                    this.comboOutputFormat.setSelection((ISelection)new StructuredSelection(availableFormats.get(0)));
                } else {
                    this.setErrorMessage(Messages.GenerateReportDialog_no_common_format);
                }
            } else {
                this.comboOutputFormat.setInput(Collections.emptyList());
            }
        } else {
            this.showNoReportsExistant();
        }
    }

    public String getDefaultOutputFilename(ReportTemplateMetaData chosenReportMetaData) {
        String outputFileName = chosenReportMetaData.getOutputname();
        if (outputFileName == null || outputFileName.isEmpty()) {
            outputFileName = "unknown";
        }
        StringBuilder sb = new StringBuilder(outputFileName);
        String localScopeName = StringUtil.convertToFileName((String)((String)this.scopeName.doGetValue()));
        if (localScopeName != null && !localScopeName.isEmpty()) {
            sb.append("_").append(localScopeName);
        }
        if (this.useDate) {
            String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            sb.append("_").append(date);
        }
        if (this.chosenOutputFormat != null) {
            sb.append(".").append(this.chosenOutputFormat.getFileSuffix());
        } else {
            sb.append(".pdf");
        }
        return StringUtil.convertToFileName((String)sb.toString());
    }

    protected void okPressed() {
        try {
            if (this.scopeCombo.getSelectionIndex() < 0) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.GenerateReportDialog_5, (String)Messages.GenerateReportDialog_6);
                return;
            }
            if (this.chosenReportsMetaData.isEmpty()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.GenerateReportDialog_5, (String)Messages.GenerateReportDialog_no_report_selected);
                return;
            }
            if (this.getErrorMessage() != null) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.GenerateReportDialog_5, (String)this.getErrorMessage());
                return;
            }
            List<Integer> scopeIds = this.collectScopeIds();
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            boolean dontShowValidationWarning = preferenceStore.getBoolean("show_report_validation_warning");
            boolean validationsExistant = this.validateScopes(scopeIds);
            if (!dontShowValidationWarning && validationsExistant) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getParentShell(), (String)Messages.GenerateReportDialog_5, (String)Messages.GenerateReportDialog_21, (String)Messages.GenerateReportDialog_23, (boolean)dontShowValidationWarning, (IPreferenceStore)preferenceStore, (String)"show_report_validation_warning");
                preferenceStore.setValue("show_report_validation_warning", dialog.getToggleState());
                if (dialog.getReturnCode() != 0 && dialog.getReturnCode() != 2) {
                    return;
                }
            }
            if (this.chosenReportsMetaData.size() == 1) {
                String f = this.selectOutputFile();
                if (f != null) {
                    this.outputFile = new File(f);
                    super.okPressed();
                }
            } else if (this.selectOutputDirectory()) {
                super.okPressed();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating report.", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"An error occurred while creating report.");
        }
    }

    private boolean selectOutputDirectory() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setText(Messages.GenerateReportDialog_select_directory_title);
        directoryDialog.setMessage(Messages.GenerateReportDialog_select_directory_message);
        String dir = directoryDialog.open();
        if (dir != null) {
            this.outputFile = new File(dir);
            Set listFiles = Arrays.asList(this.outputFile.listFiles()).stream().map(File::getName).collect(Collectors.toSet());
            if (this.chosenReportsMetaData.stream().anyMatch(rtmd -> listFiles.contains(this.getDefaultOutputFilename((ReportTemplateMetaData)rtmd))) && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.GenerateReportDialog_select_directory_file_exist_title, (String)Messages.GenerateReportDialog_select_directory_file_exist_message)) {
                return this.selectOutputDirectory();
            }
            return true;
        }
        return false;
    }

    private List<Integer> collectScopeIds() {
        ArrayList<Integer> scopeIds = new ArrayList<Integer>();
        if (this.getRootElement() != null) {
            scopeIds.add(this.getRootElement());
        }
        if (this.getRootElements() != null) {
            Integer[] integerArray = this.getRootElements();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer scopeId = integerArray[n2];
                if (scopeId != null) {
                    scopeIds.add(scopeId);
                }
                ++n2;
            }
        }
        return scopeIds;
    }

    private boolean validateScopes(List<Integer> scopeIds) {
        IValidationService vService = ServiceFactory.lookupValidationService();
        for (Integer scopeId : scopeIds) {
            if (vService.getValidations(scopeId, null).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getClassificationHint() {
        return (String)this.classificationHint.doGetValue();
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public IOutputFormat getOutputFormat() {
        return this.chosenOutputFormat;
    }

    @Deprecated
    public IReportType getReportType() {
        return this.chosenReportType;
    }

    public List<ReportTemplateMetaData> getChosenReportsMetaData() {
        return this.chosenReportsMetaData;
    }

    public Integer getRootElement() {
        return this.rootElement;
    }

    public Integer[] getRootElements() {
        return this.rootElements != null ? (Integer[])this.rootElements.clone() : null;
    }

    private List<Organization> loadOrganizations() {
        LoadCnATreeElementTitles compoundLoader = new LoadCnATreeElementTitles(Organization.class);
        try {
            compoundLoader = (LoadCnATreeElementTitles)ServiceFactory.lookupCommandService().executeCommand((ICommand)compoundLoader);
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.GenerateReportDialog_19);
        }
        return compoundLoader.getElements();
    }

    private List<ItNetwork> loadItNetworks() {
        LoadCnAElementByType compoundLoader = new LoadCnAElementByType(ItNetwork.class);
        try {
            compoundLoader = (LoadCnAElementByType)ServiceFactory.lookupCommandService().executeCommand((ICommand)compoundLoader);
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.GenerateReportDialog_38);
        }
        return compoundLoader.getElements().stream().filter(x -> !"catalog_model".equals(x.getParent().getTypeId())).collect(Collectors.toList());
    }

    private List<ITVerbund> loadITVerbuende() {
        LoadCnATreeElementTitles compoundLoader = new LoadCnATreeElementTitles(ITVerbund.class);
        try {
            compoundLoader = (LoadCnATreeElementTitles)ServiceFactory.lookupCommandService().executeCommand((ICommand)compoundLoader);
        }
        catch (Exception e) {
            ExceptionUtil.log(e, Messages.GenerateReportDialog_20);
        }
        return compoundLoader.getElements();
    }

    private void filterReportTypes() {
        ArrayList<ReportTemplateMetaData> list = new ArrayList<ReportTemplateMetaData>();
        if (this.useCase != null && !this.useCase.equals("") && this.reportTemplates.length > 0) {
            ReportTemplateMetaData[] reportTemplateMetaDataArray = this.reportTemplates;
            int n = this.reportTemplates.length;
            int n2 = 0;
            while (n2 < n) {
                ReportTemplateMetaData data = reportTemplateMetaDataArray[n2];
                list.add(data);
                ++n2;
            }
        }
        this.reportTemplates = list.toArray(new ReportTemplateMetaData[list.size()]);
    }

    private boolean isContextMenuCall() {
        return this.isContextMenuCall;
    }

    public void setContextMenuCall(boolean isContextMenuCall) {
        this.isContextMenuCall = isContextMenuCall;
    }

    private String initDefaultFolder() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        this.defaultFolder = prefs.getString("default_folder_report");
        if (this.defaultFolder == null || this.defaultFolder.isEmpty()) {
            this.defaultFolder = System.getProperty("user.home");
        }
        if (!this.defaultFolder.endsWith(System.getProperty("file.separator"))) {
            this.defaultFolder = String.valueOf(this.defaultFolder) + System.getProperty("file.separator");
        }
        return this.defaultFolder;
    }

    private void createCacheResetButton(Control parent) {
        Button button = new Button((Composite)parent, 8);
        button.setText(Messages.GenerateReportDialog_27);
        button.setLayoutData((Object)new GridData(3, 1, true, true));
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openConfirm((Shell)GenerateReportDialog.this.getShell(), (String)Messages.GenerateReportDialog_28, (String)Messages.GenerateReportDialog_29)) {
                    ICommandCacheClient commandCacheClient = (ICommandCacheClient)VeriniceContext.get((String)"commandCacheClient");
                    commandCacheClient.resetCache();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private IReportSupplier getSupplier() {
        if (this.supplier == null) {
            this.supplier = new ReportSupplierImpl();
        }
        return this.supplier;
    }

    private IReportDepositService getDepositService() {
        return ServiceFactory.lookupReportDepositService();
    }

    private void showNoReportsExistant() {
        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.GenerateReportDialog_28, (String)Messages.ReportDepositView_24);
    }

    private void selectScope() {
        int s = this.scopeCombo.getSelectionIndex();
        if (!this.chosenReportsMetaData.isEmpty() && this.chosenReportsMetaData.stream().allMatch(ReportTemplateMetaData::isMultipleRootObjects)) {
            if (s == 0) {
                Integer[] roots = new Integer[this.scopes.size()];
                int i = 0;
                while (i < this.scopes.size()) {
                    roots[i] = this.scopes.get(i).getDbId();
                    ++i;
                }
                this.rootElements = roots;
                this.rootElement = null;
            } else {
                this.rootElement = this.scopes.get(s - 1).getDbId();
            }
        } else {
            this.rootElement = this.scopes.get(s).getDbId();
        }
        this.onlyShowSuitableReports(this.getSelectedScopeElement());
    }

    private CnATreeElement getSelectedScopeElement() {
        return this.scopes.stream().filter(x -> x.getTitle().equals(this.scopeCombo.getText())).findFirst().orElse(null);
    }

    private void onlyShowSuitableReports(CnATreeElement element) {
        if (element == null) {
            return;
        }
        final List validDomains = ReportTemplateMetaData.ReportContext.getValidContexts((CnATreeElement)element);
        this.reportSelector.setFilters(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                ReportTemplateMetaData.ReportContext context = ((ReportTemplateMetaData)element).getContext();
                return validDomains.contains(context);
            }
        });
        if (this.chosenReportsMetaData.stream().noneMatch(t -> validDomains.contains(t.getContext()))) {
            this.reportSelector.setSelectedElements(new Object[0]);
        }
    }

    private void loadScopes(ReportTemplateMetaData.ReportContext context) {
        this.scopes.clear();
        switch (context) {
            case ISM_ISO: 
            case ISM_ISA: 
            case ISM_DS: {
                this.scopes.addAll(this.loadOrganizations());
                break;
            }
            case ITGS: 
            case ITGS_DS: {
                this.scopes.addAll(this.loadItNetworks());
                break;
            }
            case ITGS_ALT: {
                this.scopes.addAll(this.loadITVerbuende());
                break;
            }
            default: {
                this.scopes.addAll(this.loadOrganizations());
                this.scopes.addAll(this.loadItNetworks());
                this.scopes.addAll(this.loadITVerbuende());
            }
        }
    }
}

