/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.rcp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sernet.gs.service.RuntimeCommandException;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.IReportDepositService;
import sernet.verinice.interfaces.IReportTemplateService;
import sernet.verinice.interfaces.ReportDepositException;
import sernet.verinice.interfaces.ReportTemplateServiceException;
import sernet.verinice.model.report.FileMetaData;
import sernet.verinice.model.report.ReportTemplateMetaData;
import sernet.verinice.report.rcp.Messages;

public class AddReportToDepositDialog
extends TitleAreaDialog {
    private static final String ERROR_MESSAGE_PREFIX = "\n \u2022 ";
    private static final Logger LOG = Logger.getLogger(AddReportToDepositDialog.class);
    private Text reportName;
    private Combo reportContextCombo;
    private Button outputTypePDFCheckbox;
    private Button outputTypeHTMLCheckbox;
    private Button outputTypeWordCheckbox;
    private Button outputTypeODTCheckbox;
    private Button outputTypeODSCheckbox;
    private Button outputTypeExcelCheckbox;
    private Text reportTemplateText;
    private static final int SIZE_X = 150;
    private static final int SIZE_Y = 500;
    static final int MARGIN_WIDTH = 10;
    static final int DEFAULT_COL_NR = 3;
    private ReportTemplateMetaData editTemplate;
    private Button allowMultipleRootObjects;
    private boolean reportTemplateFilenameChanged = false;
    private Map<String, ReportTemplateMetaData> templateNames = Collections.emptyMap();
    private Button outputTypeDocxCheckbox;
    private Button outputTypeXLSXCheckbox;

    public AddReportToDepositDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public AddReportToDepositDialog(Shell parentShell, ReportTemplateMetaData metadata) {
        this(parentShell);
        this.editTemplate = metadata;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.isEditMode() ? Messages.ReportDepositView_17 : Messages.ReportDepositView_5);
        Point cursorLocation = Display.getCurrent().getCursorLocation();
        newShell.setLocation(new Point(cursorLocation.x - 75, cursorLocation.y - 250));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
        this.getButton(0).setText(Messages.ReportDepositView_9);
        this.getButton(1).setText(Messages.ReportDepositView_10);
    }

    protected Control createDialogArea(Composite parent) {
        try {
            this.templateNames = this.getReportService().getReportTemplates(Locale.getDefault()).stream().collect(Collectors.toMap(ReportTemplateMetaData::getFilename, Function.identity()));
        }
        catch (ReportTemplateServiceException e) {
            throw new RuntimeCommandException("report service not avalable");
        }
        this.setTitle(this.isEditMode() ? Messages.ReportDepositView_17 : Messages.ReportDepositView_5);
        this.setMessage(this.isEditMode() ? Messages.ReportDepositView_18 : Messages.ReportDepositView_7);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite dialogContent = new Composite(composite, 0);
        GridLayout threeColumnLayout = new GridLayout(3, false);
        dialogContent.setLayout((Layout)threeColumnLayout);
        dialogContent.setLayoutData((Object)new GridData(4, 4, true, true));
        Label reportNameLabel = new Label(dialogContent, 0);
        reportNameLabel.setText(Messages.ReportDepositView_1);
        GridData reportNameLabelGd = new GridData();
        reportNameLabelGd.horizontalAlignment = 4;
        reportNameLabelGd.verticalAlignment = 0x1000000;
        reportNameLabelGd.grabExcessHorizontalSpace = false;
        reportNameLabelGd.horizontalSpan = 1;
        reportNameLabel.setLayoutData((Object)reportNameLabelGd);
        this.reportName = new Text(dialogContent, 2048);
        GridData reportNameTextGd = new GridData();
        reportNameTextGd.horizontalAlignment = 4;
        reportNameTextGd.verticalAlignment = 128;
        reportNameTextGd.grabExcessHorizontalSpace = true;
        reportNameTextGd.horizontalSpan = 2;
        this.reportName.setLayoutData((Object)reportNameTextGd);
        this.reportName.addListener(2, event -> this.updateDialog());
        SelectionAdapter updateDialogListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddReportToDepositDialog.this.updateDialog();
            }
        };
        Label reportContextLabel = new Label(dialogContent, 0);
        reportContextLabel.setText(Messages.ReportMetaDataContext);
        GridData reportContextLabelGd = new GridData();
        reportContextLabelGd.horizontalAlignment = 4;
        reportContextLabelGd.verticalAlignment = 0x1000000;
        reportContextLabelGd.grabExcessHorizontalSpace = false;
        reportContextLabelGd.horizontalSpan = 1;
        reportContextLabel.setLayoutData((Object)reportNameLabelGd);
        this.reportContextCombo = new Combo(dialogContent, 12);
        this.reportContextCombo.setItems(Arrays.stream(ReportTemplateMetaData.ReportContext.values()).map(ReportTemplateMetaData.ReportContext::prettyString).collect(Collectors.toList()).toArray(new String[ReportTemplateMetaData.ReportContext.values().length]));
        GridData reportContextGd = new GridData();
        reportContextGd.horizontalAlignment = 4;
        reportContextGd.verticalAlignment = 128;
        reportContextGd.grabExcessHorizontalSpace = true;
        reportContextGd.horizontalSpan = 2;
        this.reportContextCombo.setLayoutData((Object)reportContextGd);
        this.reportContextCombo.addSelectionListener((SelectionListener)updateDialogListener);
        this.allowMultipleRootObjects = new Button(dialogContent, 32);
        this.allowMultipleRootObjects.setText(Messages.ReportDepositView_25);
        GridData allowMultipleRootObjectsGd = new GridData();
        allowMultipleRootObjectsGd.horizontalAlignment = 4;
        allowMultipleRootObjectsGd.grabExcessHorizontalSpace = false;
        allowMultipleRootObjectsGd.horizontalSpan = 3;
        this.allowMultipleRootObjects.setLayoutData((Object)allowMultipleRootObjectsGd);
        this.allowMultipleRootObjects.addSelectionListener((SelectionListener)updateDialogListener);
        Composite checkboxComposite = new Composite(dialogContent, 0);
        GridLayout formatLayout = new GridLayout(3, false);
        checkboxComposite.setLayout((Layout)formatLayout);
        checkboxComposite.setLayoutData((Object)new GridData(16384, 128, true, false, 3, 1));
        GridData ofgd = new GridData();
        ofgd.horizontalAlignment = 16384;
        ofgd.verticalAlignment = 128;
        ofgd.grabExcessHorizontalSpace = true;
        ofgd.horizontalSpan = 3;
        GridData gdRadio = new GridData();
        gdRadio.grabExcessHorizontalSpace = true;
        gdRadio.horizontalSpan = 1;
        Group outputFormatGroup = new Group(dialogContent, 0);
        outputFormatGroup.setText(Messages.ReportDepositView_2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        outputFormatGroup.setLayout((Layout)gridLayout);
        GridData oflData = new GridData();
        oflData.horizontalSpan = 3;
        oflData.grabExcessHorizontalSpace = true;
        outputFormatGroup.setLayoutData((Object)oflData);
        this.outputTypePDFCheckbox = new Button((Composite)outputFormatGroup, 32);
        this.outputTypePDFCheckbox.setText(IReportTemplateService.OutputFormat.PDF.toString());
        this.outputTypePDFCheckbox.addSelectionListener((SelectionListener)updateDialogListener);
        this.outputTypeHTMLCheckbox = new Button((Composite)outputFormatGroup, 32);
        this.outputTypeHTMLCheckbox.setText(IReportTemplateService.OutputFormat.HTML.toString());
        this.outputTypeHTMLCheckbox.addSelectionListener((SelectionListener)updateDialogListener);
        this.outputTypeODTCheckbox = new Button((Composite)outputFormatGroup, 32);
        this.outputTypeODTCheckbox.setText(IReportTemplateService.OutputFormat.ODT.toString());
        this.outputTypeODTCheckbox.addSelectionListener((SelectionListener)updateDialogListener);
        this.outputTypeODSCheckbox = new Button((Composite)outputFormatGroup, 32);
        this.outputTypeODSCheckbox.setText(IReportTemplateService.OutputFormat.ODS.toString());
        this.outputTypeODSCheckbox.addSelectionListener((SelectionListener)updateDialogListener);
        this.outputTypeDocxCheckbox = new Button((Composite)outputFormatGroup, 32);
        this.outputTypeDocxCheckbox.setText(IReportTemplateService.OutputFormat.DOCX.toString());
        this.outputTypeDocxCheckbox.addSelectionListener((SelectionListener)updateDialogListener);
        this.outputTypeXLSXCheckbox = new Button((Composite)outputFormatGroup, 32);
        this.outputTypeXLSXCheckbox.setText(IReportTemplateService.OutputFormat.XLSX.toString());
        this.outputTypeXLSXCheckbox.addSelectionListener((SelectionListener)updateDialogListener);
        this.outputTypeWordCheckbox = new Button((Composite)outputFormatGroup, 32);
        this.outputTypeWordCheckbox.setText(IReportTemplateService.OutputFormat.DOC.toString());
        this.outputTypeWordCheckbox.addSelectionListener((SelectionListener)updateDialogListener);
        this.outputTypeExcelCheckbox = new Button((Composite)outputFormatGroup, 32);
        this.outputTypeExcelCheckbox.setText(IReportTemplateService.OutputFormat.XLS.toString());
        this.outputTypeExcelCheckbox.addSelectionListener((SelectionListener)updateDialogListener);
        Label templateLabel = new Label(dialogContent, 0);
        templateLabel.setText(Messages.ReportDepositView_3);
        templateLabel.setLayoutData((Object)reportNameLabelGd);
        this.reportTemplateText = new Text(dialogContent, 2048);
        this.reportTemplateText.setEditable(false);
        GridData reportTemplateTextGd = new GridData();
        reportTemplateTextGd.horizontalAlignment = 4;
        reportTemplateTextGd.verticalAlignment = 0x1000000;
        reportTemplateTextGd.grabExcessHorizontalSpace = true;
        reportTemplateTextGd.horizontalSpan = 1;
        this.reportTemplateText.setLayoutData((Object)reportTemplateTextGd);
        Button reportTemplateSelectButton = new Button(dialogContent, 8);
        GridData selectButtonGd = new GridData();
        gdRadio.horizontalAlignment = 131072;
        gdRadio.verticalAlignment = 128;
        gdRadio.grabExcessHorizontalSpace = false;
        gdRadio.horizontalSpan = 1;
        reportTemplateSelectButton.setLayoutData((Object)selectButtonGd);
        reportTemplateSelectButton.setText(Messages.ReportDepositView_8);
        reportTemplateSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddReportToDepositDialog.this.selectTemplateFile();
                AddReportToDepositDialog.this.reportTemplateFilenameChanged = AddReportToDepositDialog.this.editTemplate == null || !AddReportToDepositDialog.this.editTemplate.getFilename().equals(AddReportToDepositDialog.this.getSelectedDesignFileName());
                AddReportToDepositDialog.this.updateDialog();
            }
        });
        if (this.isEditMode()) {
            this.prepareEditMode();
        }
        return composite;
    }

    private void prepareEditMode() {
        this.reportName.setText(this.editTemplate.getOutputname());
        this.outputTypePDFCheckbox = this.checkboxEditMode(this.outputTypePDFCheckbox, IReportTemplateService.OutputFormat.PDF);
        this.outputTypeHTMLCheckbox = this.checkboxEditMode(this.outputTypeHTMLCheckbox, IReportTemplateService.OutputFormat.HTML);
        this.outputTypeWordCheckbox = this.checkboxEditMode(this.outputTypeWordCheckbox, IReportTemplateService.OutputFormat.DOC);
        this.outputTypeODTCheckbox = this.checkboxEditMode(this.outputTypeODTCheckbox, IReportTemplateService.OutputFormat.ODT);
        this.outputTypeODSCheckbox = this.checkboxEditMode(this.outputTypeODSCheckbox, IReportTemplateService.OutputFormat.ODS);
        this.outputTypeExcelCheckbox = this.checkboxEditMode(this.outputTypeExcelCheckbox, IReportTemplateService.OutputFormat.XLS);
        this.outputTypeDocxCheckbox = this.checkboxEditMode(this.outputTypeDocxCheckbox, IReportTemplateService.OutputFormat.DOCX);
        this.outputTypeXLSXCheckbox = this.checkboxEditMode(this.outputTypeXLSXCheckbox, IReportTemplateService.OutputFormat.XLSX);
        this.reportTemplateText.setText(this.editTemplate.getFilename());
        this.allowMultipleRootObjects.setSelection(this.editTemplate.isMultipleRootObjects());
        this.reportContextCombo.setText(this.editTemplate.getContext().prettyString());
    }

    private Button checkboxEditMode(Button checkbox, IReportTemplateService.OutputFormat format) {
        checkbox.setSelection(this.isOutputFormatPreSelected(format));
        return checkbox;
    }

    protected void okPressed() {
        if (this.isEditMode()) {
            this.updateTemplate();
        } else {
            this.addTemplate();
        }
        super.okPressed();
    }

    private void updateTemplate() {
        try {
            FileMetaData fileMetaData = new FileMetaData(this.getSelectedDesignFileName(), null);
            ReportTemplateMetaData newMetaData = new ReportTemplateMetaData(fileMetaData, this.getReportOutputName(), this.getReportOutputFormats(), true, this.allowMultipleRootObjects.getSelection(), this.getContext());
            if (this.reportTemplateFilenameChanged) {
                byte[] rptDesignFile = FileUtils.readFileToByteArray((File)new File(this.getSelectedDesginFile()));
                this.getReportService().update(this.editTemplate, rptDesignFile, newMetaData, Locale.getDefault());
            } else {
                this.getReportService().update(newMetaData, Locale.getDefault());
            }
        }
        catch (ReportDepositException e) {
            LOG.error((Object)"Error while updating report template file", (Throwable)e);
            ExceptionUtil.log(e, Messages.ReportDepositView_23);
        }
        catch (IOException e) {
            LOG.error((Object)"Error while accessing the template file", (Throwable)e);
            ExceptionUtil.log(e, Messages.AddReportToDepositDialog_0);
        }
    }

    private void addTemplate() {
        try {
            byte[] rptDesignFile = FileUtils.readFileToByteArray((File)new File(this.getSelectedDesginFile()));
            FileMetaData fileMetaData = new FileMetaData(this.getSelectedDesignFileName(), null);
            ReportTemplateMetaData metaData = new ReportTemplateMetaData(fileMetaData, this.getReportOutputName(), this.getReportOutputFormats(), true, this.allowMultipleRootObjects.getSelection(), this.getContext());
            this.getReportService().add(metaData, rptDesignFile, Locale.getDefault());
        }
        catch (ReportDepositException e) {
            LOG.error((Object)"Error while adding new report template file", (Throwable)e);
            ExceptionUtil.log(e, Messages.AddReportToDepositDialog_3);
        }
        catch (IOException e) {
            LOG.error((Object)"Error while accessing the template file", (Throwable)e);
            ExceptionUtil.log(e, Messages.AddReportToDepositDialog_0);
        }
    }

    public void selectTemplateFile() {
        FileDialog dlg = new FileDialog(this.getParentShell(), 2);
        String defaultTemplatePath = Activator.getDefault().getPreferenceStore().getString("default_template_folder_report");
        if (defaultTemplatePath != null && !defaultTemplatePath.isEmpty()) {
            dlg.setFilterPath(defaultTemplatePath);
        }
        ArrayList<String> extensionList = new ArrayList<String>();
        extensionList.add("*.rptdesign");
        extensionList.add("*.*");
        dlg.setFilterExtensions(extensionList.toArray(new String[extensionList.size()]));
        String fn = dlg.open();
        if (fn != null) {
            this.reportTemplateText.setText(fn);
            if (this.reportName.getText() == null || this.reportName.getText().isEmpty()) {
                this.reportName.setText(StringUtils.capitalize((String)FilenameUtils.getBaseName((String)fn)));
            }
        }
    }

    private String getSelectedDesginFile() {
        return this.reportTemplateText.getText();
    }

    private String getSelectedDesignFileName() {
        return FilenameUtils.getName((String)this.getSelectedDesginFile());
    }

    private String getReportOutputName() {
        return this.reportName.getText();
    }

    private ReportTemplateMetaData.ReportContext getContext() {
        return ReportTemplateMetaData.ReportContext.fromString((String)this.reportContextCombo.getText());
    }

    private IReportTemplateService.OutputFormat[] getReportOutputFormats() {
        ArrayList<IReportTemplateService.OutputFormat> list = new ArrayList<IReportTemplateService.OutputFormat>(0);
        if (this.outputTypeExcelCheckbox.getSelection()) {
            list.add(IReportTemplateService.OutputFormat.XLS);
        }
        if (this.outputTypeHTMLCheckbox.getSelection()) {
            list.add(IReportTemplateService.OutputFormat.HTML);
        }
        if (this.outputTypeWordCheckbox.getSelection()) {
            list.add(IReportTemplateService.OutputFormat.DOC);
        }
        if (this.outputTypePDFCheckbox.getSelection()) {
            list.add(IReportTemplateService.OutputFormat.PDF);
        }
        if (this.outputTypeODTCheckbox.getSelection()) {
            list.add(IReportTemplateService.OutputFormat.ODT);
        }
        if (this.outputTypeODSCheckbox.getSelection()) {
            list.add(IReportTemplateService.OutputFormat.ODS);
        }
        if (this.outputTypeDocxCheckbox.getSelection()) {
            list.add(IReportTemplateService.OutputFormat.DOCX);
        }
        if (this.outputTypeXLSXCheckbox.getSelection()) {
            list.add(IReportTemplateService.OutputFormat.XLSX);
        }
        return list.toArray(new IReportTemplateService.OutputFormat[list.size()]);
    }

    private boolean isAnyFormatSelected() {
        return this.outputTypeExcelCheckbox.getSelection() || this.outputTypeHTMLCheckbox.getSelection() || this.outputTypeODSCheckbox.getSelection() || this.outputTypeODTCheckbox.getSelection() || this.outputTypePDFCheckbox.getSelection() || this.outputTypeWordCheckbox.getSelection();
    }

    private boolean isEditMode() {
        return this.editTemplate != null;
    }

    private boolean isOutputFormatPreSelected(IReportTemplateService.OutputFormat format) {
        return Arrays.asList(this.editTemplate.getOutputFormats()).contains(format);
    }

    private IReportDepositService getReportService() {
        return ServiceFactory.lookupReportDepositService();
    }

    private void updateDialog() {
        String errorMessage = this.buildErrorMessage();
        this.setErrorMessage(errorMessage);
        this.getButton(0).setEnabled(errorMessage == null);
    }

    private String buildErrorMessage() {
        if (!this.templateExistRemote()) {
            ReportTemplateMetaData reportTemplateMetaData = this.templateNames.get(this.getSelectedDesignFileName());
            return String.format(Messages.AddReportToDepositDialog_1, reportTemplateMetaData.getFilename());
        }
        StringBuilder message = new StringBuilder();
        if (StringUtils.isEmpty((String)this.getSelectedDesginFile())) {
            message.append(ERROR_MESSAGE_PREFIX);
            message.append(Messages.AddReportToDepositDialog_5);
        }
        if (StringUtils.isEmpty((String)this.getReportOutputName())) {
            message.append(ERROR_MESSAGE_PREFIX);
            message.append(Messages.AddReportToDepositDialog_6);
        }
        if (this.reportContextCombo.getSelectionIndex() == -1) {
            message.append(ERROR_MESSAGE_PREFIX);
            message.append(Messages.AddReportToDepositDialog_7);
        }
        if (!this.isAnyFormatSelected()) {
            message.append(ERROR_MESSAGE_PREFIX);
            message.append(Messages.AddReportToDepositDialog_4);
        }
        if (message.length() == 0) {
            return null;
        }
        return String.valueOf(Messages.ReportDepositView_12) + message.toString();
    }

    private boolean templateExistRemote() {
        String selectedDesginFile = this.getSelectedDesignFileName();
        if (this.isEditMode()) {
            return !this.templateNames.keySet().contains(selectedDesginFile) || !this.reportTemplateFilenameChanged;
        }
        return !this.templateNames.keySet().contains(selectedDesginFile);
    }
}

