/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.report.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.interfaces.report.IOutputFormat;
import sernet.verinice.interfaces.report.IReportOptions;
import sernet.verinice.interfaces.report.ReportTypeException;
import sernet.verinice.model.report.ReportTemplateMetaData;
import sernet.verinice.rcp.RightsEnabledActionDelegate;
import sernet.verinice.report.rcp.GenerateReportDialog;
import sernet.verinice.report.rcp.Messages;
import sernet.verinice.ui.DesktopUtil;

public abstract class ReportAction
extends RightsEnabledActionDelegate
implements IWorkbenchWindowActionDelegate,
RightEnabledUserInteraction {
    private static final Logger LOG = Logger.getLogger(ReportAction.class);
    Shell shell;
    protected GenerateReportDialog dialog;
    protected List<?> rootObjects;
    private boolean generationSuccessful = false;
    private boolean isContextMenuCall;

    public void init(IWorkbenchWindow window) {
        try {
            this.shell = window.getShell();
        }
        catch (Exception t) {
            LOG.error((Object)"Error creating dialog", (Throwable)t);
        }
    }

    @Override
    public void doRun(IAction action) {
        try {
            this.openDialog();
            if (this.dialog.open() == 0) {
                final List<ReportTemplateMetaData> chosenReportsMetaData = this.dialog.getChosenReportsMetaData();
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("start report generation", chosenReportsMetaData.size());
                        for (ReportTemplateMetaData reportTemplateMetaData : chosenReportsMetaData) {
                            IReportOptions prepareReportOptions = ReportAction.this.prepareReportOptions(reportTemplateMetaData);
                            String outputname = reportTemplateMetaData.getOutputname();
                            ReportAction.this.runUIBlockingReportGeneration(prepareReportOptions, reportTemplateMetaData, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)outputname, (int)-1));
                            monitor.worked(1);
                        }
                        monitor.done();
                    }
                });
            }
        }
        catch (Exception t) {
            ExceptionUtil.log(t, Messages.GenerateReportDialog_32);
            this.setGenerationSuccessful(Boolean.FALSE);
        }
        this.provideUserFeedback();
    }

    protected void openDialog() {
        if (!this.isContextMenuCall() || this.rootObjects == null || this.rootObjects.isEmpty()) {
            this.dialog = new GenerateReportDialog(this.shell);
        } else if (this.rootObjects.size() == 1 && this.isContextMenuCall()) {
            this.dialog = new GenerateReportDialog(this.shell, this.rootObjects.get(0));
        } else if (this.rootObjects != null && this.rootObjects.size() > 1 && this.isContextMenuCall()) {
            this.dialog = new GenerateReportDialog(this.shell, this.rootObjects, "use_case_report_general");
        }
        this.dialog.setContextMenuCall(this.isContextMenuCall());
    }

    private IReportOptions prepareReportOptions(final ReportTemplateMetaData reportTemplateMetaData) {
        IReportOptions ro = new IReportOptions(){
            Integer rootElmt;
            Integer[] rootElmts;

            public boolean isToBeEncrypted() {
                return false;
            }

            public boolean isToBeCompressed() {
                return false;
            }

            public IOutputFormat getOutputFormat() {
                return ReportAction.this.dialog.getOutputFormat();
            }

            public File getOutputFile() {
                if (ReportAction.this.dialog.getOutputFile().isDirectory()) {
                    return new File(String.valueOf(ReportAction.this.dialog.getOutputFile().getAbsolutePath()) + "/" + ReportAction.this.dialog.getDefaultOutputFilename(reportTemplateMetaData));
                }
                return ReportAction.this.dialog.getOutputFile();
            }

            public void setRootElement(Integer rootElement) {
                this.rootElmt = rootElement;
            }

            public Integer getRootElement() {
                return this.rootElmt;
            }

            public Integer[] getRootElements() {
                return this.rootElmts;
            }

            public void setRootElements(Integer[] rootElements) {
                this.rootElmts = rootElements;
            }

            public String getServerURL() {
                return Activator.getDefault().getPreferenceStore().getString("gs_cna_vnserver_uri");
            }

            public String getClassificationHint() {
                return ReportAction.this.dialog.getClassificationHint();
            }
        };
        if (this.dialog.getRootElement() != null) {
            ro.setRootElement(this.dialog.getRootElement());
        } else if (this.dialog.getRootElements() != null && this.dialog.getRootElements().length > 0) {
            ro.setRootElements(this.dialog.getRootElements());
        }
        return ro;
    }

    private void provideUserFeedback() {
        if (this.isGenerationSuccessful()) {
            Display.getDefault().asyncExec(() -> {
                boolean isMany = this.dialog.getChosenReportsMetaData().size() > 1;
                String path = this.dialog.getOutputFile().getAbsolutePath();
                String reportName = this.dialog.getChosenReportsMetaData().stream().map(ReportTemplateMetaData::getOutputname).collect(Collectors.joining("\n "));
                String[] dialogButtons = new String[]{IDialogConstants.OPEN_LABEL, IDialogConstants.OK_LABEL};
                MessageDialog reportGeneratedDialog = new MessageDialog(Display.getCurrent().getActiveShell(), isMany ? Messages.GenerateReportDialog_30_many : Messages.GenerateReportDialog_30, null, Messages.bind((String)(isMany ? Messages.GenerateReportDialog_31_many : Messages.GenerateReportDialog_31), (Object[])new Object[]{reportName, path}), 2, dialogButtons, 1){

                    protected int getShellStyle() {
                        return super.getShellStyle() | 0x10000000;
                    }
                };
                int result = reportGeneratedDialog.open();
                if (result == 0 && !DesktopUtil.open(new File(path))) {
                    ExceptionUtil.log(new UnsupportedOperationException("Failed to open report"), Messages.ErrorOpeningGenereratedReport);
                }
            });
        }
    }

    private void runUIBlockingReportGeneration(IReportOptions ro, ReportTemplateMetaData reportTemplate, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(Messages.GenerateReportAction_1) + " " + reportTemplate.getOutputname(), -1);
        Activator.inheritVeriniceContextState();
        try {
            try {
                this.dialog.getReportType().createReport(ro);
                this.dialog.getReportType().createReport(reportTemplate);
                this.setGenerationSuccessful(true);
            }
            catch (ReportTypeException exception) {
                if (exception.causedBySecurityException()) {
                    ExceptionUtil.log(exception, Messages.GenerateReportDialog_34);
                } else {
                    ExceptionUtil.log(exception, Messages.GenerateReportDialog_32);
                }
                this.setGenerationSuccessful(false);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public String getRightID() {
        return "generateorgreport";
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            this.rootObjects = treeSelection.toList();
        }
    }

    public boolean isContextMenuCall() {
        return this.isContextMenuCall;
    }

    private boolean isGenerationSuccessful() {
        return this.generationSuccessful;
    }

    private void setGenerationSuccessful(boolean generationSuccessful) {
        this.generationSuccessful = generationSuccessful;
    }
}

