/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.unify;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.unify.Messages;
import sernet.verinice.rcp.unify.UnifyPageMapping;
import sernet.verinice.rcp.unify.UnifyPageSelectGroup;
import sernet.verinice.service.commands.LoadParentTitles;
import sernet.verinice.service.commands.unify.LoadUnifyMapping;
import sernet.verinice.service.commands.unify.Unify;
import sernet.verinice.service.commands.unify.UnifyMapping;
import sernet.verinice.service.commands.unify.UnifyValidationException;

public class UnifyWizard
extends Wizard {
    private static final Logger LOG = Logger.getLogger(UnifyWizard.class);
    public static final String PAGE_SELECT_GROUP_ID = "select-group";
    public static final String PAGE_SELECT_MAPPING_ID = "mapping";
    private List<CnATreeElement> groups;
    private CnATreeElement source;
    private CnATreeElement destination;
    private List<UnifyMapping> mappings;
    private Map<String, String> uuidParentInformationMap;
    private ICommandService commandService;
    private boolean copyLinks = false;
    private boolean deleteSourceLinks = false;
    private boolean dontCopyPropertyValues = false;

    public UnifyWizard(List<CnATreeElement> groups) {
        this.setWindowTitle(Messages.UnifyWizard_1);
        this.setNeedsProgressMonitor(true);
        this.groups = groups;
        try {
            this.loadParentInformation();
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while loading parent information", (Throwable)e);
            this.showError(Messages.UnifyWizard_3);
        }
    }

    public void addPages() {
        UnifyPageSelectGroup pageSelectGroup = new UnifyPageSelectGroup();
        this.addPage((IWizardPage)pageSelectGroup);
        UnifyPageMapping pageMapping = new UnifyPageMapping();
        this.addPage((IWizardPage)pageMapping);
    }

    public boolean performFinish() {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.UnifyWizard_4, -1);
                    Activator.inheritVeriniceContextState();
                    try {
                        UnifyWizard.this.unify();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while unifying elements.", (Throwable)e);
                        UnifyWizard.this.showError(Messages.UnifyWizard_6);
                    }
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)"Error while unifying elements.", (Throwable)e);
            this.showError(Messages.UnifyWizard_6);
        }
        return true;
    }

    private void unify() throws CommandException {
        if (this.mappings == null) {
            this.loadMapping();
        }
        Unify command = new Unify.Builder(this.mappings).copyLinks(this.copyLinks).deleteSourceLinks(this.deleteSourceLinks).dontCopyPropertyValues(this.dontCopyPropertyValues).build();
        command = (Unify)this.getCommandService().executeCommand((ICommand)command);
        this.refresh(command.getChangedElements());
    }

    private void refresh(List<CnATreeElement> changedElements) {
        for (CnATreeElement element : changedElements) {
            element.setParent(null);
            CnAElementFactory.getModel(element).childChanged(element);
        }
    }

    private void loadParentInformation() throws CommandException {
        List<String> uuidList = this.createGroupUuidList();
        LoadParentTitles command = new LoadParentTitles(uuidList);
        command = (LoadParentTitles)this.getCommandService().executeCommand((ICommand)command);
        this.uuidParentInformationMap = command.getParentInformationMap();
    }

    private List<String> createGroupUuidList() {
        ArrayList<String> uuidList = new ArrayList<String>(this.groups.size());
        for (CnATreeElement element : this.groups) {
            uuidList.add(element.getUuid());
        }
        return uuidList;
    }

    public void loadMapping() {
        try {
            this.loadMappingFromServer();
        }
        catch (UnifyValidationException e) {
            LOG.error((Object)"Error while loading unify mapping from server.", (Throwable)e);
            this.showError(e.getMessage());
        }
        catch (CommandException e) {
            this.handleCommandException(e);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading unify mapping from server.", (Throwable)e);
            this.showError(Messages.UnifyWizard_6);
        }
    }

    private void handleCommandException(CommandException e) {
        LOG.error((Object)"Command exception while loading unify mapping from server.", (Throwable)e);
        Throwable cause = e.getCause();
        if (cause instanceof UnifyValidationException) {
            this.showError(cause.getMessage());
        } else {
            this.showError(Messages.UnifyWizard_6);
        }
    }

    private void loadMappingFromServer() throws CommandException {
        LoadUnifyMapping command = new LoadUnifyMapping(this.getSource().getUuid(), this.getDestination().getUuid());
        command = (LoadUnifyMapping)this.getCommandService().executeCommand((ICommand)command);
        this.mappings = command.getMappings();
    }

    private void showError(String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.UnifyWizard_0, (String)message);
    }

    protected List<UnifyMapping> getMappings() {
        return this.mappings;
    }

    protected List<CnATreeElement> getGroups() {
        return this.groups;
    }

    protected Map<String, String> getUuidParentInformationMap() {
        return this.uuidParentInformationMap;
    }

    protected CnATreeElement getSource() {
        return this.source;
    }

    protected CnATreeElement getDestination() {
        return this.destination;
    }

    public boolean isCopyLinks() {
        return this.copyLinks;
    }

    public void setCopyLinks(boolean b) {
        this.copyLinks = b;
    }

    public void setDeleteSourceLinks(boolean b) {
        this.deleteSourceLinks = b;
    }

    public boolean isDeleteSourceLinks() {
        return this.deleteSourceLinks;
    }

    public boolean isDontCopyPropertyValues() {
        return this.dontCopyPropertyValues;
    }

    public void setDontCopyPropertyValues(boolean b) {
        this.dontCopyPropertyValues = b;
    }

    protected void setGroups(List<CnATreeElement> groups) {
        this.groups = groups;
    }

    protected void setSource(CnATreeElement source) {
        this.source = source;
    }

    protected void setDestination(CnATreeElement destination) {
        this.destination = destination;
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }
}

