/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.unify;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.ElementComparator;
import sernet.verinice.rcp.WizardPageEnteringAware;
import sernet.verinice.rcp.unify.Messages;
import sernet.verinice.rcp.unify.UnifyWizard;

public class UnifyPageSelectGroup
extends WizardPageEnteringAware {
    private static final Logger LOG = Logger.getLogger(UnifyPageSelectGroup.class);
    private TableViewer table;
    private static final Comparator<CnATreeElement> COMPARATOR = new ElementComparator(element -> element.getTitle());

    protected UnifyPageSelectGroup() {
        super("select-group");
        this.setTitle(Messages.UnifyPageSelectGroup_0);
    }

    public void createControl(Composite parent) {
        int compCharToConvert = 40;
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.table = this.createTable(composite, Messages.UnifyPageSelectGroup_1);
        this.table.setLabelProvider((IBaseLabelProvider)new ActionLabelProvider());
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table.refresh(true);
        this.table.addSelectionChangedListener(event -> this.selectSourceAndDestination());
        List<CnATreeElement> groupList = this.getUnifyWizard().getGroups();
        Collections.sort(groupList, COMPARATOR);
        this.table.setInput(groupList);
        this.table.getTable().setSelection(0);
        this.setPageComplete(false);
        this.selectSourceAndDestination();
        this.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        return this.getUnifyWizard().getSource() != null && this.getUnifyWizard().getDestination() != null;
    }

    private void selectSourceAndDestination() {
        IStructuredSelection selection = (IStructuredSelection)this.table.getSelection();
        this.getUnifyWizard().setSource((CnATreeElement)selection.getFirstElement());
        for (CnATreeElement element : this.getUnifyWizard().getGroups()) {
            if (element.equals((Object)this.getUnifyWizard().getSource())) continue;
            this.getUnifyWizard().setDestination(element);
            break;
        }
        this.setPageComplete(this.isPageComplete());
    }

    private UnifyWizard getUnifyWizard() {
        return (UnifyWizard)this.getWizard();
    }

    private TableViewer createTable(Composite parent, String title) {
        Label label = new Label(parent, 64);
        label.setText(title);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        int style = 2816;
        TableViewer tableViewer = new TableViewer(parent, style | 2);
        GridData gd = new GridData(4, 4, true, true);
        tableViewer.getControl().setLayoutData((Object)gd);
        tableViewer.setUseHashlookup(true);
        return tableViewer;
    }

    @Override
    protected void pageEntered() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"pageEntered...");
        }
    }

    @Override
    protected void pageLeft() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"pageLeft...");
        }
    }

    class ActionLabelProvider
    extends ColumnLabelProvider {
        ActionLabelProvider() {
        }

        public String getText(Object o) {
            String text = Messages.UnifyPageSelectGroup_4;
            if (o instanceof CnATreeElement) {
                CnATreeElement element = (CnATreeElement)o;
                StringBuilder sb = new StringBuilder();
                sb.append(UnifyPageSelectGroup.this.getUnifyWizard().getUuidParentInformationMap().get(element.getUuid()));
                sb.append(" > ");
                sb.append(element.getTitle());
                text = sb.toString();
            }
            return text;
        }
    }
}

