/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.unify;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import sernet.hui.swt.SWTResourceManager;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.ElementComparator;
import sernet.verinice.rcp.WizardPageEnteringAware;
import sernet.verinice.rcp.unify.Messages;
import sernet.verinice.rcp.unify.UnifyWizard;
import sernet.verinice.service.commands.unify.UnifyElement;
import sernet.verinice.service.commands.unify.UnifyMapping;

public class UnifyPageMapping
extends WizardPageEnteringAware {
    private static final Logger LOG = Logger.getLogger(UnifyPageMapping.class);
    private static final Comparator<UnifyMapping> COMPARATOR = new ElementComparator(mapping -> mapping.getSourceElement().getTitle());
    private TableViewer table;
    private final Color colorDifferentTitle;
    private final Color colorNoMapping;
    private boolean copyLinksEnabled = false;
    private boolean deleteSourceLinksEnabled = false;
    private boolean copyAttributesEnabled = false;

    protected UnifyPageMapping() {
        super("mapping");
        int rgbMax = 255;
        int dtBlue = 170;
        int cnmGreen = 210;
        int cnmBlue = 210;
        this.setTitle(Messages.UnifyPageMapping_0);
        this.colorDifferentTitle = SWTResourceManager.getColor((int)255, (int)255, (int)170);
        this.colorNoMapping = SWTResourceManager.getColor((int)255, (int)210, (int)210);
    }

    public void createControl(Composite parent) {
        int characterAmountToConvert = 40;
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.table = this.createTable(composite);
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table.refresh(true);
        Composite checkboxComposite = new Composite(composite, 16);
        GridData cbcGd = new GridData(4, 4, true, false);
        cbcGd.minimumHeight = 200;
        checkboxComposite.setLayoutData((Object)cbcGd);
        checkboxComposite.setLayout((Layout)gridLayout);
        GridData buttonGridData = new GridData(4, 4, true, false);
        buttonGridData.minimumHeight = 10;
        Button copyLinksCheckbox = new Button(checkboxComposite, 32);
        copyLinksCheckbox.setEnabled(true);
        copyLinksCheckbox.setSelection(this.copyLinksEnabled);
        copyLinksCheckbox.setText(Messages.UnifyPageMapping_8);
        copyLinksCheckbox.setLayoutData((Object)buttonGridData);
        final Button deleteSourceLinksCheckbox = new Button(checkboxComposite, 32);
        deleteSourceLinksCheckbox.setEnabled(false);
        deleteSourceLinksCheckbox.setText(Messages.UnifyPageMapping_9);
        deleteSourceLinksCheckbox.setSelection(this.deleteSourceLinksEnabled);
        deleteSourceLinksCheckbox.setLayoutData((Object)buttonGridData);
        deleteSourceLinksCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    UnifyPageMapping.this.setDeleteSourceLinksEnabled(((Button)e.getSource()).getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        copyLinksCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    UnifyPageMapping.this.setCopyLinksEnabled(((Button)e.getSource()).getSelection());
                    UnifyPageMapping.this.toggleButtonEnabled(deleteSourceLinksCheckbox, ((Button)e.getSource()).getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button copyAttributesCheckbox = new Button(checkboxComposite, 32);
        copyAttributesCheckbox.setEnabled(true);
        copyAttributesCheckbox.setText(Messages.UnifyPageMapping_10);
        copyAttributesCheckbox.setSelection(this.copyAttributesEnabled);
        copyAttributesCheckbox.setLayoutData((Object)buttonGridData);
        copyAttributesCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    UnifyPageMapping.this.setCopyAttributesEnabled(((Button)e.getSource()).getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    @Override
    protected void pageEntered() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Page entered...");
        }
        try {
            this.loadAndShowMapping();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading mappings.", (Throwable)e);
            this.showError(Messages.UnifyPageMapping_3);
        }
    }

    public boolean isPageComplete() {
        List<UnifyMapping> mappings = this.getUnifyWizard().getMappings();
        return mappings != null && !mappings.isEmpty();
    }

    private void loadAndShowMapping() {
        this.getUnifyWizard().loadMapping();
        List<UnifyMapping> mappings = this.getUnifyWizard().getMappings();
        if (mappings != null) {
            Collections.sort(mappings, COMPARATOR);
            this.table.setInput(mappings);
            this.table.refresh();
        }
        this.setPageComplete(this.isPageComplete());
    }

    private void showError(String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.UnifyPageMapping_4, (String)message);
    }

    private UnifyWizard getUnifyWizard() {
        return (UnifyWizard)this.getWizard();
    }

    private TableViewer createTable(Composite parent) {
        int defaultColumnWeight = 50;
        Composite tableComposite = new Composite(parent, 11);
        GridData tGd = new GridData(4, 4, true, true);
        tGd.minimumHeight = 87;
        tableComposite.setLayoutData((Object)tGd);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        TableViewer tableViewer = new TableViewer(tableComposite, 2818);
        Table internalTable = tableViewer.getTable();
        internalTable.setHeaderVisible(true);
        internalTable.setLinesVisible(true);
        GridData gd = new GridData(4, 4, true, true);
        tableViewer.getControl().setLayoutData((Object)gd);
        tableViewer.setUseHashlookup(true);
        TableViewerColumn sourceColumn = new TableViewerColumn(tableViewer, 0);
        sourceColumn.getColumn().setText(Messages.UnifyPageMapping_5);
        sourceColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                UnifyMapping mapping = (UnifyMapping)cell.getElement();
                String sourceTitle = mapping.getSourceElement().getTitle();
                if (sourceTitle != null) {
                    cell.setText(sourceTitle);
                }
                UnifyPageMapping.this.setCellColor(cell, mapping);
            }
        });
        tableColumnLayout.setColumnData((Widget)sourceColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        TableViewerColumn destinationColumn = new TableViewerColumn(tableViewer, 0);
        destinationColumn.getColumn().setText(Messages.UnifyPageMapping_6);
        destinationColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                UnifyMapping mapping = (UnifyMapping)cell.getElement();
                cell.setText(mapping.getDestinationText());
                UnifyPageMapping.this.setCellColor(cell, mapping);
            }
        });
        tableColumnLayout.setColumnData((Widget)destinationColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        return tableViewer;
    }

    protected void setCellColor(ViewerCell cell, UnifyMapping mapping) {
        List destinationList = mapping.getDestinationElements();
        if (destinationList == null || destinationList.isEmpty()) {
            cell.setBackground(this.colorNoMapping);
        } else if (!this.isTitleEquals(mapping)) {
            cell.setBackground(this.colorDifferentTitle);
        }
    }

    private boolean isTitleEquals(UnifyMapping mapping) {
        UnifyElement source = mapping.getSourceElement();
        String destinationText = mapping.getDestinationText();
        return source != null && source.getTitle() != null && destinationText != null && source.getTitle().equals(destinationText);
    }

    public boolean isCopyLinksEnabled() {
        return this.copyLinksEnabled;
    }

    public boolean isDeleteSourceLinksEnabled() {
        return this.deleteSourceLinksEnabled;
    }

    public void setCopyLinksEnabled(boolean copyLinksEnabled) {
        this.copyLinksEnabled = copyLinksEnabled;
        this.getUnifyWizard().setCopyLinks(copyLinksEnabled);
    }

    private void toggleButtonEnabled(Button b, boolean enabled) {
        if (b != null) {
            b.setEnabled(enabled);
        }
    }

    public void setDeleteSourceLinksEnabled(boolean deleteSourceLinksEnabled) {
        this.deleteSourceLinksEnabled = deleteSourceLinksEnabled;
        this.getUnifyWizard().setDeleteSourceLinks(deleteSourceLinksEnabled);
    }

    public boolean isCopyAttributesEnabled() {
        return this.copyAttributesEnabled;
    }

    public void setCopyAttributesEnabled(boolean copyAttributesEnabled) {
        this.copyAttributesEnabled = copyAttributesEnabled;
        this.getUnifyWizard().setDontCopyPropertyValues(copyAttributesEnabled);
    }

    class ActionLabelProvider
    extends ColumnLabelProvider {
        ActionLabelProvider() {
        }

        public String getText(Object element) {
            String text = Messages.UnifyPageMapping_7;
            if (element instanceof CnATreeElement) {
                text = ((CnATreeElement)element).getTitle();
            }
            return text;
        }
    }
}

