/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.unify;

import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.IllegalSelectionException;
import sernet.verinice.rcp.RightsEnabledHandler;
import sernet.verinice.rcp.unify.UnifyWizard;

public class UnifyHandler
extends RightsEnabledHandler {
    private static final Logger LOG = Logger.getLogger(UnifyHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Unify called...");
        }
        try {
            this.openUnifyWizard(event);
        }
        catch (IllegalSelectionException e) {
            LOG.warn((Object)"Wrong selection. Can not unify elements");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"stackstrace: ", (Throwable)e);
            }
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Error", (String)(String.valueOf(e.getMessage()) + " Please select two control groups."));
        }
        catch (Exception e) {
            LOG.error((Object)"Error while unifying elements.", (Throwable)e);
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Error", (String)"Error while unifying elements.");
        }
        return null;
    }

    private void openUnifyWizard(ExecutionEvent event) {
        List<CnATreeElement> selectedElements = this.getSelectedElements(event);
        this.validateElements(selectedElements);
        UnifyWizard wizard = new UnifyWizard(selectedElements);
        WizardDialog dialog = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private void validateElements(List<CnATreeElement> selectedElements) {
        if (selectedElements == null || selectedElements.isEmpty()) {
            throw new IllegalSelectionException("No element selected.");
        }
        if (selectedElements.size() < 2) {
            throw new IllegalSelectionException("Only one element selected.");
        }
        if (selectedElements.size() > 2) {
            throw new IllegalSelectionException("More than two elements selected.");
        }
        for (CnATreeElement element : selectedElements) {
            if ("controlgroup".equals(element.getTypeId())) continue;
            throw new IllegalSelectionException("Wrong element selected.");
        }
    }

    private List<CnATreeElement> getSelectedElements(ExecutionEvent event) {
        List elements = Collections.emptyList();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            try {
                elements = structuredSelection.toList();
            }
            catch (ClassCastException e) {
                LOG.warn((Object)"One of the selected element is not a CnATreeElement. Will not return any selected element.");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"stackstrace: ", (Throwable)e);
                }
                throw new IllegalSelectionException("Wrong element selected.");
            }
        }
        return elements;
    }

    public String getRightID() {
        return "unify";
    }
}

