/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.tree;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.LoadElementById;

public class TreeViewerUpdater {
    private static final Logger LOG = Logger.getLogger(TreeViewerUpdater.class);
    private TreeViewer viewer;

    public TreeViewerUpdater(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void add(Object parent, Object child) {
        if (parent != null && child != null) {
            TreeViewerUpdater.executeInRenderThread(() -> this.viewer.add(parent, child));
        }
    }

    public void refresh(Object child) {
        TreeViewerUpdater.executeInRenderThread(() -> this.viewer.refresh(child));
    }

    public void remove(Object child) {
        TreeViewerUpdater.executeInRenderThread(() -> this.viewer.remove(child));
    }

    public void refresh() {
        TreeViewerUpdater.executeInRenderThread(() -> {
            if (this.viewer != null) {
                this.viewer.refresh();
            }
        });
    }

    public void setInput(Object newModel) {
        Object newInput = this.getNewInput(newModel);
        TreeViewerUpdater.executeInRenderThread(() -> {
            if (!this.viewer.getTree().isDisposed()) {
                this.viewer.setInput(newInput);
            }
        });
    }

    private static void executeInRenderThread(Runnable r) {
        if (Display.getCurrent() != null) {
            r.run();
        } else {
            Display.getDefault().asyncExec(r);
        }
    }

    private Object getNewInput(Object newModel) {
        Object returnValue = newModel;
        Object oldInput = this.viewer.getInput();
        if (oldInput != null && !oldInput.getClass().equals(newModel.getClass()) && oldInput instanceof CnATreeElement) {
            CnATreeElement element = (CnATreeElement)oldInput;
            RetrieveInfo ri = new RetrieveInfo();
            ri.setProperties(true).setPermissions(true).setParent(true).setChildren(true).setSiblings(true);
            LoadElementById loadByUuid = new LoadElementById(element.getDbId(), ri);
            try {
                Activator.inheritVeriniceContextState();
                loadByUuid = (LoadElementById)ServiceFactory.lookupCommandService().executeCommand((ICommand)loadByUuid);
                element = loadByUuid.getElement();
                if (element.getParent() != null) {
                    element.getParent().setParent(null);
                }
                returnValue = element;
            }
            catch (CommandException e) {
                LOG.error((Object)"Error while reloading tree root", (Throwable)e);
            }
        }
        return returnValue;
    }
}

