/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.tree;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.bsi.editors.EditorUtil;
import sernet.verinice.model.bp.DeductionImplementationUtil;
import sernet.verinice.model.bp.IBpModelListener;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.IBSIModelListener;
import sernet.verinice.model.catalog.CatalogModel;
import sernet.verinice.model.catalog.ICatalogModelListener;
import sernet.verinice.model.common.ChangeLogEntry;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.IISO27KModelListener;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.model.validation.CnAValidation;
import sernet.verinice.rcp.tree.TreeViewerUpdater;
import sernet.verinice.service.tree.ElementManager;

public class TreeUpdateListener
implements IISO27KModelListener,
IBSIModelListener,
IBpModelListener,
ICatalogModelListener {
    private static final String ERROR_MESSAGE = "Error while updating treeview";
    private static final Logger LOG = Logger.getLogger(TreeUpdateListener.class);
    private TreeViewer viewer;
    private TreeViewerUpdater updater;
    private Object[] expandedElements = null;
    private ElementManager elementManager;

    public TreeUpdateListener(TreeViewer viewer, ElementManager elementManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Creating new TreeUpdateListener...");
        }
        this.viewer = viewer;
        this.updater = new TreeViewerUpdater(viewer);
        this.elementManager = elementManager;
    }

    public void databaseChildRemoved(CnATreeElement child) {
        try {
            this.getElementManager().elementRemoved(child);
            this.updater.remove(child);
        }
        catch (Exception e) {
            LOG.error((Object)ERROR_MESSAGE, (Throwable)e);
        }
    }

    public void databaseChildRemoved(ChangeLogEntry entry) {
        try {
            if (entry != null && entry.getUuid() != null) {
                this.getElementManager().elementRemoved(entry.getUuid());
                this.updater.refresh();
            }
        }
        catch (Exception e) {
            LOG.error((Object)ERROR_MESSAGE, (Throwable)e);
        }
    }

    public void childAdded(CnATreeElement parent, CnATreeElement child) {
        try {
            this.getElementManager().elementAdded(child);
            this.updater.add(parent, child);
            this.updater.refresh();
        }
        catch (Exception e) {
            LOG.error((Object)ERROR_MESSAGE, (Throwable)e);
        }
    }

    public void databaseChildAdded(CnATreeElement child) {
    }

    public void modelRefresh() {
    }

    public void modelRefresh(Object model) {
        try {
            this.updater.refresh();
        }
        catch (Exception e) {
            LOG.error((Object)ERROR_MESSAGE, (Throwable)e);
        }
    }

    public void childChanged(CnATreeElement child) {
        try {
            this.getElementManager().elementChanged(child);
            this.updater.refresh(child);
            String childType = child.getTypeId();
            if ("bp_requirement".equals(childType) || "bp_safeguard".equals(childType) || "bp_threat".equals(childType)) {
                RetrieveInfo retrieveInfo = new RetrieveInfo().setParent(true).setProperties(true).setChildren(true);
                CnATreeElement parent = Retriever.retrieveElement((CnATreeElement)child.getParent(), (RetrieveInfo)retrieveInfo);
                this.updater.refresh(parent);
            }
            if ("bp_threat".equals(childType)) {
                CnATreeElement childReloaded = Retriever.retrieveElement((CnATreeElement)child, (RetrieveInfo)new RetrieveInfo().setLinksDown(true).setLinksDownProperties(true));
                for (CnALink link : childReloaded.getLinksDown()) {
                    CnATreeElement targetObject = link.getDependency();
                    this.updater.refresh(targetObject);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)ERROR_MESSAGE, (Throwable)e);
        }
    }

    public void childRemoved(CnATreeElement parent, CnATreeElement child) {
    }

    public void databaseChildChanged(CnATreeElement child) {
        try {
            this.getElementManager().elementChanged(child);
            this.updater.refresh(child);
        }
        catch (Exception e) {
            LOG.error((Object)ERROR_MESSAGE, (Throwable)e);
        }
    }

    public void linkChanged(CnALink old, CnALink link, Object source) {
    }

    public void linkAdded(CnALink link) {
        this.linkAddedOrRemoved(link);
    }

    public void linkRemoved(CnALink link) {
        this.linkAddedOrRemoved(link);
    }

    private void linkAddedOrRemoved(CnALink link) {
        if (DeductionImplementationUtil.isRelevantLinkForImplementationStateDeduction((CnALink)link) && DeductionImplementationUtil.isDeductiveImplementationEnabled((CnATreeElement)link.getDependant())) {
            CnATreeElement requirement = link.getDependant();
            RetrieveInfo ri = RetrieveInfo.getPropertyChildrenInstance().setParent(true);
            requirement = Retriever.retrieveElement((CnATreeElement)requirement, (RetrieveInfo)ri);
            this.childChanged(requirement);
            EditorUtil.closeEditorForElement(requirement.getUuid());
        } else if ("bp_threat".equals(link.getDependant().getTypeId())) {
            CnATreeElement targetObject = Retriever.checkRetrieveElement((CnATreeElement)link.getDependency());
            this.updater.refresh(targetObject);
        }
    }

    public void modelReload(ISO27KModel newModel) {
        this.doModelReload(newModel);
    }

    public void modelReload(BSIModel newModel) {
        this.doModelReload(newModel);
    }

    public void validationAdded(Integer scopeId) {
    }

    public void validationRemoved(Integer scopeId) {
    }

    public void validationChanged(CnAValidation oldValidation, CnAValidation newValidation) {
    }

    private void doModelReload(Object model) {
        try {
            Display.getDefault().syncExec(() -> {
                try {
                    this.expandedElements = this.viewer.getExpandedElements();
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            });
            this.getElementManager().clearCache();
            this.updater.setInput(model);
            this.updater.refresh();
            ExpandJob job = new ExpandJob(this.expandedElements);
            job.setRule(new ExpandJobRule());
            job.schedule(50L);
        }
        catch (Exception e) {
            LOG.error((Object)ERROR_MESSAGE, (Throwable)e);
        }
    }

    protected ElementManager getElementManager() {
        return this.elementManager;
    }

    public void modelReload(BpModel newModel) {
        this.doModelReload(newModel);
    }

    public void modelReload(CatalogModel newModel) {
        this.doModelReload(newModel);
    }

    private final class ExpandJob
    extends Job {
        Object[] elements;

        private ExpandJob(Object[] elements) {
            super("Expanding");
            this.elements = elements != null ? (Object[])elements.clone() : null;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.setTaskName("Expanding element tree...");
            Display.getDefault().asyncExec(() -> {
                try {
                    TreeUpdateListener.this.viewer.setExpandedElements(this.elements);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            });
            return Status.OK_STATUS;
        }
    }

    private final class ExpandJobRule
    implements ISchedulingRule {
        private ExpandJobRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule.getClass() == ExpandJobRule.class;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule.getClass() == ExpandJobRule.class;
        }
    }
}

