/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.tree;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import sernet.gs.service.StringUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.views.CnAImageProvider;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.CnATreeElementLabelGenerator;

public class TreeLabelProvider
extends LabelProvider {
    private static final Logger LOG = Logger.getLogger(TreeLabelProvider.class);
    private static final int MAX_TEXT_WIDTH = 80;

    public Image getImage(Object obj) {
        Image image = ImageCache.getInstance().getImage("generic_element.gif");
        try {
            if (!(obj instanceof CnATreeElement)) {
                return image;
            }
            return CnAImageProvider.getImage((CnATreeElement)obj);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting image for tree item.", (Throwable)e);
            return image;
        }
    }

    public String getText(Object obj) {
        String text = "unknown";
        if (!(obj instanceof CnATreeElement)) {
            return text;
        }
        try {
            CnATreeElement element = (CnATreeElement)obj;
            String title = CnATreeElementLabelGenerator.getElementTitle((CnATreeElement)element);
            text = StringUtil.truncate((String)title, (int)80);
            if (LOG.isDebugEnabled()) {
                text = String.valueOf(text) + " (db: " + element.getDbId() + ", uu: " + element.getUuid() + ", scope: " + element.getScopeId() + ", ext: " + element.getExtId() + ")";
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting label for tree item.", (Throwable)e);
        }
        return text;
    }
}

