/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.tree;

import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import sernet.gs.service.Retriever;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.ElementComparator;
import sernet.verinice.model.common.ITitleAdaptor;
import sernet.verinice.service.tree.ElementManager;

public class TreeContentProvider
implements ITreeContentProvider {
    private static final Logger LOG = Logger.getLogger(TreeContentProvider.class);
    private static final ElementComparator<CnATreeElement> COMPARATOR = new ElementComparator((ITitleAdaptor)new ITitleAdaptor<CnATreeElement>(){

        public String getTitle(CnATreeElement element) {
            return element.getTitle();
        }
    });
    private ElementManager elementManager;

    public TreeContentProvider(ElementManager elementManager) {
        this.elementManager = elementManager;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = new CnATreeElement[]{};
        if (parentElement == null) {
            LOG.warn((Object)"Can not load children. Parent element is null.");
        } else if (!(parentElement instanceof CnATreeElement)) {
            LOG.warn((Object)("Can not load children. Parent element is no a CnATreeElement. Element class is: " + parentElement.getClass()));
        } else {
            children = this.getElementManager().getChildren((CnATreeElement)parentElement);
        }
        Arrays.sort(children, COMPARATOR);
        return children;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        if (element == null) {
            LOG.warn((Object)"Can not determine if elemant has children. Element is null.");
        } else if (!(element instanceof CnATreeElement)) {
            LOG.warn((Object)("Can not determine if elemant has children. Element is no a CnATreeElement. Element class is: " + element.getClass()));
        } else {
            hasChildren = this.getElementManager().hasChildren((CnATreeElement)element);
        }
        return hasChildren;
    }

    public Object getParent(Object element) {
        if (element instanceof CnATreeElement) {
            CnATreeElement elementWithParent;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getParent called for uuid: " + ((CnATreeElement)element).getUuid()));
            }
            if ((elementWithParent = Retriever.checkRetrieveParent((CnATreeElement)((CnATreeElement)element))) == null) {
                return null;
            }
            return elementWithParent.getParent();
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected ElementManager getElementManager() {
        return this.elementManager;
    }

    public void dispose() {
    }
}

