/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.tree;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.DefaultModelLoadListener;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.ITargetObject;
import sernet.hui.swt.SWTResourceManager;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.bp.DefaultBpModelListener;
import sernet.verinice.model.bp.IBpModelListener;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.tree.TreeLabelProvider;
import sernet.verinice.service.commands.bp.CheckAllReferencesCommand;
import sernet.verinice.service.commands.bp.CheckHasReferencesCommand;

public class BpTreeLabelProvider
extends TreeLabelProvider
implements IColorProvider,
IFontProvider {
    private static final Logger LOG = Logger.getLogger(BpTreeLabelProvider.class);
    private Map<Integer, Boolean> cache = new ConcurrentHashMap<Integer, Boolean>(10000);
    private Font fontElementWithReferences;
    private Color colorElementWithReferences;
    private final IBpModelListener listener = new DefaultBpModelListener(){

        public void linkRemoved(CnALink link) {
            this.handleLink(link);
        }

        public void linkChanged(CnALink old, CnALink link, Object source) {
            this.handleLink(old);
            this.handleLink(link);
        }

        public void linkAdded(CnALink link) {
            this.handleLink(link);
        }

        private void handleLink(CnALink link) {
            BpTreeLabelProvider.this.cache.remove(link.getDependant().getDbId());
            BpTreeLabelProvider.this.cache.remove(link.getDependency().getDbId());
        }

        public void modelReload(BpModel newModel) {
            BpTreeLabelProvider.this.cache.clear();
            BpTreeLabelProvider.this.populateCache();
        }
    };

    public BpTreeLabelProvider() {
        Font defaultFont = JFaceResources.getDefaultFont();
        FontData fontData = defaultFont.getFontData()[0];
        this.fontElementWithReferences = SWTResourceManager.getFont((String)fontData.getName(), (int)fontData.getHeight(), (int)2);
        this.colorElementWithReferences = SWTResourceManager.getColor((int)80, (int)95, (int)121);
        CnAElementFactory.getInstance().addLoadListener(new DefaultModelLoadListener(){

            @Override
            public void loaded(BpModel model) {
                CnAElementFactory.getInstance().removeLoadListener(this);
                model.addModITBOModelListener(BpTreeLabelProvider.this.listener);
                BpTreeLabelProvider.this.populateCache();
            }
        });
    }

    private void populateCache() {
        CheckAllReferencesCommand command = new CheckAllReferencesCommand();
        ICommandService commandService = (ICommandService)VeriniceContext.get((String)"commandService");
        try {
            command = (CheckAllReferencesCommand)commandService.executeCommand((ICommand)command);
            this.cache.putAll(command.getResult());
        }
        catch (CommandException e) {
            LOG.error((Object)"Error populating cache", (Throwable)e);
        }
    }

    public void dispose() {
        CnAElementFactory.getInstance().getBpModel().removeBpModelListener(this.listener);
        super.dispose();
    }

    public Color getForeground(Object o) {
        boolean currentElementHasReferences;
        CnATreeElement element = (CnATreeElement)o;
        boolean bl = currentElementHasReferences = element instanceof ITargetObject && this.cache.computeIfAbsent(element.getDbId(), this::checkHasReferences) != false;
        if (currentElementHasReferences) {
            return this.colorElementWithReferences;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Font getFont(Object o) {
        boolean currentElementHasReferences;
        CnATreeElement element = (CnATreeElement)o;
        boolean bl = currentElementHasReferences = element instanceof ITargetObject && this.cache.computeIfAbsent(element.getDbId(), this::checkHasReferences) != false;
        if (currentElementHasReferences) {
            return this.fontElementWithReferences;
        }
        return null;
    }

    private boolean checkHasReferences(Integer elementId) {
        CheckHasReferencesCommand command = new CheckHasReferencesCommand(elementId);
        ICommandService commandService = (ICommandService)VeriniceContext.get((String)"commandService");
        try {
            command = (CheckHasReferencesCommand)commandService.executeCommand((ICommand)command);
            return command.getResult();
        }
        catch (CommandException e) {
            LOG.error((Object)("Cannot determine referencing status for " + elementId), (Throwable)e);
            return false;
        }
    }
}

