/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.search.tables;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import sernet.verinice.model.search.VeriniceSearchResultTable;
import sernet.verinice.rcp.search.Messages;
import sernet.verinice.rcp.search.SearchView;
import sernet.verinice.rcp.search.column.ColumnStoreFactory;
import sernet.verinice.rcp.search.column.IColumn;
import sernet.verinice.rcp.search.column.IColumnStore;
import sernet.verinice.rcp.search.tables.ColumnContribution;

public class TableMenuListener
implements IMenuListener {
    private final SearchView searchView;
    private IColumnStore columnStore;
    private VeriniceSearchResultTable vSearchResultObject;

    public TableMenuListener(SearchView searchView, VeriniceSearchResultTable vSearchResultObject) {
        this.searchView = searchView;
        this.columnStore = ColumnStoreFactory.getColumnStore(vSearchResultObject.getEntityTypeId());
        this.vSearchResultObject = vSearchResultObject;
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.hasNoColumnEntries(manager)) {
            for (IColumn col : this.columnStore.getAllColumns()) {
                manager.add((IContributionItem)new ColumnContribution(this.searchView, col, this.vSearchResultObject));
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new RestoreDefaultAction());
        }
    }

    private boolean hasNoColumnEntries(IMenuManager manager) {
        return manager.getItems() != null && manager.getItems().length == 0;
    }

    private class RestoreDefaultAction
    extends Action {
        public RestoreDefaultAction() {
            this.setText(Messages.SearchView_6);
            this.setToolTipText(Messages.SearchView_6);
        }

        public void run() {
            TableMenuListener.this.columnStore.restoreDefault();
            TableMenuListener.this.searchView.setTableViewer(TableMenuListener.this.vSearchResultObject);
        }
    }
}

