/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.search.tables;

import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.swt.graphics.Image;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.verinice.model.search.VeriniceSearchResultRow;
import sernet.verinice.service.commands.CnATypeMapper;

public class TableImageProvider {
    private static final Logger LOG = Logger.getLogger(TableImageProvider.class);

    public static Image getImage(VeriniceSearchResultRow row) {
        ImageCache imgCache = ImageCache.getInstance();
        String imagePath = row.getValueFromResultString("icon-path");
        if (!imagePath.isEmpty()) {
            return imgCache.getCustomImage(imagePath);
        }
        String typeId = row.getParent().getEntityTypeId();
        LOG.debug((Object)("seach image for type id: " + typeId));
        if ("samt_topic".equals(typeId)) {
            return imgCache.getControlImplementationImage(TableImageProvider.getSamtTopicOptionStatus(row.getValueFromResultString("samt_topic_maturity")));
        }
        if ("control".equals(typeId)) {
            return imgCache.getControlImplementationImage(TableImageProvider.retrieveOptionStatus(row.getValueFromResultString("control_implemented")));
        }
        if ("mnums".equals(typeId)) {
            return imgCache.getImage(TableImageProvider.getMassnahmenUmsetzungsOptionStatus(row.getValueFromResultString("mnums_umsetzung")));
        }
        if ("gefaehrdungsumsetzung".equals(typeId)) {
            return imgCache.getImage("dialog-warning.png");
        }
        if (imgCache.hasDefaultImage(typeId)) {
            return imgCache.getImageForTypeId(typeId);
        }
        Optional<String> elementTypeId = TableImageProvider.findElementTypeIdWithDefaultImageByGroupTypeId(typeId);
        if (elementTypeId.isPresent()) {
            return imgCache.getImageForTypeId(elementTypeId.get());
        }
        return imgCache.getImage("generic_element.gif");
    }

    public static String getImagePath(VeriniceSearchResultRow row) {
        ImageCache imgCache = ImageCache.getInstance();
        String imagePath = row.getValueFromResultString("icon-path");
        if (!imagePath.isEmpty()) {
            return imagePath;
        }
        String typeId = row.getParent().getEntityTypeId();
        LOG.debug((Object)("search image for type id: " + typeId));
        if ("samt_topic".equals(typeId)) {
            return TableImageProvider.getSamtTopicOptionStatus(row.getValueFromResultString("samt_topic_maturity"));
        }
        if ("control".equals(typeId)) {
            return TableImageProvider.retrieveOptionStatus(row.getValueFromResultString("control_implemented"));
        }
        if ("mnums".equals(typeId)) {
            return TableImageProvider.getMassnahmenUmsetzungsOptionStatus(row.getValueFromResultString("mnums_umsetzung"));
        }
        if (imgCache.hasDefaultImage(typeId)) {
            return imgCache.getImageURL(typeId);
        }
        Optional<String> elementTypeId = TableImageProvider.findElementTypeIdWithDefaultImageByGroupTypeId(typeId);
        if (elementTypeId.isPresent()) {
            return imgCache.getImageURL(elementTypeId.get());
        }
        return "generic_element.gif";
    }

    private static Optional<String> findElementTypeIdWithDefaultImageByGroupTypeId(String typeId) {
        if (CnATypeMapper.isGroupTypeId((String)typeId)) {
            String elementTypeId = CnATypeMapper.getElementTypeIdFromGroupTypeId((String)typeId);
            if (ImageCache.getInstance().hasDefaultImage(elementTypeId)) {
                return Optional.of(elementTypeId);
            }
        }
        return Optional.empty();
    }

    private static String getSamtTopicOptionStatus(String status) {
        if (TableImageProvider.getTypeIDTranslation("samt_topic_maturity_null").equals(status)) {
            return "control_implemented_notedited";
        }
        return "control_implemented_yes";
    }

    private static String getMassnahmenUmsetzungsOptionStatus(String status) {
        if (TableImageProvider.getTypeIDTranslation("mnums_umsetzung_nein").equals(status)) {
            return "16-em-cross.png";
        }
        if (TableImageProvider.getTypeIDTranslation("mnums_umsetzung_ja").equals(status)) {
            return "16-em-check.png";
        }
        if (TableImageProvider.getTypeIDTranslation("mnums_umsetzung_teilweise").equals(status)) {
            return "16-clock.png";
        }
        if (TableImageProvider.getTypeIDTranslation("mnums_umsetzung_entbehrlich").equals(status)) {
            return "progress_rem.gif";
        }
        return "exclamation.png";
    }

    private static String retrieveOptionStatus(String status) {
        if (TableImageProvider.getTypeIDTranslation("control_implemented_no").equals(status)) {
            return "control_implemented_no";
        }
        if (TableImageProvider.getTypeIDTranslation("control_implemented_yes").equals(status)) {
            return "control_implemented_yes";
        }
        if (TableImageProvider.getTypeIDTranslation("control_implemented_notedited").equals(status)) {
            return "control_implemented_notedited";
        }
        if (TableImageProvider.getTypeIDTranslation("control_implemented_na").equals(status)) {
            return "control_implemented_na";
        }
        if (TableImageProvider.getTypeIDTranslation("control_implemented_partly").equals(status)) {
            return "control_implemented_partly";
        }
        return "generic_element.gif";
    }

    private static String getTypeIDTranslation(String id) {
        return HUITypeFactory.getInstance().getMessage(id);
    }
}

