/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.search.tables;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import sernet.gs.service.NumericStringComparator;
import sernet.verinice.model.search.VeriniceSearchResultRow;
import sernet.verinice.rcp.search.column.IColumn;
import sernet.verinice.rcp.search.column.IconColumn;
import sernet.verinice.rcp.search.column.ScopeColumn;
import sernet.verinice.rcp.search.column.TitleColumn;
import sernet.verinice.rcp.search.tables.TableImageProvider;

public class SearchTableComparator
extends ViewerComparator {
    IColumn currentColumn;
    NumericStringComparator numericStringComparator = new NumericStringComparator();
    int direction = 128;

    public void setColumn(IColumn currentColumn) {
        this.detectSortDirection(currentColumn);
        this.currentColumn = currentColumn;
    }

    private void detectSortDirection(IColumn currentColumn) {
        if (this.currentColumn == currentColumn) {
            this.inverseDirection();
        } else {
            this.direction = 128;
        }
    }

    private void inverseDirection() {
        this.direction = this.direction == 128 ? 1024 : 128;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        String v2;
        String v1;
        if (this.currentColumn == null) {
            return 0;
        }
        VeriniceSearchResultRow row1 = (VeriniceSearchResultRow)e1;
        VeriniceSearchResultRow row2 = (VeriniceSearchResultRow)e2;
        if (this.currentColumn instanceof TitleColumn) {
            v1 = row1.getValueFromResultString("title");
            v2 = row2.getValueFromResultString("title");
        } else if (this.currentColumn instanceof ScopeColumn) {
            v1 = row1.getValueFromResultString("scope-title");
            v2 = row2.getValueFromResultString("scope-title");
        } else if (this.currentColumn instanceof IconColumn) {
            v1 = TableImageProvider.getImagePath(row1);
            v2 = TableImageProvider.getImagePath(row2);
        } else {
            v1 = row1.getValueFromResultString(this.currentColumn.getId());
            v2 = row2.getValueFromResultString(this.currentColumn.getId());
        }
        if (this.direction == 1024) {
            return -this.numericStringComparator.compare((Object)v1, (Object)v2);
        }
        return this.numericStringComparator.compare((Object)v1, (Object)v2);
    }
}

