/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.search.tables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import sernet.hui.swt.SWTResourceManager;
import sernet.verinice.model.search.Occurence;
import sernet.verinice.model.search.VeriniceQuery;
import sernet.verinice.model.search.VeriniceSearchResultRow;
import sernet.verinice.rcp.search.column.IColumn;
import sernet.verinice.rcp.search.column.IconColumn;
import sernet.verinice.rcp.search.column.OccurenceColumn;
import sernet.verinice.rcp.search.column.PropertyTypeColumn;
import sernet.verinice.rcp.search.column.ScopeColumn;
import sernet.verinice.rcp.search.column.TitleColumn;
import sernet.verinice.rcp.search.tables.TableImageProvider;

public class SearchTableColumnLabelProvider
extends StyledCellLabelProvider {
    Color yellow = SWTResourceManager.getColor((int)7);
    Color white = SWTResourceManager.getColor((int)1);
    Color red = SWTResourceManager.getColor((int)3);
    private IColumn column;

    public SearchTableColumnLabelProvider(IColumn column) {
        this.column = column;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof VeriniceSearchResultRow) {
            VeriniceSearchResultRow row = (VeriniceSearchResultRow)element;
            if (this.column instanceof IconColumn) {
                cell.setImage(this.getImage(row));
                cell.setText("");
            } else if (this.column instanceof TitleColumn) {
                cell.setText(row.getValueFromResultString("title"));
                this.markMatches(cell);
            } else if (this.column instanceof ScopeColumn) {
                cell.setText(row.getValueFromResultString("scope-title"));
            } else if (this.column instanceof OccurenceColumn) {
                cell.setText(this.formatOccurences(row));
            } else if (this.column instanceof PropertyTypeColumn) {
                cell.setText(row.getValueFromResultString(this.column.getId()));
                this.markMatches(cell);
            }
        } else {
            throw new RuntimeException("unknown column class type");
        }
    }

    private String formatOccurences(VeriniceSearchResultRow row) {
        return StringUtils.join((Collection)row.getOccurence().getColumnNamesWithoutTitle(), (String)"\n");
    }

    private Image getImage(VeriniceSearchResultRow row) {
        return TableImageProvider.getImage(row);
    }

    private void markMatches(ViewerCell cell) {
        VeriniceSearchResultRow row = (VeriniceSearchResultRow)cell.getElement();
        Occurence occurences = row.getOccurence();
        VeriniceQuery query = row.getParent().getParent().getVeriniceQuery();
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>(0);
        if (query.isQueryEmpty()) {
            return;
        }
        if (this.column instanceof PropertyTypeColumn) {
            for (String fragment : occurences.getMatches(this.column.getId())) {
                this.createStyleRanges(cell, fragment, styleRanges);
            }
        }
        if (this.column instanceof TitleColumn) {
            this.createStyleRanges(cell, query.getQuery(), styleRanges);
        }
        cell.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
    }

    private void createStyleRanges(ViewerCell cell, String query, List<StyleRange> styleRanges) {
        int index = 0;
        while ((index = cell.getText().toLowerCase().indexOf(query.toLowerCase(), index)) != -1) {
            styleRanges.add(new StyleRange(index, query.length(), this.red, cell.getBackground()));
            ++index;
        }
    }
}

