/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.search.tables;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.verinice.model.search.VeriniceSearchResultRow;
import sernet.verinice.model.search.VeriniceSearchResultTable;
import sernet.verinice.rcp.search.column.IColumn;
import sernet.verinice.rcp.search.column.IColumnStore;
import sernet.verinice.rcp.search.column.IconColumn;
import sernet.verinice.rcp.search.tables.SearchTableColumnLabelProvider;
import sernet.verinice.rcp.search.tables.SearchTableComparator;

public class SearchResultsTableViewer
extends TableViewer
implements IStructuredContentProvider {
    private IColumnStore columnStore;
    private SearchTableComparator searchTableComparator;
    private Table table = this.getTable();

    public SearchResultsTableViewer(Composite parent, IColumnStore columnStore, VeriniceSearchResultTable veriniceSearchResultTable) {
        super(parent, 68354);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.searchTableComparator = new SearchTableComparator();
        this.setComparator(this.searchTableComparator);
        this.columnStore = columnStore;
        this.createColumns();
        this.setContentProvider((IContentProvider)this);
        this.setInput(veriniceSearchResultTable);
        this.defaultSort(columnStore);
    }

    private void createColumns() {
        for (final IColumn col : this.columnStore.getColumns()) {
            final TableViewerColumn columnViewer = new TableViewerColumn((TableViewer)this, 0);
            columnViewer.getColumn().setText(col.getTitle());
            columnViewer.getColumn().setMoveable(false);
            columnViewer.getColumn().setResizable(true);
            columnViewer.getColumn().setWidth(col.getWidth());
            columnViewer.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SearchResultsTableViewer.this.searchTableComparator.setColumn(col);
                    SearchResultsTableViewer.this.getTable().setSortColumn(columnViewer.getColumn());
                    SearchResultsTableViewer.this.refresh();
                }
            });
            if (col instanceof IconColumn) {
                columnViewer.getColumn().setText("");
            }
            columnViewer.setLabelProvider((CellLabelProvider)new SearchTableColumnLabelProvider(col));
            columnViewer.getColumn().addListener(11, (Listener)new ListenerImplementation(columnViewer, col));
        }
    }

    private void defaultSort(IColumnStore columnStore) {
        for (IColumn column : columnStore.getAllColumns()) {
            if (column instanceof IconColumn) continue;
            this.searchTableComparator.setColumn(column);
            this.refresh();
            return;
        }
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof VeriniceSearchResultTable) {
            VeriniceSearchResultTable object = (VeriniceSearchResultTable)inputElement;
            VeriniceSearchResultRow[] elements = new VeriniceSearchResultRow[object.getRows().size()];
            return object.getRows().toArray(elements);
        }
        return new Object[]{new PlaceHolder("loading")};
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private final class ListenerImplementation
    implements Listener {
        private final TableViewerColumn columnViewer;
        private final IColumn col;

        private ListenerImplementation(TableViewerColumn columnViewer, IColumn col) {
            this.columnViewer = columnViewer;
            this.col = col;
        }

        public void handleEvent(Event event) {
            this.col.setWidth(this.columnViewer.getColumn().getWidth());
        }
    }
}

