/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.search.column;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import sernet.gs.ui.rcp.main.Activator;
import sernet.hui.common.connect.EntityType;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.PropertyGroup;
import sernet.hui.common.connect.PropertyType;
import sernet.verinice.rcp.search.column.ColumnStore;
import sernet.verinice.rcp.search.column.IColumn;
import sernet.verinice.rcp.search.column.IColumnFactory;
import sernet.verinice.rcp.search.column.PropertyTypeColumn;

public class PersistentSortedColumnStore
extends ColumnStore {
    private static final String DEFAULT_TAG_BASIC = "basic";
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private String entityTypeId;
    private static final String COLUMN_PREFIX = "search_table_column_visibility_";
    private static final String COLUMNS_PERSISTED = "search_table_columns_preferences_";
    private static final String COLUMN_WIDTH = "search_table_column_width_";

    public PersistentSortedColumnStore(String entityTypeId) {
        this.entityTypeId = entityTypeId;
        if (!this.columnsArePersisted()) {
            this.restoreDefault();
        } else {
            this.initColumnStore();
        }
    }

    @Override
    public void restoreDefault() {
        IColumn iconColumn = IColumnFactory.getIconColumn(this);
        IColumn titleColumn = IColumnFactory.getTitleColumn(this);
        IColumn scopeColumn = IColumnFactory.getScopeColumn(this);
        IColumn occurenceColumn = IColumnFactory.getOccurenceColumn(this);
        this.addColumn(iconColumn);
        this.addColumn(titleColumn);
        this.addColumn(scopeColumn);
        this.addColumn(occurenceColumn);
        iconColumn.setWidth(32);
        titleColumn.setWidth(200);
        scopeColumn.setWidth(200);
        occurenceColumn.setWidth(200);
        int order = 0;
        for (PropertyType propertyType : this.getAllPropertyTypes()) {
            if (propertyType.isReference()) continue;
            IColumn col = IColumnFactory.getPropertyTypeColumn(propertyType, this, order++);
            this.preferenceStore.setValue(this.getPrefixForWidthProperty(col), 200);
            if (this.isDefaultColumn(col)) {
                this.addColumn(col);
                continue;
            }
            this.setVisible(col, false);
        }
        this.preferenceStore.setValue(COLUMNS_PERSISTED + this.entityTypeId, true);
    }

    private void initColumnStore() {
        IColumn iconColumn = IColumnFactory.getIconColumn(this);
        IColumn titleColumn = IColumnFactory.getTitleColumn(this);
        IColumn scopeColumn = IColumnFactory.getScopeColumn(this);
        IColumn occurenceColumn = IColumnFactory.getOccurenceColumn(this);
        this.setVisible(iconColumn, this.isColumnVisible(iconColumn));
        this.setVisible(titleColumn, this.isColumnVisible(titleColumn));
        this.setVisible(scopeColumn, this.isColumnVisible(scopeColumn));
        this.addColumn(occurenceColumn);
        int order = 0;
        for (PropertyType propertyType : this.getAllPropertyTypes()) {
            IColumn col;
            if (propertyType.isReference()) continue;
            if (this.isColumnVisible(col = IColumnFactory.getPropertyTypeColumn(propertyType, this, order++))) {
                this.addColumn(col);
                continue;
            }
            this.setVisible(col, false);
        }
    }

    private boolean columnsArePersisted() {
        return this.preferenceStore.getBoolean(COLUMNS_PERSISTED + this.entityTypeId);
    }

    @Override
    public boolean isColumnVisible(IColumn column) {
        return this.preferenceStore.getBoolean(this.getPropertyVisibilitySettingIdentifier(column));
    }

    private String getPropertyVisibilitySettingIdentifier(IColumn column) {
        return COLUMN_PREFIX + this.entityTypeId + column.getId();
    }

    public boolean isDefaultColumn(IColumn propertyType) {
        if (propertyType instanceof PropertyTypeColumn && ((PropertyTypeColumn)propertyType).getPropertyTags() != null) {
            return ((PropertyTypeColumn)propertyType).getPropertyTags().toLowerCase().contains(DEFAULT_TAG_BASIC);
        }
        return false;
    }

    public List<PropertyType> getAllPropertyTypes() {
        HUITypeFactory huiTypeFactory = HUITypeFactory.getInstance();
        EntityType entityType = huiTypeFactory.getEntityType(this.entityTypeId);
        List allElements = entityType.getElements();
        ArrayList<PropertyType> propertyTypes = new ArrayList<PropertyType>(0);
        for (Object obj : allElements) {
            if (obj instanceof PropertyType) {
                propertyTypes.add((PropertyType)obj);
            }
            if (!(obj instanceof PropertyGroup)) continue;
            for (PropertyType propertyType : ((PropertyGroup)obj).getPropertyTypes()) {
                propertyTypes.add(propertyType);
            }
        }
        return propertyTypes;
    }

    @Override
    public void addColumn(IColumn column) {
        super.addColumn(column);
        this.preferenceStore.setValue(this.getPropertyVisibilitySettingIdentifier(column), true);
    }

    @Override
    public void setVisible(IColumn column, boolean visible) {
        super.setVisible(column, visible);
        this.preferenceStore.setValue(this.getPropertyVisibilitySettingIdentifier(column), visible);
    }

    @Override
    public void setWidth(IColumn column, int width) {
        this.preferenceStore.setValue(this.getPrefixForWidthProperty(column), width);
    }

    private String getPrefixForWidthProperty(IColumn column) {
        return COLUMN_WIDTH + this.entityTypeId + column.getId();
    }

    @Override
    public int getWidth(IColumn column) {
        return this.preferenceStore.getInt(this.getPrefixForWidthProperty(column));
    }
}

