/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.search.column;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import sernet.hui.common.connect.PropertyType;
import sernet.verinice.model.search.VeriniceSearchResultRow;
import sernet.verinice.model.search.VeriniceSearchResultTable;
import sernet.verinice.rcp.search.column.ColumnComparator;
import sernet.verinice.rcp.search.column.ColumnSNCAComparator;
import sernet.verinice.rcp.search.column.IColumn;
import sernet.verinice.rcp.search.column.IColumnComparator;
import sernet.verinice.rcp.search.column.IColumnFactory;
import sernet.verinice.rcp.search.column.IColumnStore;

public class ColumnStore
implements IColumnStore {
    private SortedSet<IColumn> visibleColumns;
    private SortedSet<IColumn> invisibleColumns;

    public ColumnStore() {
        this(new ColumnSNCAComparator());
    }

    public ColumnStore(IColumnComparator comparator) {
        this.visibleColumns = new TreeSet<IColumn>(comparator);
        this.invisibleColumns = new TreeSet<IColumn>(comparator);
    }

    @Override
    public SortedSet<IColumn> getColumns() {
        return this.visibleColumns;
    }

    @Override
    public void addColumn(IColumn column) {
        this.visibleColumns.add(column);
        this.invisibleColumns.remove(column);
    }

    public void addInvisibleColumn(IColumn column) {
        this.visibleColumns.remove(column);
        this.invisibleColumns.add(column);
    }

    @Override
    public void restoreDefault() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<IColumn> getInvisible() {
        return this.invisibleColumns;
    }

    @Override
    public void setVisible(IColumn column, boolean visible) {
        if (visible) {
            this.addColumn(column);
        } else {
            this.addInvisibleColumn(column);
        }
    }

    @Override
    public SortedSet<IColumn> getAllColumns() {
        SortedSet<IColumn> allColumns = this.getColumns();
        allColumns.addAll(this.getInvisible());
        return allColumns;
    }

    @Override
    public boolean isColumnVisible(IColumn iColumn) {
        return this.visibleColumns.contains(iColumn);
    }

    @Override
    public int getWidth(IColumn iColumn) {
        return 200;
    }

    @Override
    public void setWidth(IColumn column, int width) {
    }

    public static IColumnStore createColumnStore(VeriniceSearchResultTable result) {
        ColumnStore columnStore = new ColumnStore(new ColumnComparator());
        Set rows = result.getAllResults();
        for (VeriniceSearchResultRow row : rows) {
            Set types = row.getPropertyTypes();
            for (String id : types) {
                PropertyType type = new PropertyType();
                type.setId(id);
                columnStore.setVisible(IColumnFactory.getPropertyTypeColumn(type, columnStore), true);
            }
        }
        return columnStore;
    }
}

