/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.search;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.search.VeriniceSearchResultRow;
import sernet.verinice.rcp.search.Messages;
import sernet.verinice.rcp.search.SearchView;
import sernet.verinice.service.commands.LoadElementByUuid;

final class TableDoubleClickListener
implements IDoubleClickListener {
    private final SearchView searchView;
    private ICommandService commandService;

    TableDoubleClickListener(SearchView searchView) {
        this.searchView = searchView;
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.isTableEnabled() && this.isRowSelected()) {
            try {
                VeriniceSearchResultRow row = this.getRow();
                LoadElementByUuid loadElementByUuid = this.loadCnATreeElementFromRDBM(row);
                this.openElementInEditor(loadElementByUuid);
            }
            catch (Exception t) {
                SearchView.LOG.error((Object)"Error while opening control.", (Throwable)t);
            }
        }
    }

    private void openElementInEditor(LoadElementByUuid loadElementByUuid) {
        if (loadElementByUuid.getElement() != null) {
            EditorFactory.getInstance().updateAndOpenObject(loadElementByUuid.getElement());
        } else {
            this.searchView.showError(Messages.SearchView_8, Messages.SearchView_7);
        }
    }

    private LoadElementByUuid loadCnATreeElementFromRDBM(VeriniceSearchResultRow row) throws CommandException {
        RetrieveInfo ri = RetrieveInfo.getPropertyInstance();
        LoadElementByUuid loadElementByUuid = new LoadElementByUuid(row.getValueFromResultString("uuid"), ri);
        loadElementByUuid = (LoadElementByUuid)this.getCommandService().executeCommand((ICommand)loadElementByUuid);
        return loadElementByUuid;
    }

    private VeriniceSearchResultRow getRow() {
        VeriniceSearchResultRow row = (VeriniceSearchResultRow)((IStructuredSelection)this.searchView.currentViewer.getSelection()).getFirstElement();
        return row;
    }

    private boolean isTableEnabled() {
        return this.searchView.currentViewer != null && this.searchView.currentViewer.getControl().isVisible();
    }

    private boolean isRowSelected() {
        return this.searchView.currentViewer.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)this.searchView.currentViewer.getSelection()).getFirstElement() instanceof VeriniceSearchResultRow;
    }

    private ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = ServiceFactory.lookupCommandService();
        }
        return this.commandService;
    }
}

