/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.search;

import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;
import sernet.gs.ui.rcp.main.bsi.dnd.SearchViewDragListener;
import sernet.gs.ui.rcp.main.bsi.dnd.SearchViewDropListener;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.IBSIStrukturElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.ISO27kElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.SearchViewElementTransfer;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.model.search.VeriniceQuery;
import sernet.verinice.model.search.VeriniceSearchResult;
import sernet.verinice.model.search.VeriniceSearchResultTable;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.rcp.search.CsvExportHandler;
import sernet.verinice.rcp.search.Messages;
import sernet.verinice.rcp.search.ReIndexJob;
import sernet.verinice.rcp.search.SearchComboViewer;
import sernet.verinice.rcp.search.SearchJob;
import sernet.verinice.rcp.search.TableDoubleClickListener;
import sernet.verinice.rcp.search.UpdateTableJob;
import sernet.verinice.rcp.search.VeriniceSearchResultComparator;
import sernet.verinice.rcp.search.tables.TableMenuListener;
import sernet.verinice.service.csv.CsvExportException;

public class SearchView
extends RightsEnabledView {
    static final Logger LOG = Logger.getLogger(SearchView.class);
    public static final String ID = "sernet.verinice.rcp.search.SearchView";
    private Text queryText;
    private Text limitText;
    private Button searchButton;
    private SearchComboViewer resultsByTypeCombo;
    TableViewer currentViewer;
    private Composite parent;
    private RightsEnabledAction export2CSV;
    private Action editMode;
    private IDoubleClickListener doubleClickListener;
    private RightsEnabledAction reindex;
    private Composite searchComposite;
    private Composite tableComposite;

    @Override
    public void createPartControl(Composite parent) {
        try {
            super.createPartControl(parent);
            this.parent = parent;
            this.initView(parent);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating control", (Throwable)e);
            ExceptionUtil.log(e, "Something went wrong here");
        }
    }

    @Override
    public void setFocus() {
        this.queryText.setFocus();
    }

    private void initView(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.createComposite(parent);
        this.makeActions();
        this.fillLocalToolBar();
        this.initDoubleClickListener();
    }

    private void makeActions() {
        this.export2CSV = new RightsEnabledAction("searchexport"){

            @Override
            public void doRun() {
                try {
                    SearchView.this.doCsvExport();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error during CSV export", (Throwable)e);
                    MessageDialog.openError((Shell)SearchView.getShell(), (String)Messages.SearchView_19, (String)(String.valueOf(Messages.SearchView_20) + e.getMessage()));
                }
            }
        };
        this.export2CSV.setText(Messages.SearchView_0);
        this.export2CSV.setToolTipText(Messages.SearchView_0);
        this.export2CSV.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("export.gif"));
        this.export2CSV.setEnabled(false);
        this.reindex = new RightsEnabledAction("searchreindex"){

            @Override
            public void doRun() {
                try {
                    SearchView.this.reindex();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while creating search index", (Throwable)e);
                    MessageDialog.openError((Shell)SearchView.getShell(), (String)Messages.SearchView_22, (String)(String.valueOf(Messages.SearchView_23) + e.getMessage()));
                }
            }
        };
        this.reindex.setText(Messages.SearchView_2);
        this.reindex.setToolTipText(Messages.SearchView_2);
        this.reindex.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("arrow_refresh.png"));
        this.switchButtonsToSearchEnabled();
    }

    private void initDoubleClickListener() {
        this.doubleClickListener = new TableDoubleClickListener(this);
    }

    private void doCsvExport() throws CsvExportException {
        StructuredSelection selection = (StructuredSelection)this.resultsByTypeCombo.getSelection();
        if (selection != null && !selection.isEmpty()) {
            VeriniceSearchResultTable result = (VeriniceSearchResultTable)selection.getFirstElement();
            CsvExportHandler handler = new CsvExportHandler(result, SearchView.getShell());
            handler.run();
        }
    }

    private void fillLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        if (this.export2CSV != null) {
            manager.add((IAction)this.export2CSV);
        }
        if (this.editMode != null) {
            manager.add((IAction)this.editMode);
        }
        if (this.reindex != null) {
            manager.add((IAction)this.reindex);
        }
    }

    private void createComposite(Composite parent) {
        Composite composite = this.createContainerComposite(parent);
        this.searchComposite = this.createSearchComposite(composite);
        this.createTitlesForSearchForm(this.searchComposite);
        this.createSearchForm(this.searchComposite);
        this.createResultCombobox(this.searchComposite);
        this.createTableComposite();
    }

    private Composite createContainerComposite(Composite parent) {
        Composite composite = new Composite(parent, 4);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    private Composite createSearchComposite(Composite composite) {
        Composite comboComposite = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        comboComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(4, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comboComposite.setLayout((Layout)gridLayout);
        return comboComposite;
    }

    private void createTitlesForSearchForm(Composite searchComposite) {
        Label queryTextLabel = new Label(searchComposite, 0);
        queryTextLabel.setText(Messages.SearchView_9);
        GridData queryTextLabelData = new GridData(1, 4, true, false);
        queryTextLabelData.horizontalSpan = 2;
        queryTextLabel.setLayoutData((Object)queryTextLabelData);
        Label limitTextLabel = new Label(searchComposite, 0);
        limitTextLabel.setText(Messages.SearchView_10);
        GridData limitTextLabelData = new GridData(1, 4, true, false);
        limitTextLabelData.horizontalSpan = 2;
        limitTextLabel.setLayoutData((Object)limitTextLabelData);
    }

    private void createSearchForm(Composite searchComposite) {
        this.createInputFields(searchComposite);
        this.searchButton = new Button(searchComposite, 524288);
        this.searchButton.setText(Messages.SearchView_3);
        this.searchButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SearchView.this.search();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        GridData searchButtonGridData = new GridData();
        searchButtonGridData.horizontalAlignment = 4;
        this.searchButton.setLayoutData((Object)searchButtonGridData);
    }

    private void createResultCombobox(Composite searchComposite) {
        this.resultsByTypeCombo = new SearchComboViewer(searchComposite, this);
        Combo resultCombo = this.resultsByTypeCombo.getCombo();
        GridData resultsByTypeComboGridData = new GridData();
        resultsByTypeComboGridData.horizontalAlignment = 4;
        resultsByTypeComboGridData.horizontalSpan = 4;
        resultCombo.setLayoutData((Object)resultsByTypeComboGridData);
    }

    private void createInputFields(Composite searchComposite) {
        this.createQueryInputField(searchComposite);
        this.createLimitInputField(searchComposite);
    }

    private void createQueryInputField(Composite searchComposite) {
        this.queryText = new Text(searchComposite, 2052);
        GridData gridData = new GridData(4, 0, true, false);
        gridData.minimumWidth = 30;
        gridData.horizontalSpan = 2;
        this.queryText.setLayoutData((Object)gridData);
        this.queryText.addKeyListener((KeyListener)new InputFieldsListener());
    }

    private void createLimitInputField(Composite searchComposite) {
        this.limitText = new Text(searchComposite, 2052);
        GridData gridLimitData = new GridData(4, 0, true, false);
        this.limitText.setLayoutData((Object)gridLimitData);
        this.limitText.setText(String.valueOf(200));
        this.limitText.addKeyListener((KeyListener)new InputFieldsListener());
        this.limitText.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
    }

    private void createTableComposite() {
        this.tableComposite = new Composite(this.searchComposite, 4);
        this.tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.tableComposite.setLayout((Layout)new FillLayout());
    }

    @Override
    public String getRightID() {
        return "searchview";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    public void updateResultCombobox(VeriniceSearchResult veriniceSearchResult) {
        this.resultsByTypeCombo.setInput(veriniceSearchResult);
        if (this.isResultEmpty(veriniceSearchResult)) {
            this.currentViewer.getTable().dispose();
        }
        if (!this.isResultEmpty(veriniceSearchResult)) {
            this.selectedFirstEntry(veriniceSearchResult);
        }
        this.resultsByTypeCombo.refresh();
    }

    private void selectedFirstEntry(VeriniceSearchResult veriniceSearchResult) {
        VeriniceSearchResultTable[] result = new VeriniceSearchResultTable[veriniceSearchResult.getAllVeriniceSearchTables().size()];
        result = veriniceSearchResult.getAllVeriniceSearchTables().toArray(result);
        Arrays.sort(result, new VeriniceSearchResultComparator());
        this.resultsByTypeCombo.setSelection((ISelection)new StructuredSelection((Object)result[0]));
    }

    private boolean isResultEmpty(VeriniceSearchResult veriniceSearchResult) {
        return veriniceSearchResult.getHits() == 0;
    }

    public Composite getParent() {
        return this.parent;
    }

    public void setTableViewer(VeriniceSearchResultTable veriniceSearchResultTable) {
        UpdateTableJob updateTable = new UpdateTableJob(this, veriniceSearchResultTable, this.tableComposite);
        updateTable.schedule();
    }

    void updateTable(TableViewer table, VeriniceSearchResultTable veriniceSearchResultTable) {
        try {
            if (this.currentViewer != null) {
                this.currentViewer.getTable().dispose();
            }
            this.currentViewer = table;
            this.addTableColumnContextMenu(veriniceSearchResultTable);
            this.currentViewer.addDoubleClickListener(this.doubleClickListener);
            Transfer[] dragTypes = new Transfer[]{SearchViewElementTransfer.getInstance()};
            Transfer[] dropTypes = new Transfer[]{SearchViewElementTransfer.getInstance(), IBSIStrukturElementTransfer.getInstance(), ISO27kElementTransfer.getInstance()};
            int operations = 3;
            this.currentViewer.addDragSupport(operations, dragTypes, (DragSourceListener)new SearchViewDragListener(this.currentViewer));
            this.currentViewer.addDropSupport(operations, dropTypes, (DropTargetListener)new SearchViewDropListener(this.currentViewer));
            this.tableComposite.layout();
        }
        catch (Exception ex) {
            LOG.error((Object)"table rendering failed", (Throwable)ex);
            this.showError(Messages.SearchView_25, ex.getLocalizedMessage());
            throw new RuntimeException(ex);
        }
    }

    private void addTableColumnContextMenu(VeriniceSearchResultTable veriniceSearchResultTable) {
        MenuManager menuMgr = new MenuManager("#ContextMenu");
        Menu menu = menuMgr.createContextMenu(this.currentViewer.getControl());
        menuMgr.addMenuListener((IMenuListener)new TableMenuListener(this, veriniceSearchResultTable));
        this.currentViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.currentViewer);
    }

    private void search() {
        if (this.isSearchConfirmed()) {
            this.validateAndCorrectLimit();
            VeriniceQuery veriniceQuery = new VeriniceQuery(this.queryText.getText(), Integer.valueOf(this.limitText.getText()).intValue());
            SearchJob job = new SearchJob(veriniceQuery, this);
            job.schedule();
        }
    }

    private boolean isSearchConfirmed() {
        boolean ok = false;
        int result = 0;
        if (this.isQueryEmpty()) {
            MessageDialog dialog = new MessageDialog(SearchView.getShell(), Messages.SearchView_29, null, Messages.SearchView_16, 4, new String[]{Messages.SearchView_27, Messages.SearchView_28}, 0);
            result = dialog.open();
        }
        return result == 0;
    }

    private void validateAndCorrectLimit() {
        try {
            int limit = Integer.valueOf(this.limitText.getText());
            if (limit <= 0) {
                this.limitText.setText(String.valueOf(200000));
            }
        }
        catch (NumberFormatException e) {
            this.limitText.setText(String.valueOf(200000));
        }
    }

    private boolean isQueryEmpty() {
        return this.queryText.getText() == null || "".equals(this.queryText.getText());
    }

    private void reindex() {
        if (this.isReindexConfirmed()) {
            ReIndexJob job = new ReIndexJob(this.reindex);
            job.addJobChangeListener(new IJobChangeListener(){

                public void scheduled(IJobChangeEvent arg0) {
                    ServiceFactory.lookupSearchService().setReindexRunning(true);
                }

                public void done(IJobChangeEvent arg0) {
                    ServiceFactory.lookupSearchService().setReindexRunning(false);
                }

                public void aboutToRun(IJobChangeEvent arg0) {
                }

                public void awake(IJobChangeEvent arg0) {
                }

                public void running(IJobChangeEvent arg0) {
                }

                public void sleeping(IJobChangeEvent arg0) {
                }
            });
            job.schedule();
            Activator.getDefault().setReindexJob(job);
        }
    }

    private boolean isReindexConfirmed() {
        boolean ok = false;
        if (ServiceFactory.lookupSearchService().isReindexRunning()) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.SearchView_33, (String)Messages.SearchView_34);
            return false;
        }
        MessageDialog dialog = new MessageDialog(SearchView.getShell(), Messages.SearchView_29, null, Messages.SearchView_30, 4, new String[]{Messages.SearchView_27, Messages.SearchView_28}, 0);
        return dialog.open() == 0;
    }

    public TableViewer getCurrentViewer() {
        return this.currentViewer;
    }

    private static Shell getShell() {
        return SearchView.getDisplay().getActiveShell();
    }

    static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected void showError(final String title, final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)SearchView.getShell(), (String)title, (String)message);
            }
        });
    }

    public void enableExport2CSVAction(boolean enable) {
        if (this.export2CSV.checkRights()) {
            this.export2CSV.setEnabled(enable);
        }
    }

    void disableSearch() {
        this.limitText.setEnabled(false);
        this.queryText.setEnabled(false);
        this.searchButton.setEnabled(false);
    }

    void enableSearch() {
        this.limitText.setEnabled(true);
        this.queryText.setEnabled(true);
        this.searchButton.setEnabled(true);
    }

    private void switchButtonsToSearchEnabled() {
        if (this.isSearchEnabled()) {
            this.enableSearch();
            this.reindex.setEnabled(true);
        } else {
            this.disableSearch();
            this.reindex.setEnabled(false);
        }
    }

    private boolean isSearchEnabled() {
        if (Activator.getDefault().isStandalone()) {
            return !Activator.getDefault().getPluginPreferences().getBoolean("search_disable");
        }
        return ServiceFactory.lookupSearchService().getImplementationtype() == 1;
    }

    private final class InputFieldsListener
    implements KeyListener {
        private InputFieldsListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\r') {
                SearchView.this.searchButton.setEnabled(false);
                SearchView.this.enableExport2CSVAction(false);
                SearchView.this.search();
                SearchView.this.searchButton.setEnabled(true);
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    }
}

