/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import sernet.verinice.model.search.VeriniceSearchResultRow;
import sernet.verinice.model.search.VeriniceSearchResultTable;
import sernet.verinice.rcp.search.MessagesCsvExport;
import sernet.verinice.rcp.search.column.ColumnStore;
import sernet.verinice.rcp.search.column.IColumn;
import sernet.verinice.rcp.search.column.IColumnStore;

public abstract class SearchResultTableConverter {
    private static final List<String> COLUMN_BLACKLIST = new LinkedList<String>();

    static {
        COLUMN_BLACKLIST.add("icon-path");
    }

    private SearchResultTableConverter() {
    }

    public static List<String[]> convertTable(VeriniceSearchResultTable result, IColumnStore columnStore) {
        IColumnStore converterColumnStore = columnStore;
        if (converterColumnStore == null) {
            converterColumnStore = ColumnStore.createColumnStore(result);
        }
        LinkedList<String[]> table = new LinkedList<String[]>();
        SearchResultTableConverter.disableBlacklistedColumns(converterColumnStore);
        table.add(SearchResultTableConverter.exportHeaderRow(converterColumnStore));
        Set rows = result.getAllResults();
        if (rows == null || rows.isEmpty()) {
            return table;
        }
        for (VeriniceSearchResultRow row : rows) {
            table.add(SearchResultTableConverter.exportRow(row, converterColumnStore));
        }
        if (result.getHits() >= result.getLimit()) {
            table.add(SearchResultTableConverter.exportLimitHintRow(result.getLimit()));
        }
        return table;
    }

    private static String[] exportHeaderRow(IColumnStore columnStore) {
        Iterator columns = columnStore.getColumns().iterator();
        String[] csvColumns = new String[columnStore.getColumns().size()];
        int i = 0;
        while (i < csvColumns.length) {
            IColumn column = (IColumn)columns.next();
            csvColumns[i] = column.getTitle();
            ++i;
        }
        return csvColumns;
    }

    private static String[] exportRow(VeriniceSearchResultRow row, IColumnStore columnStore) {
        SortedSet<IColumn> columns = columnStore.getColumns();
        String[] rowArray = new String[columns.size()];
        int i = 0;
        for (IColumn column : columns) {
            rowArray[i] = row.getValueFromResultString(column.getId());
            ++i;
        }
        return rowArray;
    }

    private static String[] exportLimitHintRow(int limit) {
        return new String[]{MessagesCsvExport.getString("CsvExport_1", limit)};
    }

    private static void disableBlacklistedColumns(IColumnStore columnStore) {
        HashSet<IColumn> visibleColumns = new HashSet<IColumn>(columnStore.getColumns());
        for (IColumn column : visibleColumns) {
            if (!COLUMN_BLACKLIST.contains(column.getId())) continue;
            columnStore.setVisible(column, false);
        }
    }
}

